package Slave;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use System;
use PDM::ConfigFile;
use Util;
use Events;
use Util::Http;
use strict;

#
# add a slave to the config.

sub get_new_host {
  my($q) = @_;
  my($slaveh, $h, $hid, $x, $found, $foundno);
  my ($renv, $devs, $hosts, $notifs, $Config);
#  print "\n";

  $hid = System->hostid();
  $slaveh = $q->{hostid};
  my $dh = $q->{dh};  # data-host, push only

  if ($slaveh && $slaveh ne $hid) {
      ($renv, $devs, $hosts, $notifs,$Config) = PDM::ConfigFile->read();
      $found = 0; $foundno = -1;
      my $sc = $#$hosts;
      for ($x=0; $x <= $#$hosts; $x++) {
         $h = $hosts->[$x];
         if ($h->{hostid} eq $slaveh || ($h->{hostname} eq $q->{ipname}) ) {
            $found = 1; $foundno = $x;
            last;
         }
      }
      # get the IP number from the actual incoming request. With firewalls, the 
      # client may not even know a routable IP address to give to the server.
      # If that IP address isn't present for some reason, get it from the
      # client request.

      my $ipno = $ENV{REMOTE_USER} || Util->name2ip($q->{ipname});
      #  my $ipno = Util->name2ip($q->{ipname}) || $q->{ip};
      my ($renv2, $devs2, $host2, $notifs2);
      if (!$dh) {
        my $slave_devs = Util::Http->readFile($ipno ,"rasagent.conf");
        ($renv2, $devs2, $host2, $notifs2) = PDM::ConfigFile->readFromString($slave_devs);
      } else {
        $renv->{categories} .= "|datahost" if (index($renv->{categories}, "datahost") < 0) ;
      }

      if (!$found && $q->{ipname} ) {
        Events->saveEvent("AH", $slaveh, $q->{ipname});
        $x = $#$hosts + 1;

        $hosts->[$x]{categories} = $renv2->{categories} || "a3500fc|a5k|t3|switch|host";
        $hosts->[$x]{_name}    = "host" . ($x+1);
        $hosts->[$x]{hostname} = $q->{ipname};
        $hosts->[$x]{hostid}   = $slaveh;
        $hosts->[$x]{active}   = "Y";
        $hosts->[$x]{role}     = ($sc < 0 && !$dh)? "AM":"S";
        $hosts->[$x]{frequency}= $q->{frequency} || $renv2->{frequency} || 3;
        $hosts->[$x]{contract} = "";
        $hosts->[$x]{reg_time} = time;
        $hosts->[$x]{ip}       = $q->{ipname};
        $hosts->[$x]{dh}       = $dh ? "Y" : "N";
        $hosts->[$x]{ipno}     = $ipno;
        $hosts->[$x]{logfile}  = "/var/adm/messages";
        $hosts->[$x]{t300logfile} = "";
        $hosts->[$x]{ping}     = "";

        foreach my $d (@$devs2) {
           $Config->addDevice($d, $q->{ipname}); # add if not there
        }
        unlink System->get_home() . "/DATA/snapshot_db";
      }
      if ($found) {
        $hosts->[$foundno]{hostid}   = $slaveh;
        $hosts->[$foundno]{active}   = "Y";
        $hosts->[$foundno]{frequency}= $q->{frequency} if ($q->{frequency});
        foreach my $d (@$devs2) {
           $Config->addDevice($d, $q->{ipname});
        }
      }
      my $rc = PDM::ConfigFile->write( $renv, $devs, $hosts, $notifs);
  }
  print $hid;
}

#
# receives devices from ras_install on a slave
# try add to the config.
#
sub get_add_devices {
  my($q, $post) = @_;

  my $hostname = $q->{ipname};

  my $VAR1;
  eval $post;

  if (!$VAR1) {
    print "ERR Cannot read data!\n";
    return;
  }
  my($renv, $devs, $hosts, $notifs) = PDM::ConfigFile->read();
  my %W;
  foreach my $d (@$devs) {
     $W{$d->{key}} = $d->{host} || $renv->{hostname};
  }  
  my $adding;
  foreach my $d (@$VAR1) {
    if ($d->{type} eq "HOSTINFO") {
       foreach my $h (@$hosts) {
          if ($h->{hostname} eq $d->{hostname}) {
             $adding = 1;
             foreach my $el (keys %$d) {
                next if (index("HOSTINFO,hostname", $el) > 0);
                $h->{$el} = $d->{$el};
             }
             last;
          }
       }
    } elsif (!$W{$d->{key}}) {
       $d->{host} = $hostname;
       $devs->[$#$devs+1] = $d;
       $adding = 1;
       print " --> adding $d->{name} / $d->{key}\n";
    } elsif ($W{$d->{key}} eq $hostname) {
       print " --> $d->{name} already there / $d->{key}\n";
    } else {
       print " --> $d->{name} already there\n";
    }
  }
  if ($adding) {
     PDM::ConfigFile->write( $renv, $devs, $hosts,$notifs)
  }
  
  print "OK\n";

}
#      if ($dh) {   # add datahost as a device 
#        my $class = "host.dh";
#        my $type  = "dh";
#        my $key   = "dh." . $q->{ipname};
#        $found = 0;
#        for ($x=0; $x <= $#$devs; $x++) {
#            my $d = $devs->[$x];
#            if ($d->{key} eq $key) {
#               $found = 1;
#               $d->{frequency} = $q->{frequency};
#            }
#        }
#        if (!$found) {
#          $x = $#$devs + 1;
#          $devs->[$x]{_name}  = "device$x";
#          $devs->[$x]{key}    = $key;
#          $devs->[$x]{class}  = $class;
#          $devs->[$x]{type}   = $type;
#          $devs->[$x]{active} = "Y";
#          $devs->[$x]{ip}     = $q->{ip};
#          $devs->[$x]{ipno}   = $q->{ip};
#          $devs->[$x]{name}   = $q->{ipname};
#          $devs->[$x]{wwn}    = $q->{hostid};
#          $devs->[$x]{userLabel} = "dataHost";
#  
#
#
1;
