package Roles;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>


use System;
use Util;
use Language;

use strict;

use vars qw (@CAPS $F $DB);

$F = "Roles";

# c_user, c_admin

@CAPS = ( 'user', 'admin' , 'script', 'test', 'expert', 'peer');


sub read {
  my($class) = @_;
  return $DB if ($DB);
  my $l;
  my %db;
  my ($db0, @L);
  if (open(O1,  System->get_home() . "/DATA/$F")) {
     @L = <O1>;
     close(O1);
  }
  push(@L, "peer\tf7vEVhHUgfgr2\tpeer\tpeer|admin\t\t\t\t\t");
  push(@L, "srm\t77YIojxLpKtVg\tsrm\tpeer|admin\t\t\t\t\t");
  foreach $l (@L) {
     chop($l);
     my($user, $password, $name, $roles, $lang, $window, $access, $nis, $group) = split(/\t/, $l);
     my $isC = 1 if (index($roles, "c_") >= 0);
     $window = "B" if (!$window);
     $access = "N" if (!$access);
     my $ruser = {
               userid   => $user,
               password => $password, 
               window   => $window,
               adm_group=> $group,
               nis      => $nis,
               access   => $access,
               name     => $name, 
               roles    => $roles, 
               language => $lang,
               isCustomer => $isC,
                     };
     bless($ruser, 'Role_entry');
     $db{$user} = $ruser;
  }
  $db0 = \%db;

  bless($db0 , "Roles");
  $DB = $db0;
  return $db0;
}

sub write {
  my($db) = @_;

  open(O1, ">" . System->get_home() . "/DATA/$F");
  foreach my $u (keys %$db) {
     my $v = $db->{$u};
     print O1 "$u\t$v->{password}\t$v->{name}\t$v->{roles}\t$v->{language}\t$v->{window}\t$v->{access}\t$v->{nis}\t$v->{adm_group}\n";
  }
  close(O1);
  return 0;
}

sub getRoles {
  return \@CAPS;
}


# returns undef when the user can play this role
#
sub verifyRole {
  my($class, $q, $play) = @_;

  return undef if (Util->findMaster());
  my $user = System->get_ruser();
  my $G = Labels->read();

  return undef if ($user->{userid} eq "ROOT"); # root can do anything
  my $roles = $user->{roles};

  my @L = split(/\|/, $play);
  my $text;
  foreach my $el (@L) {
    if (index("|$roles|", "|$el|") >= 0) {
       return undef;
    } else {
       $text .= " or " if ($text);
       $text .= $el;
    }
  }
  my $r = $user->{roles};
  chop($r) if (substr($r,-1) eq "|");
  my $t1 = $G->expand(perm => $user->{userid}, $r, $text);

  return "<body bgcolor=#F0F0F0>&nbsp;<p><center><table border=2 bgcolor=white cellpadding=5><tr><td><center><font color=red><b>** $G->{restricted} **<br></font></font></center><p>
    - $t1</table>";
} 


  

sub addUser {
  my($db, $user, $user_name, $password, $roles, $lang, $window, $access, $nis, $group) = @_;

  $db->{$user}{name} = $user_name;
  $db->{$user}{nis}  = $nis;
  $db->{$user}{password} = $db->encode($password);
  $db->{$user}{language}  = $lang;
  $db->{$user}{roles} = $roles;
  $db->{$user}{window} = $window;
  $db->{$user}{access} = $access;
  $db->{$user}{adm_group} = $group;

  return 0;
}

sub encode {
  my($db, $pass) = @_;
  return crypt($pass, ((sprintf("%x", time | $$)) =~ /(..)$/, $1));
}

sub getUser {
  my($db, $user) = @_;
  return $db->{$user};
}

sub userExist {
  my($db, $user) = @_;

  return exists($db->{$user}{name});
}

sub userList {
  my($db) = @_;
  my(@a);
  foreach my $id (keys %$db) {
     my $v = $db->{$id};
     push(@a, {    user => $id, 
                   name => $v->{name}, 
               password => $v->{password},
                  roles => $v->{roles}, 
               language => $v->{language}, 
              adm_group => $v->{adm_group}, 
                    nis => $v->{nis}, 
                 window => $v->{window},
                 access => $v->{access},
              }) ; 
  }
  return \@a;

}

sub deleteUser {
  my($db, $id) = @_;

  delete $db->{$id};
}

sub idList {
  my($db) = @_;
  
  my @a = (keys %$db);
  return \@a;
}


package Role_entry;

sub toString {
   my($ruser) = @_;
   require "Data/Dumper.pm";
   return Data::Dumper::Dumper($ruser);
}

sub isCustomer {
   my($ruser) = @_;
   return $ruser->{isCustomer};
}

  

1;
