package Reports::Fru;
use Report;
use strict;
use vars qw($ERR $OK);
use Process;

sub log1 {
  my($l) = @_;
  open(W, ">>/tmp/x");
  print W "$l\n";
  close(W);
}


sub new {
  my($class, $new, $arg) = @_;
  my ($REP, $out, @LIST);
  my $renv = System->get_renv();

  my $filename = $arg->{filename} || "fru_report";
  my $F  = "/tmp/$filename";
  my $F1 = System->get_home() . "/DATA/$F";
  if (!$new) {
     $REP = Util->deserialize($F);
     return $REP;
  }
  unlink $F1;
  $ERR = "";
  my $list = Report->reportList();
  Modules->load("Agent");
  foreach my $k (sort keys %$list) {
       my $el = $list->{$k};
       my $type = $el->[1];
       my $host = $el->[0];
       my $name = $el->[4] || $k;
       my $date = $el->[2];
       my ($err, $VAR1) = Report->readReport($k, $host, 10);
       if ($err) {
          $out .= $err;
          next;
       }
       my $module = "Agent::" . uc($type);
       if ($module->can("FRUS")) {
          my $rep = $module->FRUS($VAR1, $name);
          push(@LIST, @$rep);
       }
  }
  $REP = \@LIST;
  bless($REP, 'Reports::Fru');
  Util->serialize($F, $REP);
  $ERR = $out;
  return $REP;
  Process->done("fru_report");
}

$OK = ",online,ok,ok-on,ready-enabled,normal," .
      "online-online,o.k.,-,drive_inserted,n/a,"
      ;

sub health {
  my($class, $REP) = @_;
  my @NEW;
  foreach my $el  (@$REP) {
    my $st = Util->trim($el->[8]);
    next if (index($OK, lc(",$st,") ) >= 0);
    push(@NEW, $el);
  }
  return \@NEW;
}


sub summ1 {
  my($REP) = @_;
  my (@R,%R);
  foreach my $el (@$REP) {
     my $name = $el->[0];
     my $dev  = $el->[1];
     my $typ  = $el->[2];

     my $vendor = $el->[4];
     my $model  = $el->[5];
     my $rev    = $el->[7];
     $R{"$name\t$dev\t$typ\t$vendor\t$model\t$rev"}++;
  }
  foreach my $el (sort keys %R) {
     my($name, $dev, $type, $vendor, $model, $rev) = split(/\t/, $el);
     my $tot = sprintf("%6d", $R{$el});
     push(@R, [$name, $dev, $type, $vendor, $model, $rev, $tot]);
  }
  return \@R;
}

sub summ2 {
  my($REP) = @_;

   my (%R, @R, $tot);
  foreach my $el (@$REP) {
     my $name = $el->[0];
     my $dev  = $el->[1];
     my $typ  = $el->[2];

     my $vendor = $el->[4];
     my $model  = $el->[5];
     my $rev    = $el->[7];
     $R{"$dev\t$typ\t$vendor\t$model\t$rev"}++;
  }
  foreach my $el (sort keys %R) {
     my($dev, $type, $vendor, $model, $rev) = split(/\t/, $el);
     my $no = sprintf("%6d", $R{$el});
     my $lnk = $no; # "<a href=<a href=$Http::WEBPROC?GO=GUI::FruReport::summ3>$no</a>";
     push(@R, [$dev, $type, $vendor, $model, $rev, $lnk]);
     $tot += $no;
  }
  return(\@R, $tot);
}

sub battery {
  my($REP) = @_;
  my (@R,%R);
  my $tot;
  foreach my $el (@$REP) {
     my $name = $el->[0];
     my $dev  = $el->[1];
     my $typ  = $el->[2];
     my $fru  = $el->[3];
     next if ($typ ne "power.battery");
     $tot++;
     my $rev    = $el->[7];
     my $bat_age = $el->[10];
     push(@R, [sprintf("%7.7d", $bat_age), $name,$fru]);
  }
  return (\@R, $tot);
}

# arg->{ucl}, return only frus that are abovr UCL

sub temperature {
  my($REP, $arg) = @_;
  my (@R, %T, $tot);
  my (@Temp);
  my $ucl_only = $arg->{ucl};

  foreach my $el (@$REP) {
    my $temp = $el->[9];
    next if (!$temp);
    $temp = 100 if ($temp > 100);
    $temp = 0   if ($temp < 0);
    push(@Temp, $el->[9]);
  }

  my($std, $avg, $lcl, $ucl) = Math->std_dev(\@Temp);

  if ($ucl_only) {
    foreach my $el (@$REP) {
      my $name = $el->[0];
      my $dev  = $el->[1];
      my $typ  = $el->[2];
      my $fru  = $el->[3];
      next if (!defined $el->[9]);

      my $temp = int($el->[9]);
      $temp = 0 if ($temp <= 0 );
      $temp = 100 if ($temp >= 100);
      if ($temp >= $ucl) {
        push(@R, $el); 
        $tot++;
      }
    }
    return (\@R, $tot, $std, $avg, $lcl, $ucl);
  }
     
# return a temperature distribution

  foreach my $el (@$REP) {
     my $name = $el->[0];
     my $dev  = $el->[1];
     my $typ  = $el->[2];
     my $fru  = $el->[3];
     next if (!defined $el->[9]);

     my $temp = int($el->[9]);
     $temp = 0 if ($temp <= 0 );
     $temp = 100 if ($temp >= 100);
     $T{$name}[$temp]++;
  }
  my($x);
  foreach my $name (sort keys %T) {
     my $val = $T{$name};
     my ($list, $low, $high);
     $low = 1000;
     for ($x=0; $x <= $#$val; $x++) {
         my $v = $val->[$x];
         $low  = $x if ($v && $x < $low);
         $high = $x if ($v && $x > $high);
         $v = "X" if ($v > 9);
         if ($x <= $lcl || $x >= $ucl) {
           $v = "<b><font color=red>$v</font></b>";
         } elsif ($x == int($avg+ 0.5)) {
           $v = "<b><font color=blue>$v</font></b>";
         }
         $list .= $val->[$x] ? $v : " ";
     }
     $tot++;
     push(@R, [$name, "<pre>$list", $low, $high]);
  }
  return (\@R, $tot, $std, $avg, $lcl, $ucl);
}


1;

