package Reports::Exception;
use Report;
use strict;
use vars qw($ERR $OK);
use Process;
use ConfigFile;

sub log1 {
  my($l) = @_;
  open(W, ">>/tmp/x");
  print W "$l\n";
  close(W);
}


sub new {
  my($class, $new, $arg) = @_;
  my ($REP, $out, @LIST);
  my $renv = System->get_renv();

  my $filename = $arg->{filename} || "exception_report";
  my $F  = "/tmp/$filename";
  my $F1 = System->get_home() . "/DATA/$F";
  if (!$new) {
     $REP = Util->deserialize($F);
     return $REP;
  }
  unlink $F1;
  $ERR = "";
  my $list = Report->reportList();

# use _ANY_ to accept any value

  my $ex  = ConfigFile->read(System->get_home() . "/System/exception.conf", "id");
  my $ex2 = ConfigFile->read(System->get_home() . "/DATA/exception.conf",   "id");

  foreach my $k (keys %$ex2) {
     $ex->{$k} = $ex2->{$k};
  }
  my %PAT;
  foreach my $el (keys %$ex) {
      if ($el =~ /\\/) {
         $PAT{$el} = $ex->{$el};
      }
  }

  foreach my $k (sort keys %$list) {
       my $el = $list->{$k};
       my $type = $el->[1];
       my $host = $el->[0];
       my $name = $el->[4] || $k;
       my $date = $el->[2];
       my ($err, $VAR1) = Report->readReport($k, $host, 12);
       if ($err || !$VAR1) {
          $out .= $err;
          next;
       }
       my $REP= $VAR1->{_value};
       foreach my $x (keys %$REP) {

          if (exists $ex->{"$type.$x"} ) {
             my $good_value = $ex->{"$type.$x"}{value};
             next if ($good_value eq "_ANY_");
             my $ex_name = $ex->{"$type.$x"}{name};
             next if (index("|$good_value|", "|$REP->{$x}|") >= 0);
             my ($fru, $rest)  = split(/\./, $x, 2);
             push(@LIST, [$name, $type, $fru, $rest, $ex_name, $REP->{$x},  $good_value]);
          
          } else {
             foreach my $p (keys %PAT) {
               if ("$type.$x" =~ /^$p$/) {
                 my $good_value = $PAT{$p}{value};
                 my $ex_name    = $PAT{$p}{name};
                 next if ($good_value eq "_ANY_");
                 next if (index("|$good_value|", "|$REP->{$x}|") >= 0);
                 my ($fru, $rest)  = split(/\./, $x, 2);
                 push(@LIST, [$name, $type, $fru, $rest, $ex_name, $REP->{$x}, $good_value]);
               }
             }
             
          }
       }
  }
  $REP = \@LIST;
  bless($REP, 'Reports::Exception');

  Util->serialize($F, $REP);
  $ERR = $out;
  return $REP;
  Process->done("exception_report");
}




1;

