package Provider::SAE;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>


#  $Id: SAE.pm,v 1.23 2003/09/26 20:08:58 ccadieux Exp $

use PDM;
use Carp;
use Message;
use Grid;
use Util;
use strict;
use TO;
use HBA;

use base 'Provider';
sub revision {'$Revision: 1.23 $'}

sub new {
  my($self, $pdm)  = @_;

  my($p) = { pdm => $pdm };
  bless($p,'Provider::SAE');
  return $p;
}

sub description {"SAE"}

sub ISACTIVE {
  my($class, $renv) = @_;
  my $o = $renv->{'pro.sae.active'} eq "Y" ? "(On)" : "(Off)";
  return $o;
}

sub UPDATE {
  my($class, $q) = @_;
  my($active, $ip, $proxy, $to, $err, $name, $nat, $info, $ip2);
  my($renv, $dev, $host,$notifs, $o);
  my $deny = Roles->verifyRole($q, "admin");
  my $G = Labels->read();
  my $L = Labels->read('Provider')->section('sae');

  if ($q->{ACTION_update}) {
    ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
    $renv->{'pro.sae.active'}     = $q->{active}? "Y":"N";
    $renv->{'pro.sae.ip'}         = $q->{ip};
    $renv->{'pro.sae.format'}     = 1;
    $renv->{'pro.sae.components'} = $q->{components} ? "Y" : "N";
    $renv->{'pro.sae.frequency'}  = ($q->{freq} +0) || 6;
    PDM::ConfigFile->write( $renv, $dev, $host,$notifs);
    $err .= Html->info($L->{update});
  }

  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read();
  my($dh_active, $dh_info, $ck_active);

  if ($renv->{'pro.sae.active'} eq "Y") {
    $ck_active = "<input type=checkbox name=active checked>";
  } else {
    $ck_active = "<input type=checkbox name=active>";
    $info      = "<font color=red><b>$G->{inactive}</b>";
  }
  $ip      = $renv->{'pro.sae.ip'};
  my $freq = $renv->{'pro.sae.frequency'};
  my $ck1  = $renv->{'pro.sae.components'} eq "Y"? "checked" : "";

  $o .=<<EOF;
$err
<form  method=get>
 <input type=hidden name=GO value=GUI::Providers::display>
 <input type=hidden name=option value=$q->{option}>
<center>
<table border=1 cellspacing=0 cellpadding=2 width=90% bgcolor=white><tr><td>
<table border=0 cellspacing=2 width=100%>
      <tr>
      <td colspan=2 bgcolor=$Style::DARK><b><font color=white>&nbsp;$L->{label}</td>
      <tr><td bgcolor=$Style::LIGHT align=right>$G->{active}:</td>
        <td>$ck_active $info
      <tr><td bgcolor=$Style::LIGHT align=right>$L->{dev_ip}:</td>
        <td><input type=text name=ip value=\"$ip\" size=60>
      <tr><td bgcolor=$Style::LIGHT align=right>$L->{heartbeat}:</td>
        <td><input type=text name=freq value=\"$freq\" size=2 maxlength=2>&nbsp;$L->{minutes}
</table> </table> <b>
EOF

  if (!$deny) {
     $o .= "<b><input type=submit name=ACTION_update value=$G->{submit_update}>";
  }
  $o .= "</form>";
  return $o;

}
#      <tr><td bgcolor=$Style::LIGHT align=right>$L->{devEvents}:</td>
#        <td><input type=checkbox name=components $ck1>


sub RUN {
  my($pro) = @_;
  my($notifs, $notif, $p, $ed, $id, $admin, $eventType);

  my($pdm)   = $pro->{pdm};
  my($ed_desc, $email_text);
  my($edocs) = $pdm->getMessages;
  my($hostname) = System->hostname();

  my $L = Labels->read('Provider')->section('sae');
  my($renv, $devices, $hosts, $notifs) = PDM::ConfigFile->read();
  $DB::single = 1;

  if ($renv->{'pro.sae.active'} ne "Y") {
     Debug->print2("  not active, skipping.");
     return;
  }

  my $format = $renv->{'pro.sae.format'};
  my $compFlag = $renv->{'pro.sae.components'};

  my (@devEvents, %SAVE);
  # 
  foreach $ed (@$edocs) {   # Each Message.
      next if ($ed->type() eq Message::TYPE_ALERT); # Skip alerts
      my $cat     = $ed->id("category"); # A5/T3 ...
      my $ev      = $ed->instances()->[0];
      my $mgmtLevel= $ev->value("MgmtLevel");
      if ($mgmtLevel eq "C" && ($cat eq "t3" || $cat eq "6120")) {
        my $target  = $ev->value("Target");
        push(@{$SAVE{$target}}, $ed);
      }
  }

  foreach $ed (@$edocs) {   # Each Message.
      next if ($ed->type() eq Message::TYPE_ALERT); # Skip alerts
      my $cat     = $ed->id("category"); # A5/T3 ...
      my $ev      = $ed->instances()->[0];
      my $agent   = $ed->instances()->[1];
      my $etype0  = $ev->value('EventType');
      my $sev     = $ev->value("Severity");
      my $target  = $ev->value("Target");
      my $mgmtLevel= $ev->value("MgmtLevel");
      my $g_code  = $ev->value("GridCode");
      my $g_no    = $ev->value("GridNo");
      my $caption = $ev->value('Caption');
      my $component = $ev->value('Component');
      my $source  = $agent->value('IdentificationCode') if ($agent);

      my($g_info, $g_cause, $g_action) = 
                         Grid->getInfoString($etype0, $caption, $g_code);
      my $new = {};
      foreach $p (@{$ev->properties()} ) {
         my $n = $p->name();
         next if ($n eq "Data");
         $new->{$n} = $p->value();
      }
      $new->{category}   = $cat;
      $new->{source}     = $source;
      $new->{grid_info}  = $g_info;
      $new->{grid_cause} = $g_cause;
      $new->{grid_action}= $g_action;
      $new->{grid_code}  = $g_no;
      $new->{renv_version}= $renv->{version};

      my($t1, $k1, $extra) = split(/\:/, $target);
      $target = "$t1:$k1";
      &addDelta($new, $target, $component);

      if ($mgmtLevel eq "C") {
         push(@devEvents,$new) if ($compFlag eq "Y");
      } else {
         push(@devEvents,$new);
      }
      if ($mgmtLevel eq "DS") {
         my $org = State->eventHash($ev->value("OriginalEvent"));
         my($org_cat, $rest) = split(/\./, $org->{EventType});
         if ($org_cat eq "t3" || $org_cat eq "6120") {
            my $org_target = $org->{Target};
            my $org_caption = $org->{Caption};
            my $startID = $ev->value('EventId');
            my $cnt = 2;
            foreach my $ed1 (@{$SAVE{$org_target}}) {
                my $ev1 = $ed1->instances()->[0];
                my $etype1   = $ev1->value('EventType');
                my $caption1 = $ev1->value('Caption');
                my $g_no1    = $ev1->value('GridNo');
                if ($caption1 ne $org_caption) {
                   my $new2 = {%$new};
                   $new2->{EventId} = "${startID}$cnt"; $cnt++;
                   $new2->{OriginalEvent} = 
                  "EventType="  . $ev1->value("EventType") .
                  "|Target="    . $ev1->value("Target") .
                  "|TargetName=". $ev1->value("TargetName") .
                  "|Caption="   . $ev1->value("Caption") .
                  "|Actionable=". $ev1->value("Actionable") .
                  "|SourceIP="  . $ev1->value("SourceIP") .
                  "|Severity="  . $ev1->value("Severity") .
                  "|PriorState="    . $ev1->value("PriorState") .
                  "|CurrentState="  . $ev1->value("CurrentState") .
                  "|CurrentValue="  . $ev1->value("CurrentValue") .
                  "|grid_code=$g_no1";
                   my $desc2 = $ev->value("Description");
                   my $ix = index($desc2, ":");
                   if ($ix > 0) {
                      $new2->{Description} = substr($desc2,0,$ix) . ": " . 
                                             $ev1->value("Description");
                   }
                   push(@devEvents, $new2);
                }
            }
         }
      }
         
  }
  
  &send(\@devEvents, $renv->{'pro.sae.ip'}, $format);

}

sub addDelta {
  my($new, $target, $component) = @_;
  my $report = Report->readNew($target);
  my $old    = Report->readOld($target);
  if ($report) {
     if (!$old) {
       my $subreport = $report->subset($component);
       foreach my $k (sort keys %$subreport) {
          $new->{"InstrReport.$component.$k"} = $subreport->{$k};
       }
     } else {
       my $new_rep = $report->value();
       my $old_rep = $old->value();
       my (%SEND);
       foreach my $el (sort keys %$new_rep) {
          if ($new_rep->{$el} ne $old_rep->{$el}) {
             my $ix = rindex($el, ".");
             my $v = $ix > 0 ? substr($el, 0, $ix) : $el;
             $SEND{$v} = 1;
          }
       }
       foreach my $el (sort keys %$new_rep) {
          my $ix = rindex($el, ".");
          my $v = $ix > 0 ? substr($el, 0, $ix) : $el;
          if ($SEND{$v}) {
            $new->{"InstrReport.$el"} = $new_rep->{$el};
          }
       }
     }
   } else {
     Debug->print2("SAE: no report for $target");
   }
}

sub send {
  my($events, $ip, $format) = @_;

  return if ($#$events < 0);
  return if (!$ip);
  my ($out, $x);
  for ($x=0; $x <= $#$events; $x++) {
     my $e = $events->[$x];
     $out .= "<event no=\"$x\">\n" if ($format != 1);
     foreach my $el (sort keys %$e) {
       if ($format  == 1) {
          my $v = $e->{$el}; $v =~ s/\n/ /g;
          $out .= "event.$x.$el\t$v\n";
       } else {
          $out .= "  <element name=\"$el\">$e->{$el}</element>\n";
       }
     }
     $out .= "</event>\n" if ($format != 1);
  }

  my $url =  ($ip =~ /^http/) ? $ip : "http://$ip";

  my $SAVE = System->get_home() . "/DATA/sae";
  
  my $date = Util->get_today();
  $date =~ s/ /_/g;
  open(O, ">>$SAVE/$date");
  print O $out;
  close(O);
  
  my($err, $resp) = Util::Http->post($url, $out, 20);
  print "SAE: $err\n" if ($err);
}
  
1;
