package Provider::NetConnect;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: NetConnect.pm,v 1.28 2003/06/20 00:21:46 ccadieux Exp $

use PDM;
use PDM::ConfigFile;
use Carp;
use Message;
use Util;
use System;
use Util::Http;

use base 'Provider';
sub revision {'$Revision: 1.28 $'}

sub description {'Net Connect'}

sub new {
  my($self, $pdm)  = @_;

  my($p) = { pdm => $pdm };

  bless($p,'Provider::NetConnect');
  return $p;
}

# http://shadow:8080/servlet/InsertService

sub UPDATE {
  my($class, $q) = @_;
  my($active, $ip, $proxy, $to, $err, $info, $warn);
  my $deny = Roles->verifyRole($q, "admin");
  my $G = Labels->read();
  my $L = Labels->read('Provider')->section('netconnect');

  if ($q->{ACTION_update}) {
    my $package_base = System->getPackageInfo("", "SUNWnc01", "BASEDIR");
    if (!$package_base) {
      my $t1 = System->getPackageInfo("", "SUNWsrsvp", "_ALL_");
      if (!$t1->{VERSION}) {
         $warn = Html->warning("Warning: NetConnect packages SUNWnc01 or SUNWsrsvp not found!");
      }
    }

    ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;

    $renv->{'pro.netconnect.active'} = $q->{active}? "Y":"N";
    $renv->{'pro.netconnect.maxsize'}  = $q->{max};
    $renv->{'pro.netconnect.version'}  = $q->{version};

    PDM::ConfigFile->write( $renv, $dev, $host,$notifs);

    $err = Html->info($L->{err_1});
  }

  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;

  if ($renv->{'pro.netconnect.active'} eq "Y") {
    $active = "checked" ;
  } else {
    $info = "<font color=red><b>$G->{inactive}</b>";
  }
  $max    = $renv->{'pro.netconnect.maxsize'} || "2000";
  my $version = Html->makeSelect("version", "=Automatic|2=NetConnect 2.x|3=NetConnect 3.0|31=ServiceNet", $renv->{"pro.netconnect.version"});

 $o =<<EOF;
$warn $err
<form  method=get>
 <input type=hidden name=GO value=GUI::Providers::display>
 <input type=hidden name=option value=$q->{option}>
<center>
<table border=2 cellspacing=2 width=90% bgcolor=white><tr><td>
<table border=0 cellspacing=2 width=100%>
<tr>
<td colspan=2 bgcolor=$Style::DARK><b><font color=white>&nbsp;$L->{label}</td>

<tr><td bgcolor=$Style::LIGHT width=20% align=right>$G->{active} :</td>
      <td><input type=checkbox name=active $active> $info

<tr><td bgcolor=$Style::LIGHT align=right>$L->{max}:</td>
      <td><input type=text name=max value=\"$max\" size=20>

<tr><td bgcolor=$Style::LIGHT align=right>Transport method:</td>
      <td>$version</td>
</table>
</table>
<b>
EOF
  if (!$deny) {
     $o .= "<input type=submit name=ACTION_update value=$G->{submit_update}>";
  }
  $o .= " </form>";

  return $o;

}


sub RUN {
  my($pro, $pdm) = @_;
  my($f, $l, $transmit);
  $DB::single = 1;

  my($renv, $devices, $hosts, $notifs) = PDM::ConfigFile->read();
  my $version =  $renv->{'pro.netconnect.version'};

  if ($renv->{'pro.netconnect.active'} ne "Y") {
     Debug->print2("  not active, skipping.");
     return;
  }
  return if (PDM->getEventCount() == 0);
  my ($NET_RUN, $APEX);

  my $package_base = System->getPackageInfo("", "SUNWnc01", "BASEDIR");

  if ($version eq "31") {
     $APEX = System->get_home() . "/sbin/srs_send";

  } elsif ($version eq "2") {
     $NET_RUN = "$package_base/SUNWnc/bin/ncsend";

  } elsif ($version eq "3") {
     # do nothing

  } elsif ($package_base) {
     $NET_RUN = "$package_base/SUNWnc/bin/ncsend";

  } else {
    my $t1 = System->getPackageInfo("", "SUNWsrspx", "_ALL_");
    if (!$t1->{VERSION}) {
       Debug->print2("  NetConnect: /opt/SUNWsrspx package not found, skipping.");
       return;
    }
    my $t1 = System->getPackageInfo("", "SUNWsrssp", "_ALL_"); # storage
    if ($t1->{VERSION}) {
       # do nothing
    } else { # =~  /03\.001/  (apex)
       #$APEX = "$t1/SUNWsrspx/bin/srsxfer" if ($t1);
       $APEX = System->get_home() . "/sbin/srs_send";
    }
  }

  my($netfile) = "/opt/SUNWstade/DATA/SHUTTLE" ;  # prefix
                  #$renv->{'pro.shuttle.ifile'};

  my($netfile1) = $netfile . "1";   # high priority
  my($netfile3) = $netfile . "3";   # low priority

  my($max)     = ($renv->{'pro.netconnect.maxsize'} + 0) * 1000;
  $max = 2000000 if (!$max);

  rename $netfile1, "$netfile1.work";
  rename $netfile3, "$netfile3.work";

  open(W1, ">>$netfile1.work");
  open(W3, ">>$netfile3.work");

  my($size1) = (stat("$netfile1.work"))[7];
  my($size3) = (stat("$netfile3.work"))[7];
  my ($alarms, $events);

  foreach $ed (@{ PDM->getMessages}) {
     my $ev  = $ed->instances()->[0];
     my $actionable = $ev->value("Actionable");

     if ($actionable eq "TRUE") {
       $post = $ed->toC();
       if ($APEX) {
          &srs_send($ed);
          $alarms .= $post;
       } else {
          if ($size1 > $max) {
             close(W1);
             Debug->err(NETCONNECT => "File $netfile1 is full, cannot write anymore");
             last;
          }
          print W1 $post;
          $size1 += length($post);
       }
       Debug->print2("NetConnect ($url): " . $ed->className . " " . $ed->description );

     } else {
       $post = $ed->toC;
       if ($APEX) {
          $events .= $ed->toC();
       } else {
          if ($size3 > $max) {
             close(W3);
             Debug->err(NETCONNECT => "File $netfile3 is full, cannot write anymore");
             next;
          }
          print W3 $post;
          $size3 += length($post);
       }
       Debug->print2("NetConnect ($url): " . $ed->className . " " . $ed->description );
     }
  }
  close(W1);
  close(W3);
  
  if ($NET_RUN && -x $NET_RUN) {
     my $F1 = "$netfile1";  # use pid names since ncsend queue work
     my $F3 = "$netfile3";
     rename "$netfile1.work" , $F1;
     rename "$netfile3.work" , $F3;
     chmod 0666, $F1;
     chmod 0666, $F3;
     if (!(-z $F1)) {
        system("$NET_RUN -n nws $F1");
     }
     if (!(-z $F3)) {
        system("$NET_RUN -n nws $F3");
     }
  } elsif ($APEX) {
     &srs_send(0, $alarms);
     &srs_send(0, $events);

  # EXPECT writeNetConnect to be called
  } else {
     rename "$netfile1.work" , $netfile1;
     rename "$netfile3.work" , $netfile3;
     chmod 0666, $netfile1;
     chmod 0666, $netfile3;
  }

  Debug->print2("NetConnect done.");

}

sub srs_send {
  my($ed, $toc) = @_;

  my $renv    = System->get_renv();
  my $version = "1.0";
  my $F       = "/tmp/srs_send.tmp";
  my $domain  = System->domain();
  my $debug   = "-d" if (Debug->level() > 1);

  my $opts = "-D \"$domain\" $debug -l /tmp/srs_send.log -r 0 -v \"$version\" -f $F";
  if ($toc) { 
     open(W, ">/tmp/srs_send.tmp");
     print W $toc;
     close(W);
     my $com = System->get_home() .  "/sbin/srs_send $opts";
     Debug->print3("command: $com");
     my($err, $rc) = Util->run_command($com, "netconnect", 20);
     Debug->print2("NetConnect srs_send:data Error: $err") if ($err);

  } elsif ($ed) {
     my $ev   = $ed->instances()->[0];
     my $sev  = $ev->value("Severity");
     my $desc = $ev->value("Description");

     open(W, ">/tmp/srs_send.tmp");
     print W $desc;
     close(W);

     my $com = System->get_home() .  "/sbin/srs_send $opts -s $sev";
     Debug->print3("command: $com");
     my($err, $rc) = Util->run_command($com, "netconnect", 20);
     Debug->print2("NetConnect srs_send:event Error: $err") if ($err);
  }
}
  
1;
