package Provider::DataHost;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>


#  $Id: DataHost.pm,v 1.4 2003/05/19 22:04:09 ccadieux Exp $

use PDM;
use Carp;
use Message;
use Grid;
use Util;
use strict;
use TO;
use HBA;

use base 'Provider';
sub revision {'$Revision: 1.4 $'}

sub new {
  my($self, $pdm)  = @_;

  my($p) = { pdm => $pdm };
  bless($p,'Provider::DataHost');
  return $p;
}

sub description {"DataHost"}

sub ISACTIVE {
  my($class, $renv) = @_;
  return "NA" if ($renv->{solution} ne "N");
  my $o = $renv->{'pro.sae.dh_active'} eq "Y" ? "(On)" : "(Off)";
  return $o;
}

sub UPDATE {
  my($class, $q) = @_;
  my($active, $ip, $proxy, $to, $err, $name, $nat, $info, $ip2);
  my($renv, $dev, $host,$notifs, $o);
  my $deny = Roles->verifyRole($q, "admin");
  my $G = Labels->read();
  my $L = Labels->read('Provider')->section('sae');

  if ($q->{ACTION_update}) {
    ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;

    if ($q->{dh_active}) {
      my($ip,$port) = split(/\:/, $q->{datahost});
      if ($port !~ /^\d+$/) {
         $err .= Html->warning("Must enter IP:port!");
         $q->{dh_active} = "";
      } elsif ($ip && !Util->ping($ip, 5)) {
         $err = Html->warning("Cannot ping $ip");
         $q->{dh_active} = "";
      }
    }
    $renv->{'pro.sae.dh_active'}  = $q->{dh_active}? "Y":"N";
    $renv->{'pro.sae.datahost'}   = $q->{datahost};

    PDM::ConfigFile->write( $renv, $dev, $host,$notifs);
    $err .= Html->info($L->{update});
  }

  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read();
  my($dh_active, $dh_info, $ck_active);
  $ck_active   = "<font color=red><b>$G->{inactive}</b>";
  if ($renv->{'pro.sae.dh_active'} eq "Y") {
    $dh_active = "checked" ;
  } else {
    $dh_info = "<font color=red><b>$G->{inactive}</b>";
  }

  $o =<<EOF;
$err
<form  method=get>
 <input type=hidden name=GO value=GUI::Providers::display>
 <input type=hidden name=option value=$q->{option}>
<center>
<table border=1 cellspacing=0 cellpadding=2 width=90% bgcolor=white><tr><td>
<table border=0 cellspacing=2 width=100%>
   <tr><td colspan=2 bgcolor=$Style::DARK><b><font color=white>&nbsp;$L->{transfer}</td>
   <tr><td bgcolor=$Style::LIGHT align=right>$L->{active}:</td>
     <td><input type=checkbox name=dh_active $dh_active> $dh_info
   <tr><td bgcolor=$Style::LIGHT align=right>$L->{datahost}:</td>
     <td><input type=text name=datahost value=\"$renv->{'pro.sae.datahost'}\" size=40>
         $L->{use_colon} 
</table> </table>
EOF

  if (!$deny) {
     $o .= "<b><input type=submit name=ACTION_update value=$G->{submit_update}>";
  }
  $o .= "</form>";
  return $o;

}

sub RUN {
  my($pro) = @_;
  my $renv = System->get_renv();
  $DB::single = 1;

  if ($renv->{'pro.sae.dh_active'} eq "Y" && $renv->{'pro.sae.datahost'}) {
     my $url = $renv->{'pro.sae.datahost'};
     $url    = "http://$url" if (substr($url,0,4) ne "http");
     $url   .= "/agent/host?Auth=StoradeAgent";

     my $to = TO->getCurrentTopo(undef, 0, 1);
     my $topo = HBA->topoHash($to);
     my $out;
     foreach my $el (sort keys %$topo) {
       $out .= "$el\t$topo->{$el}\n";
     }
     my($err, $ans) = Util::Http->post($url, $out, 30);
     print "-> SAE DataHost Notifier error: $err\n" if ($err);
  } else {
      Debug->print2("  not active, skipping.");
  }

}

  
1;
