package NWS::3310;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: 3310.pm,v 1.7 2003/05/29 17:06:44 ccadieux Exp $

use Report;
use CIM::Instance;
use Data::Dumper;
use strict;
use Ilist;
use PDM;
use NWS;
sub revision {'$Revision: 1.7 $'}
sub category {"3310"}

sub newSystem {
  my ($class, $rep) = @_;
  my(@pil, $i, $dd, $a, $j, $k, $k1, $v);
  my $CTRL;
  my $wwn  = $rep->get('id.wwn'); # really the key now
  my $renv = System->get_renv();
  my $type = $rep->get("id.device_type");

  my($p1) = CIM::Instance->new('NWS_System',[
                    [Name 		=> $wwn ],
                    [OtherIdentifyingInfo => $rep->get("info.name") ],
                    [SystemName         => $rep->get('id.name')],
                    [IP 		=> $rep->get('id.ipno')],
                    [FruDiskDriveCount 	=> $rep->get('info.total_physical_drives')],
                    [VolCount 		=> $rep->get('info.total_logical_drives')],
                    [SysRevision 	=> $rep->get('info.Revision')],
                    [Caption            => $type] ,
                ]);

  my($p2) = CIM::Instance->new('CIM_PhysicalFrame', [
                  [Tag 			=> $wwn],
                  [Name			=> $wwn],
                  [Manufacturer 	=> "SUN"  ],
                  [Model 		=> $type  ],
                  ]);

  my($a2) = CIM::Instance->new('CIM_ComputerSystemPackage', [
                  [Antecedent          => $p1],
                  [Dependent           => $p2],
                  ]);

  my($l1) = NWS->location($rep);
  
  my($al1) = CIM::Instance->new('NWS_PhysicalFrameLocation', [
                  [Element 		=> $p2],
                  [PhysicalLocation 	=> $l1],
                  ]);
               
  push (@pil, $p1, $p2, $a2, $l1, $al1);

  my $diskTotal = $rep->get('info.total_physical_drives');
  for ($j = 0; $j < $diskTotal; $j++) {
      $dd = $class->newDiskDrive($rep,"components.disk.$j");
      next if (!$dd);
      $a = CIM::Instance->new('CIM_Container', [
                   [GroupComponent  => $p2],
                   [PartComponent => $dd->[1]],
                   [LocationWithinContainer => "disk.$j"],
                   ]);
      push (@pil, @$dd, $a);
  }

  for ($j = 1; $j < 100; $j++) {
      last if (!$rep->get("fru.$j.item"));
      $dd = $class->newFru($rep,"fru.$j");
      next if (!$dd);
      $a = CIM::Instance->new('CIM_Container', [
                   [GroupComponent  => $p2],
                   [PartComponent => $dd->[1]],
                   [LocationWithinContainer => "fru.$j"],
                   ]);
      push (@pil, @$dd, $a);
  }

  my $LUNS =  $rep->get('info.total_logical_drives');

  for ($i = 1; $i <= $LUNS; $i++) {
     $dd = $class->newLun($rep,"logical_drive.$i");
     my $v2 =  CIM::Instance->new('CIM_MediaPresent', [
                       [Antecedent => $p1 ],
                       [Dependent  => $dd->[0] ],
                       ]);
     push (@pil, @$dd, $v2);
  }
 
  return Ilist->new(\@pil);

}

sub getKey {
  my($class, $rep, $cd) = @_;
  return "" if (!$rep->get("$cd.model"));
  return  $rep->get("$cd.model") . "." . $rep->get("$cd.serial_number") ;
}

sub getState {
  my($class, $rep, $cd) = @_;

  my($map) = PDM->getDeviceStateMap("3310.availability");
  my $state = $map->get("status." . $rep->get("$cd.Status"));
  return $state;
}

sub newFru {
  my($class, $rep, $cd) = @_;
  my(@il, $p1, $c1, $a1, $c2, $a2);

  my($serial_no) = $class->getKey($rep, $cd);

  return undef if (!$serial_no);
  my $status  = "OK";
  my $info = $rep->get("$cd.manufacturing_date") . ", " . 
             $rep->get("$cd.manufacturing_location");

  $p1 = CIM::Instance->new('NWS_DiskDrive', [
                [SystemName 	    => $rep->get("$cd.item") ],
                [DeviceID 	    => $serial_no],
                [Name     	    => $serial_no],
                [StatusInfo         => ],
                [Status             => "OK" ],
                 ]);
  push(@il,$p1);

  $c1 = CIM::Instance->new('CIM_PhysicalPackage', [
                [Removable 	=> "Yes"],
                [Tag 	        => $serial_no],
                [Name    	=> $serial_no],
                [SerialNumber 	=> $rep->get("$cd.serial_number") ],
                [Manufacturer 	=> $rep->get("$cd.vendor_jedec_id")],  
                [Model 		=> $rep->get("$cd.model")],  
                [Version 	=> $rep->get("$cd.revision")],  
                [OtherIdentifyingInfo => $info ],
                    ]);

  push(@il, $c1);
  $a1 = CIM::Instance->new('CIM_Realizes', [
                    [Antecedent => $c1],
                    [Dependent => $p1],
                    ]);
                    
  push(@il,$a1);

  return Ilist->new(\@il);

}


sub newDiskDrive {
  my($class, $rep, $cd) = @_;
  my(@il, $p1, $c1, $a1, $c2, $a2);

  my($serial_no) = $class->getKey($rep, $cd);

  return undef if (!$serial_no);
  my($status) = $rep->get("$cd.status");

  $p1 = CIM::Instance->new('NWS_DiskDrive', [
                [SystemName 	    => $rep->get("$cd.manufacturer")." DiskDrive"],
                [DeviceID 	    => $serial_no],
                [Name     	    => $serial_no],
                [FruDiskCapacity    => $rep->get("$cd.capacity")],
                [StatusInfo         => $status],
                [Status             => $class->getState($rep, $cd)],
                 ]);
  push(@il,$p1);

  $c1 = CIM::Instance->new('CIM_PhysicalPackage', [
                [Removable 	=> "Yes"],
                [Tag 	        => $serial_no],
                [Name    	=> $serial_no],
                [SerialNumber 	=> $rep->get("$cd.serial_number") ],
                [Manufacturer 	=> $rep->get("$cd.manufacturer")],  
                [Model 		=> $rep->get("$cd.model")],  
                [Version 	=> $rep->get("$cd.product_revision")],  
                    ]);

  push(@il, $c1);
  $a1 = CIM::Instance->new('CIM_Realizes', [
                    [Antecedent => $c1],
                    [Dependent => $p1],
                    ]);
                    
  push(@il,$a1);

  return Ilist->new(\@il);

}

# logical.2 

sub newLun {
  my($class, $rep, $cd) = @_;
  my @pil;
  my $wwn =  $rep->{"id.wwn"} . ".$cd";
  my $v1 = CIM::Instance->new('NWS_StorageVolume', [
                  [ SystemName      => $wwn ],
                  [ DeviceID        => $wwn ],
                  [ VolWWN          => $wwn ],
                  [ VolId           => $cd  ],
                  [ Capacity        => $rep->{"$cd.size"} ],
                  [ VolStatus       => $rep->{"$cd.status"}   ],
                         ]);

   push(@pil, $v1);
   return Ilist->new(\@pil);
}



1;
