package Logic::Solution;
use Logic;
use Grouping;
use strict;

#  host =>  $host, monitor_on => Y,  noprint => 1
#  return ($err_object, $nodes_list, $info);

sub addToConfig {
  my ($class, $q) = @_;
  my ($err, @nodes, $info, $data, %F);
  my $print = !$q->{noprint};

  my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
  my $monitor_on = $q->{monitor_on};
  Grouping->addCategory("MERGE-MASTER", "SE", "Solutions", 1);
  
  my $cnt= 1; 
  foreach my $d (@$devs) {
     if ($d->{class} =~  /^switch/  || $d->{class} =~ /storage.t3/ || $d->{type} eq "se") {
        $F{$d->{key}} = $cnt;
     }
     $cnt++;
  }
  if (!$q->{host}) {
      $data = &get_rack($q);
  } else { 
     print "2 - Getting devices from $q->{host}..\n" if ($print);
     my $host_ip = $q->{host}; 
     foreach my $h (@$hosts) {
       if ($h->{hostname} eq $q->{host}) {
          $host_ip = $h->{ipno};
          last;
       }
     }

     my $rc  = Util::Http->getCommand($host_ip, "Logic::Solution::rack&HTTP=1", 200);
     if (substr($rc,0,2) ne "OK") {
         return (Error->error(1, "getCommand on $host_ip failed: $rc"), undef, undef);
     } else {
         my @A = split(/\n/, substr($rc,2));
         $data = \@A;
     }
  }
  my $short = Util->shortHostname($q->{host} || $renv->{hostname});
  my ($model, $adding, $found, $sehostid, $version);
  my $new_dev = $#$devs ;
  foreach my $line (@$data) {
     my($class, $type, $name, $ip, $wwn, $key, $wwn2, $init) = split(/\|/, $line);
     if ($class eq "MODEL") {
         $model = $type;
         $sehostid = $name;
         $version = $ip;
         next;
     }
     if ($class eq "ERR") {
       print "  Error: $type \n" if ($print);
       next;
     }
     if (!$wwn) {
       print "  No wwn for $type:$name:$ip, cannot add!\n" if ($print);
       next;
     }
     if (!$F{$key}) {
        $F{$key} = 1;
        $adding = 1;
        $found++;
        $new_dev++;
        my($ip1,$ip2,$ip3, $ip4) = split(/\./, $ip);
        $devs->[$new_dev]{_name}    = "device" . $new_dev;
        $devs->[$new_dev]{type}     = $type;
        $devs->[$new_dev]{key}      = $key;
        $devs->[$new_dev]{model}    = $model;
        $devs->[$new_dev]{wwn}      = $wwn;
        $devs->[$new_dev]{mgmtLevel}= "C";

        if ($type eq "t3") {
          $devs->[$new_dev]{ctrl_model} = $init;
          $devs->[$new_dev]{userLabel} = Agent::T3->getUserLabel($init);
        }
        if ($type eq "ve") {
          $devs->[$new_dev]{login} = $wwn2;
          $devs->[$new_dev]{initiator} = $init;
        } elsif ($wwn2) {
          $devs->[$new_dev]{wwn2}  = $wwn2;
        }
        $devs->[$new_dev]{class}    = $class;
        if ($name) {
          $devs->[$new_dev]{name}     = $name;
        } else {
          $devs->[$new_dev]{name}     = $short ."-" . sprintf("%3.3d", $ip4);
        }

        $devs->[$new_dev]{ip}       = $ip;
        $devs->[$new_dev]{ipno}     = $ip;
        $devs->[$new_dev]{host}     = $q->{host};
        $devs->[$new_dev]{active}   = ($monitor_on ? "Y":"N");
        push(@nodes, $devs->[$new_dev]);

        print " $type:$ip added. \n" if ($print);

     } else {
       print " $type:$ip already exist.\n" if ($print);
     }
     Grouping->setGroup('MERGE-MASTER:SE',"$type:$key",$short,"F0F0C0", "rack");
  }
  Grouping->setGroup('MERGE-MASTER:SE', "host:$q->{host}",$short,"F0F0C0", "rack");
  Grouping->save();

  if ($adding) {
     my $ipno =  Util->name2ip($q->{host});
     my $sekey = $model . ".$sehostid";
     if (!$F{$sekey}) { #  && $renv->{include_se_device} ) {
       $F{$sekey} = 1;
       $new_dev++;
       $devs->[$new_dev]{_name}    = "device" . $new_dev;
       $devs->[$new_dev]{type}     = "se";
       $devs->[$new_dev]{class}    = "storage.se";
       $devs->[$new_dev]{name}     = "$model-" . ($q->{host} || $renv->{hostname});
       $devs->[$new_dev]{ip}       = $ipno;
       $devs->[$new_dev]{wwn}      = $sekey;
       $devs->[$new_dev]{key}      = $sekey;
       $devs->[$new_dev]{model}    = $model;
       $devs->[$new_dev]{mgmtLevel}    = "DS";
       $devs->[$new_dev]{ipno}     = $ipno;
       $devs->[$new_dev]{host}     = $q->{host};
       $devs->[$new_dev]{active}   = "Y";
       push(@nodes, $devs->[$new_dev]);
       print " $sekey added. \n" if ($print);
     }
     if (!$q->{host}) {
        $renv->{solution} = "se";
        $renv->{solution_model} = $model;
        $renv->{categories} = "t3|switch|ve|host|message|san";
        #$renv->{categories} .= "|t3" if (index($renv->{categories}, "t3") < 0);
        #$renv->{categories} .= "|switch" if (index($renv->{categories}, "switch") < 0);
        #$renv->{categories} .= "|ve" if (index($renv->{categories}, "ve") < 0);
        $renv->{t300logfile} = "/var/adm/messages.t3";
     } else {
        foreach my $h (@$hosts) {
          if ($h->{hostname} eq $q->{host}) {
            $h->{solution} = "se";
            $h->{version} = $version;
            $h->{solution_model} = $model;
            $h->{t300logfile} = "/var/adm/messages.t3";
            $h->{last_push} = "";
            $h->{categories} = "t3|switch|ve|host|message|san";
            #$h->{categories} .= "|t3" if (index($h->{categories}, "t3") < 0);
            #$h->{categories} .= "|switch" if (index($h->{categories}, "switch") < 0);
            #$h->{categories} .= "|ve" if (index($h->{categories}, "ve") < 0);
          }
        }
     }
     PDM::ConfigFile->write( $renv, $devs, $hosts,$notifs);
  } else {
     $info .= "  No new devices found!\n";
  }
  return ($err, \@nodes, $info);
}

sub get_rack {
  my($q) = @_;
  my(%T, @a, $loc, $ip, $out);
  my(%F, $d, $adding, $found, $l );
  my(@NEW, $xx, $x);
  my $renv = System->get_renv();

  my $remote   = $q->{HTTP};
  my $ve_only  = 1 if ($q->{VEONLY});

  my(@L , $s, $r1, $r2, $r3, $rack);
  my $RACK = System->get_home() . "/DATA/Inventory.golden";
  if ($renv->{solution} eq "N") {
     push(@L, "ERR|This is not a Sun Solution, cannot discover");

  } elsif ($renv->{solution} ne "se") {
     push(@L, "ERR|This type of Sun Solution ($renv->{solution_model}) cannot be discovered as a slave, discover as a device.");

  } elsif (!open(O1, "$RACK")) {
     push(@L, "ERR|Either the Snapshot was not created  
         or this host is not a Sun StorEdge Service Processor.");

  } else {
     while ($l = <O1>) {
        $s .= $l;
     }
     close(O1);
     ($r1, $rack, $r2, $r3) = PDM::ConfigFile->readFromString($s);

     push(@L, "MODEL|$r1->{model}|" . System->hostid() ."|" . $renv->{version});

     foreach my $d (@$rack) {
        my $val = "$d->{class}|$d->{type}|$d->{name}|$d->{ip}|";

        if ($d->{type} eq "switch") {
           $val .= "$d->{wwn}|$d->{wwn}|";
           next if ($ve_only);

        } elsif ($d->{type} eq "t3") {
           $val .= "$d->{wwn}|$d->{key}|$d->{wwn2}|$d->{ctrl_model}";
           next if ($ve_only);

        } elsif ($d->{type} eq "ve")  {
           $val .= "$d->{wwn}|$d->{wwn}|$d->{login}|$d->{initiator}";
        }
        push(@L,$val);
     }
  }

  if ($remote) {
     print "OK" . join("\n", @L);
  } else {
     return \@L;
  }
}


1;

