package Html;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#use System;
use Navigation;
use Error;
use Util;
use Labels;
use strict;

use vars qw (%MAP $SCR1 $SCR2 @SCR1 @SCR2 $HEADER_DONE);


$SCR1 = "1234567890qwertyuiopasdfghjklzxcvbnm ZXCVBNMLKJHGFDSAQWERTYUIOP".
        "!\@#\$%^&*()-_=+[]{}\\|;':\",.<>/?";
$SCR2 = "mnbvcxzasdfghjklpPLOKMNJIUHBYGVTFCRDXESZWAQoiuytrewq1234567890 ".
        "<>?,./:\";'{}|[]\\+_)(*&^%\$#\@!-=";

sub init_scramble {
  my($class) = @_;
  my ($x, $c2);
  for ($x=0; $x < length($SCR1); $x++) {
    my $c1 = substr($SCR1,$x,1); 
    my $o1 = ord($c1);

    my $c2 = substr($SCR2,$x,1);
    my $o2 = ord($c2);
    if ($c2 =~ /\W/) {
      $SCR1[$o1] = sprintf("%%%X",$o2);
    } else {
      $SCR1[$o1] = $c2;
    }
    $SCR2[$o2] = $c1;
  }
}

#  $arg->{select} =1 means that you want a [Select] first option
#  makeSelect("sel1", "2=opt2|4=opt3", "2");
#  $arg->{head} = "onchange=form.submit()";

sub makeSelect {
  my($class, $name, $l, $val, $arg) = @_;
  my($o, $ck);
  my $head = $arg->{head};

  my $m = "multiple size=$arg->{multiple}" if ($arg->{multiple});

  my @a = split(/\|/, $l);
  $o = "<select name=$name $head $m>";
  $o .= "<option value=\"\">[Select]</option>" if ($arg->{select});

  foreach my $x (@a) {
    my @b = split(/=/, $x);
    $b[1] = $b[0] if (!$b[1]);
    if ($arg->{multiple} ) {
      $ck = "";
      $ck = "selected" if (index("\t$val\t", "\t$b[0]\t") >=0) ;
    } else {
      $ck = ($b[0] eq $val)? "selected":"";
    }
    $o .= "<option $ck value=$b[0]>$b[1]</option>";
  }
  $o .= "</select>";
  return $o;
}



sub href {
 my($class, $hname, $url, $name, $target) = @_;
 
 $url = $class->scramble($hname, $url);
 return "<A href=$url $target>$name</a>";
}
  
# Html->scramble("", "GO=GUI::Hosts::upd&no=0");

sub scramble {
 my($class, $hname, $url) = @_;
 my $renv = System->get_renv();
 return "/$hname?$url" if ($renv->{scramble} ne "Y");

 $class->init_scramble() if ($#SCR1 < 0);

 if (substr($url,0,3) eq "GO=") {
     my $url1 = substr($url,3);
     $url1 =~ s/(.)/$SCR1[ord($1)]/eg;
     return "/$hname?SGO=" . $url1;
 }
 return "/$hname?$url";

}

sub unscramble {
 my($class, $url) = @_;

 if (substr($url,0,4) eq "SGO=") {
     $class->init_scramble() if ($#SCR1 < 0);
     my $url1 = substr($url,4);
     $url1 = Util->decode($url1);
     $url1 =~ s/(.)/$SCR2[ord($1)]/eg;
     return "GO=" . $url1;
 }
 return $url;
}

#  print Html->errorByCode('t3.101', 1, "arg1", "arg2" ..);


#  DISPLAY ERROR STRINGS
#
sub info {
  my($class, $m, $sev, $arg) = @_;
  return $class->error_($m, $sev, $arg);

}

sub warning {
  my($class, $m, $sev, $arg) = @_;
  return $class->error_($m, $sev|| 1, $arg);
}

sub error {
  my($class, $m, $sev, $arg) = @_;
  return $class->error_($m, $sev || 2, $arg);
}


# present a string as an html error box
sub error_ {
  my($class, $m, $sev, $arg) = @_;
  my $width = $arg->{width} || "70%";
  my ($col, $gif);
  if ($sev == 0) {
    $col = "#B0FFB0";
    $gif = "al_ok.gif";
  } elsif ($sev ==1) {
    $col = "#F0F0C0";
    $gif = "al_alert.gif";
  } else {
    $col = "#FFC0C0";
    $gif = "al_crit.gif";
  }
  return "<center><table border=1 width=$width cellspacing=0 cellpadding=2 bgcolor=white>
   <tr><td bgcolor=$col width=6%><center><img src=/gif/$gif></td><td><b><center>&nbsp;$m &nbsp;</table></center>
   ";
}

sub select_frequency {
  my($class, $renv, $select) = @_;
  my($frequency, $x);

  $select = "Select" if (!$select);
  $frequency = "<select name=frequency><option value=\"\">[$select]</option>";
  my $G = Labels->read();
  foreach $x (5,10,15,20,30,40,50,60,90,120,180,240) {
    my $sel = ($renv->{frequency} == $x) ? "selected":"";
    my $ss = ($x == 1) ? "":"s";
    $frequency .= "<option $sel value=$x>$x $G->{minutes}</option>";
  }
  $frequency .= "</select>";
  return $frequency;
}


sub text_header {
  my($class, $string, $arg) = @_;
  $string = "200 OK" if (!$string);
  my $o;
  if (!$HEADER_DONE) {
    $HEADER_DONE = 1;
    $o = "HTTP/1.0 $string\n" if (!$ENV{FCGI});
    $o .= "Content-type: text/html\n\n";
  }
  return $o;
}

#  body({ head     => "  ",
#         color    => "#C0C0C0",
#         margin   => "leftmargin=2...",
#         nocenter => 1 
#       });

sub body {
  my($class, $nav_section, $args) = @_;
  my $o;
  if (!$HEADER_DONE) {
    $o = "HTTP/1.0 200 OK\n" if (!$ENV{FCGI});
    $o .= "Content-type: text/html\n\n";
    $HEADER_DONE = 1;
  }
  my $color  = $args->{color} || $Style::BGCOLOR;
  my $margin = $args->{margin};
  my $extra  = $args->{extra};
  my $nav    = Navigation->read();
  my $head   = $nav->{ROOT}{info}{style};
  my $ruser  = System->get_ruser();
  my $renv   = System->get_renv();
  my $window = $ruser->{window} || $renv->{window};
  $head     .= "\n" if ($head);
  $head     .= $args->{head};
  if ($head) {
      $o .= "<head>$head</head>\n";
  } else {
      $o .= "<head><title>Storage Automated Diagnostic Environment</title></head>\n";
  }
  if ($window ne "N") {
    $o .= "<body bgcolor=$color $margin $extra>\n";
  }
  $o .= "<center>" if (!$args->{nocenter});
  return $o;
}


sub readHtdocs {
  my($class, $f, $notrace, $print)  = @_;

  my $renv  = System->get_renv();
  my $ruser = System->get_ruser();
  my $trace = $renv->{html_trace} && !$notrace;
  my $lang  =  $ruser->{language} || $renv->{language};
  my $lang0 = "$lang/" if ($lang);

  $f = "/$f" if (index($f,"/") < 0);
  my $ix = rindex($f, "/");
  my $lf = substr($f,0,$ix+1) . $lang0 . substr($f,$ix+1);
     
  my $F  = System->get_home() . "/htdocs/$f.html";
  my $LF = System->get_home() . "/Lang/htdocs/$lf.html";
  $F     = $LF if (-f $LF);

  my (@l, $i1, $l);
  if (open(RH,$F) ) {
    if ($print) {
       while ($l = <RH>) {
           print $l;
       }
       close(RH);
    } else {
       @l = <RH>; close(RH);
    }
    $i1 = "</b><small>($lang $f)</small>" if ($trace);
    print $i1 if ($print);
  }
  return "@l $i1" if (!$print);
}



sub readMap {
  my($class, $mapname)  = @_;

  my($l, $section);
  return $MAP{$mapname} if ($MAP{$mapname});

  $MAP{$mapname} = {};
  my $D = System->get_home() . "/System/$mapname";
  if (open(O, $D)) {
     while ($l = <O>) {
        chop($l);
        next if (substr($l,0,1) eq "#");
        if (substr($l,0,1) eq "[") {
           my $ix = index($l, "]");
           $section = substr($l,1,$ix-1);
        } else {
           my($lang,$val) = split(/ *= */, $l, 2);
           next if (!$val);
           $MAP{$mapname}{$section}{$lang} = $val;
        }
     }
  }
  close(O);
  return $MAP{$mapname};
}

#  works with the Navigation file
#  Html->header2("admin.gen_maint.site_info", "95%");
#  right : more stuff on the right by the 'help'

sub header2 {
  my($class, $nav_section,  $width, $extra_label , $doc_file, $arg) = @_;
  my $helpSection = $arg->{helpSection};
  my $nocrumb = $arg->{noCrumb};
  my $right   = $arg->{right};
  my $notitle = $arg->{noTitle};
  my $noTabs  = $arg->{noTabs} ; # don't display the tabs
  my $middle  = $arg->{middle};
  my $nohelp  = $arg->{nohelp};
  my $noDoc   = $arg->{noDoc};
  my $ruser  = System->get_ruser();
  my $renv   = System->get_renv();
  my $window = $ruser->{window} || $renv->{window};

  my $nav = Navigation->read();
#print "nav=$nav_section, $extra_label<br>";
  my($s1, $s2,$s3);
  my $ix = rindex($nav_section, ".");
  if ($ix > 0) {
    $s1 = substr($nav_section, 0, $ix);  # BASE MENU
    $s2 = substr($nav_section, $ix+1);   # SECTION IN MENU
    $ix    = rindex($s1, ".");
    $s3 = substr($s1, 0, $ix) if ($ix > 0);
  } else {
    $s1 = $nav_section;
  }
  $width = "90%" if (!$width);

  my ($section, $item, $title);
  $section = $nav->{$s1};
  $item    = $nav->{$s1}{items}{$s2};
  $title   = $item->{title};
 
  if ($window eq "N" && !$noTabs) {
    Navigation::nf_top({MENU => $s1, TAB => $Http::HTTPQ->{TAB}});
    print "<table border=0><tr><td></table>";

  } elsif (!$noDoc) {
    print "<table border=0><tr><td></table>\n";
  }

  if (!exists $nav->{$s1}{items}{$s2}) {
    return "Cannot find $s1.$s2 in navigation file!";
  }

  my $crumb;
  if ($window eq 'N' && !$nocrumb) {
     $crumb = "<a href=$Http::WEBPROC?GO=GUI::Navigation::welcome&MENU=$s1>$section->{info}{title}</a> >";
     if ($s3) {
        my $section3 = $nav->{$s3};
        $crumb = "<a href=$Http::WEBPROC?GO=GUI::Navigation::welcome&MENU=$s3>$section3->{info}{title}</a> > $crumb";
     }
     if ($s3 ne "ROOT" && $s1 ne "ROOT") {
        $crumb = "<a href=$Http::WEBPROC?GO=GUI::Navigation::welcome&MENU=ROOT>$nav->{ROOT}{info}{title}</a> > $crumb";
     }
  }
  $title  = "" if ($notitle);
  my $url = ($window eq 'N' && !$nocrumb) ? "<a href=$Http::WEBPROC?GO=$item->{url}>$title</a>" : $title;

  my ($script, $user);
  if (!$nohelp) {
    ($script, $user)  = $class->help2("$s1.$s2", $item);
  }
  my $extra;
  if (substr($extra_label,0,1) eq "#") {
     $extra = ": " .  $item->{"title" . substr($extra_label,1)};
  } elsif ($extra_label) {
     $extra = (substr($extra_label,0,1) eq ">"? "": ": ") . $extra_label;
  }
  my $mid = "<td nowrap>$middle</td>" if ($middle);
  if ($right) {
    $script = "$right | $script";
  }
  if ($item->{right}) {
     if (substr($item->{right},0,1) eq ">") {
       my $right = substr($item->{right},1);
       my($base, $section) = split(/\./, $right, 2);
       if (exists $nav->{$base}{items}{$section}) {
          my $right_item = $nav->{$base}{items}{$section};
          $script .= " | <a href=$Http::WEBPROC?GO=$right_item->{url}>$right_item->{title}</a>";

       } else {
          my $right_item = $nav->{$base};
          $script .= " | <a href=$Http::WEBPROC?GO=GUI::Navigation::welcome&MENU=$base>$right_item->{info}{title}</a>";
       }
     }
  }
  $script = "[ $script ]" if (!$arg->{noBrackets});
  my $out = "<table border=0 cellspacing=0 cellpadding=1 width=$width>\n 
           <tr><td nowrap valign=middle><font color=navy>$crumb <b>$url $extra\n</td>$mid<td align=right nowrap width=2%>$script</td></table>\n" if (!$arg->{noHeader});

  my $desc2 = $item->{desc2};
  my $desc1 = $item->{desc};
  my $out_desc;
  if (!$noDoc) {
    if ($doc_file) {
      $out_desc .= $class->readHtdocs($doc_file);
    } elsif (substr($desc2,0,5) eq "FILE ") {
      $out_desc .= $class->readHtdocs(substr($desc2,5));
    } elsif (exists $item->{desc2}) {
      $out_desc .= $desc2;
    } elsif ($desc1) {
      $out_desc .= $desc1;
    }
    if ($out_desc) {
      $out .= "<table border=0 cellpadding=3 width=$width bgcolor=white><tr><td>$out_desc</table>";
    }
  }
  return $out;

}

#  ->header("Maintenance", "95%", $mach, "Maintenance#Cust", "maint_help");

sub header {
  my($class, $title0, $w, $opt, $helpSection, $doc, $arg) = @_;
  my($caller, $tag);
  my $nohelp = $arg->{nohelp};
  if ($arg->{caller}) {
     $caller = $arg->{caller};
     $tag    = $arg->{tag};
  } else {
    my @X = caller(1);
    my $ix = rindex($X[3], "::");
    if ($ix > 0) {
       $caller = substr($X[3],0, $ix);
       $tag    = substr($X[3],$ix+2) . ".";
    } else {
       $caller = $X[3];
    }
  }
  my $labels =  Labels->read();
  my $title  =  $labels->{"${tag}title"} || $title0;
  $w = "90%" if (!$w);

  if ($opt) {
    $opt = "<td><form></td><td align=right nowrap>$opt</td><td width=1%></form></td>";
  }
  my ($script, $user);
  if (!$nohelp) {
    ($script, $user)  = $class->help($helpSection) ;
    $script = " $script |";
  }

  my $out = "<table border=0 cellspacing=0 cellpadding=2 width=$w> <tr> <td><font size=+1 color=navy><b>$title</td>$opt<td align=right nowrap width=2%>$script $user</td></table>";

  if ($doc) {
     $out .= "<table border=0 cellpadding=3 width=$w bgcolor=white><tr><td>". $class->readHtdocs($doc) . "</table>";
  }
  return $out;
}

  

sub help2 {
  my($class, $node, $item) = @_;

  my $sysLb =  Labels->read();
  my $user;
  my $file = $item->{help};
  my $u = "/?GO=GUI::Navigation::help2&ROOT=$node&file=$file&WIN=1";

  my $dd = "<script> function o_win(x){ var w=window.open('$u','help','menubar=yes,scrollbars,resizable,width=800,height=650'); w.focus(); } </script> <a href=javascript:o_win()>$sysLb->{help}</a>";

  if (wantarray) {
    return ($dd, $user);
  } else {
    return $dd;
  }
}

sub help {
  my($class, $move) = @_;

  my $renv = System->get_renv();
  my $ruser = System->get_ruser();
  my $lang = $ruser->{language} || $renv->{language};
  my $INDEX = "indexWin";

  $lang = "$lang/" if ($lang);

  my $user = System->get_ruser();
  $user = $user->{userid};

  my $ix = index( $move, "#");
  my $sysLb =  Labels->read();
  my ($dd, $off);
  if ($ix > 0) {
     $off =  "#" . substr($move,$ix+1);
     $move =  substr($move,0,$ix) . ".html";
  } elsif ($move) {
     $move = "$move.html";
  } else {
     $move = "$INDEX.html";
  }
  my $D = System->get_home() . "/htdocs";
  if ($lang && -f "$D/$lang/Help/$move") {
    $dd = "/$lang/Help/$move";
  }
  if (!$dd && -f "$D/Help/$move") {
    $dd = "/Help/$move";
  }
  if (!$dd) {
    $dd = "/Help/$INDEX.html";
  }


  $dd = "<script> function o_win(x){ var w=window.open('$dd$off','help','menubar=yes,scrollbars,resizable,width=600,height=700'); w.focus(); } </script> <a href=javascript:o_win()>$sysLb->{help}</a>";

  if (wantarray) {
    return ($dd, $user);
  } else {
    return $dd;
  }
}


1;
