package Health::Slave;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: Slave.pm,v 1.24 2003/02/20 00:28:29 ccadieux Exp $

 
#             CREATION
####################################################
 
use Health;
use PDM;
use Carp;
use Data::Dumper;
use Report;
use strict;
use CIM::Instance;
use Message;
use CIM::Instance;
use Events;
use Debug;
use Health::SAN;
  
use base 'Health';
sub revision {'$Revision: 1.24 $'}
 
sub new {
  my($hm, $pdm) = @_;

  my($self) = {pdm => $pdm};
  bless ($self, 'Health::Slave');

# Specify each callback
#                            HM  Callback,  Filters
  $pdm->reportRequest($self, 'all_logic' , {INITIAL => 1});
  return $self;
}                     

#####################################################


sub all_logic {
  my($hm ) = @_;
  my($pdm) = $hm->{pdm};
  my($ev, $sd, $x, $h, $pertains);
  my($l, $s, $rc, $url, $ed);
#
# POLL ALL SLAVES, GENERATE CommLost Events
# GET EVENTS from slaves and store in PDM.
#
  CIM->version("1.1");
  $DB::single = 1;
  
 my($renv, $devices, $hosts, $notifs) = PDM::ConfigFile->read();

 my @rules = FCRules->load_rules();
 Thresholds->init();
  my $To = TO->readExistingTopo("MERGE-MASTER") || TO->readExistingTopo();

 foreach $h (@$hosts) {
   if ($h->{dh} eq "Y") {
      Debug->print2(" -> skipping $h->{hostname}, datahost only");
      next;
   }   
   if ($h->{active} eq "N") {
      Debug->print2(" -> skipping $h->{hostname}, slave not active");
      next;
   }
   my $ip   = $h->{ip};
   my $ipno = $h->{ipno} || $h->{ip};
   if ($ip) {
      my($alive) = Util->ping($ipno) ? "Y":"N";
      my $tran  = Transition->getTransition( {   key => $ip,
                                         code => 'alive',
                                        value => $alive,
                             transition_value => "N",
                                       repeat => '8h',
                                 });
      if ($tran =~ /IN/  || $tran =~ /OUT/) {
          my($et, $desc, $sev, $nws, $avail);
          if ($tran =~ /IN/) {
            $et   = 'agent.CommunicationLostEvent';
            $desc = "Lost Communication with $h->{hostname} at $ipno (using udp ping)";
            $nws  = 'NWS_CommunicationLostEvent';
            $sev  =  Message::SEVERITY_DOWN;
            $avail= 0;
            Grid->setCode("agent.CommunicationLostEvent");

          } else {
            $et   = 'agent.CommunicationEstablishedEvent';
            $nws  = 'NWS_CommunicationEstablishedEvent';
            $desc = "Regained communication with $h->{hostname} at $ipno regained";
            $sev  =  Message::SEVERITY_NORMAL;
            $avail= 1;
            Grid->setCode("agent.CommunicationEstablishedEvent");
          }

          $ev = CIM::Instance->new($nws, [
                  [ EventType       => $et  ],
                  [ EventId         => $pdm->getEventSequence  ],
                  [ Severity        => $sev ],
                  [ Actionable      => ($sev > 0) ],
                  [ Target          => "host:$h->{hostname}" ],
                  [ TargetName      => $h->{hostname} ],
                  [ Caption         => 'oob' ],
                  [ Description     => $desc ]
                   ]);

          State->saveState('host',  $h->{hostname}, "", 
                            Util->shortHostname($h->{hostname}), $sev, $desc,$avail , $ev);

          $sd = Events->sourceDetector({ event => $ev });
          $pertains = CIM::Instance->new('NWS_EventPertainsToSoftwareElement', [
                  [ Event      => $ev  ],
                  [ Element    => $sd->[0] ],
                    ]);
          $ed = Message->new( { id   => {},
                            instances => [$ev, @$sd, $pertains ], severity  => $sev });
          $pdm->saveMessage($ed);
      }

      next if ($tran =~ /IN/ || $tran eq "LOST");

      $rc  = Util::Http->readFileDelete($ipno, "SLAVE_DATA", 20);

      if (length($rc) > 2) {
         my(@l) = split(/\n/, $rc); 
         return if ($#l < 0);
         $s = "";
         Debug->print2("Receiving $#l lines from $h->{hostname}");
         for ($x = 0; $x <= $#l; $x++) {
             if (substr($l[$x],0,2) eq "-E") {
                eval {
                    $ed = Message->fromC($s);
                    if ($ed) {
                      $hm->process($ed, $h->{hostname}, \@rules, $To);
                    }
                };
                Debug->err(HTTP_ERROR => "failed to transfer from slave $@") if ($@);
                $s = "";
             } else {
               $s .= $l[$x] . "\n";
             }
         }
      } else {
         Debug->print2("No data from slave $h->{hostname}");
      }
   }
 }

}

sub process {
  my($hm, $ed, $hostname, $rules, $To) = @_;

  CIM->version("1.1");
  my $date = FCRules->today();

  my $found = 0;
  my $ev = $ed->instances(0);
  my $type = $ev->value("EventType");

  if ($To && $type eq "san.fcEvent") {
     my $data = $ev->value("Data");
     my ($VAR1);
     eval $data;
     Health::SAN->processFC($VAR1, $rules, $To) if ($VAR1);

  } else {
     PDM->saveMessage($ed, $hostname);
  }
}



1;
