package Grid;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use strict;
use System;
use TO;
use Util;
use Report;

use vars qw (@GRIDIDX $ERROR $EGRID $CODES %GRIDHASH);

sub setCode {
  my($class, $egrid) = @_;
  $EGRID = $egrid;
}

#  Grid->setSign(+, - , P, M, X)

sub setSign {
  my($class, $sign) = @_;
  return if (!$EGRID);
  my($cat, $type, $caption) = split(/\./, $EGRID, 3);
  $sign = "-" if ($sign eq "M" || $sign eq "X");
  $sign = "+" if ($sign eq "P");
  $EGRID = "$cat.$type$sign.$caption";
}


sub getCode {
  my($class) = @_;
  return $EGRID;
}


sub getNo {
  my($class, $egrid) = @_;
  $class->readCodes();
  $egrid = $EGRID if (!$egrid);
  my($t1, $t2, $c1) = split(/\./, $egrid, 3);
  $c1 = "enclosure" if (!$c1);
  return ($CODES->{TYPE}{$t1}||"ERR")  . "."  .
         ($CODES->{EVENT}{$t2}||"ERR") . "."  .
         ($CODES->{COMP}{$c1}||"ERR");
}


sub readCodes {
  my($class) = @_;
  my $F = System->get_home() . "/System/EGrid/GridCodes";
  return if $CODES;
  my($l);
  if (open(O, $F)) {
    while ($l = <O>) {
     chop($l);
     my ($t, $pos, $e) = split(/\t/, $l);
     $CODES->{$t}{$e} = $pos + 0;
    }
    close(O);
  }
}

  
sub get_sev_image {
  my($class, $sev) = @_;
  my $im;
  if ($sev == 0) {
    $im = "Notice";
  } elsif ($sev == 1) {
    $im = "Warning";
  } elsif ($sev == 2) {
    $im = "Error";
  } elsif ($sev == 3) {
    $im = "Error/ Critical";
  }
  return $im;
}

sub get_sev_image0 {
  my($class, $sev) = @_;
  my $im;
  if ($sev == 1) {
    $im = "<img src=/gif/al_alert3.gif alt=\"Warning\">";
  } elsif ($sev == 2) {
    $im = "<img src=/gif/al_crit3.gif alt=\"Error\"> ";
  } elsif ($sev == 3) {
    $im = "<img src=/gif/al_down3.gif alt=\"Error/Critical\">";
  }
  return $im;
}


#  from type/component

sub getInfoString {
  my($class, $type, $comp, $code, $asObject) = @_;
  my @C = ('INFORMATION','PROBABLE-CAUSE','RECOMMENDED-ACTION');

  my $ev = $class->getInfo($type, $comp, {code => $code});
  my $s;
  my $cnt = 0;
  foreach my $k ('info', 'cause', 'action') {
     if ($ev->{$k}) {
       my $v = "  " . $ev->{$k};
       $v =~ s/\n/\n  /g;
       $s .= $C[$cnt] . ":\n$v";
     }
     $cnt++;
  }
  if (wantarray) {
    return($ev->{info}, $ev->{cause}, $ev->{action}, $ev->{code});
  } elsif ($asObject) {
    return $ev;
  } else {
    return $s;
  }
  

}

sub toReport0 {
  my($class) = @_;
  my $filelist = $class->readFiles();
  my $out  = "StorADE 2.2 Event Grid Short Listing\n";
  $out .= "Event/Description                        Code        Severity Actionable\n";
  $out .= "---------------------------------------- ----------- -------- ------------------------------------- \n";
  my @SEV = ('Normal','Warning','Error','Down');
  foreach my $f (sort @$filelist) {
    my $events = Grid->read($f);
    foreach my $event (sort keys %$events) {
       my $v = $events->{$event};
       my $tt = $v->{type};
       $tt .= ".$v->{comp}" if ($v->{comp});
       my $no = $v->{code};
       my $act = $v->{actionable} ? "Yes" : "No";
       my $sev = $SEV[$v->{severity}];
       $out .= sprintf("%-40.40s %-12.12s %-8.8s %-4.4s\n      %s\n", 
              $tt,
              $v->{code},
              $sev,
              $act,
              $v->{desc}, 
               );

    }
  }
  return $out;
}

sub toXML {
  my($class) = @_;
  my $filelist = $class->readFiles();
  my $out  = "<?xml version=\"1.0\"?>\n<grid>\n";

  foreach my $f (sort @$filelist) {
     my $events = Grid->read($f);
     foreach my $event (sort keys %$events) {
       my $v = $events->{$event};
       my $tt = $v->{type};
       $tt .= ".$v->{comp}" if ($v->{comp});
       my $no = $v->{code};
       $out .= "  <event code=\"$tt\" no=\"$no\">\n";
       foreach my $el ('pattern','severity','actionable') {
          $out .= "    <$el>$v->{$el}</$el>\n";
       }
       foreach my $el ('desc','info','cause','action') {
          my $val = $v->{$el};
          chomp($val);
          $val =~ s/\n/\n /g;
          my $nl = index($val, "\n") > 0 ? "\n    " : "";
          $out .= "    <$el>$val$nl</$el>\n";
       }
       $out .= "  </event>\n";
    }
  }
  $out .= "</grid>\n";
  return $out;
}

sub find_type_category {
  my($type) = @_;
  if ($Report::ISSWITCH{$type} ) {
     return "switch";
  } elsif ($type eq "host") {
     return "host";
  } else {
     return "storage";
  }
}

sub readFiles {
  my($class) = @_;
  my(@list);
  my $F = System->get_home() . "/System/EGrid";
  opendir(O, $F);
  my @files = readdir(O); closedir(O);
  foreach my $f (@files) {
     if ($f =~ /\.grid$/) {
        push(@list, $f);
     }
  }
  return \@list;
}

sub readIndex {
  my($class) = @_;
  my($l);
  my $DIR = System->get_home() . "/System/EGrid";
  if ($#GRIDIDX < 0) {
    if (open(O, "$DIR/Grid.idx")) {
      while ($l = <O>) {
        chop($l);
        my @a = split(/ \| /, $l);
        my $code = $a[0];
        $code .= ".$a[1]" if ($a[1]);
        $GRIDHASH{$code} = $a[2];
        push(@GRIDIDX, $l);
      }
      close(O);
    } else {
      return undef;
    }
  }
}


# grap  all section of the Grid for this event
sub getInfo {
  my($class, $type, $comp, $arg) = @_;

  my $code = $arg->{code};
  my $ev = $class->getInfo_($type, $comp, $code);
  return $ev if ($ev);

  my($c1, $t1) = split(/\./, $type, 2);
  if ($c1 ne "host" && $t1 eq "LogEvent") {
     $ev = $class->getInfo_("host.$t1", $comp, $code);
  }
  return $ev;
}

sub getInfo_ {
  my($class, $type, $comp, $code) = @_;

  $class->readIndex();

  my ($type1, $comp1, $file1, $found, $pat, $san_type1, $san_type2, $foundR);
  my ($foundS, $foundSR, $foundAny);
  my($st_type1, $st_type2);
  if (substr($type, 0,4) eq "san.") {
     ($san_type1, $san_type2) = split(/\|/, $comp);
     $st_type1 = &find_type_category($san_type1);
     $st_type2 = &find_type_category($san_type2);

  # HAS A CODE ALREADY, USE IT
  } elsif ($code && $GRIDHASH{$code}) {
     my $file = $GRIDHASH{$code};
     my($t1, $e1, $c1) = split(/\./, $code, 3);
     return $class->readEvent($file, "$t1.$e1", $c1);
  }
  
  foreach my $l (@GRIDIDX) {
      ($type1, $comp1, $file1, $pat) = split(/ \| /, $l);
      if ($san_type1) {  # link | link events
         next if ($type1 ne $type);
         my ($s_type1, $s_type2) = split(/\|/, $comp1);
         if ($s_type1 eq $san_type1 && ($s_type2 eq $san_type2) ) {
            $found = [$file1, $type1, $comp1];
            last;
         } elsif ($s_type1 eq $san_type2 && ($s_type2 eq $san_type1) ) {
            $foundR = [$file1, $type1, $comp1];
         } elsif ($s_type1 eq $st_type1 && ($s_type2 eq $st_type2) ) {
            $foundS = [$file1, $type1, $comp1];
         } elsif ($s_type1 eq $st_type2 && ($s_type2 eq $st_type1) ) {
            $foundSR = [$file1, $type1, $comp1];
         } elsif ($s_type1 eq "Any" && ($s_type2 eq "Any") ) {
            $foundAny = [$file1, $type1, $comp1];
         }
         
      } else {
        $pat =~ s/\t//g;
        my $t = $type1;
        chop($t) if (index("+-", substr($t,-1)) >= 0);
        if ($type eq $t) {
           if ($pat) {
             $found = [$file1, $type1, $comp1] if ($comp =~ /$pat/);
           } elsif ($comp1 && $comp1 ne "enclosure") {
             $found = [$file1, $type1, $comp1] if ($comp eq $comp1);
           } else {
              $found = [$file1, $type1, $comp1];
           }
           last if ($found);
        }
      }
  }
  my $el;
  if ($found) {
    $el = $class->readEvent($found->[0], $found->[1], $found->[2]);
  } elsif ($foundS) {
    $el = $class->readEvent($foundS->[0], $foundS->[1], $foundS->[2]);
  } elsif ($foundR) {
    $el = $class->readEvent($foundR->[0], $foundR->[1], $foundR->[2]);
  } elsif ($foundSR) {
    $el = $class->readEvent($foundSR->[0], $foundSR->[1], $foundSR->[2]);
  } elsif ($foundAny) {
    $el = $class->readEvent($foundAny->[0], $foundAny->[1], $foundAny->[2]);
  }
  return $el;

}

sub write {
  my($h, $file,  $arg) = @_;
  $ERROR = undef;
  my $langOnly = $arg->{langOnly};
  my $LANG = "/Lang" if (index($file, "/") > 0);

  if (open(W, ">" . System->get_home() . "$LANG/System/EGrid/$file")) {
    print W "######################\n";
    print W "# $file\n";
    print W "######################\n\n";

    foreach my $event (sort keys %$h) {
       my $v = $h->{$event};
       my $tt = $v->{type};
       $tt .= ".$v->{comp}" if ($v->{comp});
       print W "type=$tt\n";
       #print W "comp=$v->{comp}\n" if ($v->{comp});
       print W "code=$v->{code}\n" if ($v->{code});
       if (!$langOnly) {
          print W "pattern=$v->{pattern}\n" if ($v->{pattern});
          print W "severity=$v->{severity}\n";
          print W "actionable=$v->{actionable}\n";
       }
       foreach my $k ('desc', 'info', 'cause', 'action') {
          my $desc = $v->{$k};
          next if (!$desc);
          $desc =~ s/\n/\n'/g;
          $desc =~ s/
//g;
          $desc = substr($desc,0,-2) if (substr($desc,-2) eq "\n'");
          print W "$k=$desc\n";
       }
       print W "\n\n";
    }
    close(W);

  } else {
    $ERROR = "Cannot  write to $file: $!";
    return undef;
  }
}

sub sync {
  my($class, $v1, $v2, $mark) = @_;

  foreach my  $el (keys %$v1) {
       if (exists $v2->{$el}) {
          $v1->{$el}{desc} = $v2->{$el}{desc};
          $v1->{$el}{info} = $v2->{$el}{info};
          $v1->{$el}{cause} = $v2->{$el}{cause};
          $v1->{$el}{action} = $v2->{$el}{action};
       } else {
          $v1->{$el}{desc}  .= $mark;
       }
  } 
  return $v1;
}


# $T3G = Grid->read('t3.grid', {codeOrder => 1} );

sub read {
  my($class, $file, $arg) = @_;
  my $renv = System->get_renv();
  my $ruser = System->get_ruser();
  my $byCode = $arg->{codeOrder};
  my $lang = $ruser->{language} || $renv->{language};
  
  my $D =  System->get_home() . "/Lang/System/EGrid";
  my $lfile =  "$lang/$file";

  if (-f  "$D/$lfile") {
     return $class->read_($lfile, $byCode);
  } else {
     return $class->read_($file, $byCode);
  }
}
  

sub read_ {
  my($class, $file, $byCode) = @_;
  my %H;
  my($which, $l, $el);
  $ERROR = undef;
  my $LANG = "/Lang" if (index($file, "/") > 0);

  if (open(O1, System->get_home() . "$LANG/System/EGrid/$file")) {

    while ($l = <O1>) {
       if ($l =~ /^type=(.*)/) {
          my $t1 = $1;
          if ($el->{type}) {
              my $comp = $el->{comp} || "enclosure";
              my $k = $byCode ? $el->{code} : "$el->{type}.$comp";
              $H{$k} = $el;
              $el = {};
              $which = 0;
          }
          my @t1 = split(/\./, $t1, 3);
          $el->{type} = "$t1[0].$t1[1]";
          $el->{comp} = $t1[2];

       #} elsif ($l =~ /^comp=(.*)/) {
       #   $el->{comp} = $1;

       } elsif ($l =~ /^code=(.*)/) {
          $el->{code} = $1;

       } elsif ($l =~ /^severity=(.*)/) {
          $el->{severity} = $1;

       } elsif ($l =~ /^actionable=(.*)/) {
          $el->{actionable} = $1;

       } elsif ($l =~ /^pattern=(.*)/) {
          $el->{pattern} = $1;

       } elsif ($l =~ /^desc=/) {
          $el->{desc} = substr($l,5);
          $which = 3;

       } elsif ($l =~ /^info=/) {
          $el->{info} = substr($l,5);
          $which = 1;

       } elsif ($l =~ /^cause=/) {
          $el->{cause} = substr($l,6);
          $which = 4;

       } elsif ($l =~ /^action=/) {
          $el->{action} = substr($l,7);
          $which = 2;

       } elsif (substr($l,0,1) eq "'") {
          if ($which == 3) {
            $el->{desc} .= substr($l,1) ;

          } elsif ($which == 4) {
            $el->{cause} .= substr($l,1) ;

          } elsif ($which == 1) {
            $el->{info} .= substr($l,1) ;

          } elsif ($which == 2) {
            $el->{action} .= substr($l,1);
          }
       }
     }
     close(O);
     my $comp = $el->{comp} || "enclosure";
     my $k = $byCode ? $el->{code} : "$el->{type}.$comp";
     $H{$k} = $el;
   } else {
     $ERROR = "Cannot read $file";
     return undef;
   }
   delete($H{"ZZ.enclosure"});
   my $H = \%H;
   bless($H, 'Grid');
}
  
sub list {
  my($class, $arg) = @_;
  my(@G, @S, $l);
  my $byCode = $arg->{codeOrder};
  if ($byCode) {
     open(O, "/net/code/usr6/Events/GridCodes");
     while ($l = <O>) {
        chop($l);
        if ($l =~ /^TYPE/) {
           my @x = split(/\t/, $l);
           $G[$x[1]+0] = "$x[2].grid";
        }
     }
     close(O);
     return \@G;
  }
  opendir(O, System->get_home() . "/System/EGrid");
  while ($l = readdir(O)) {
     next if ($l !~ /.grid$/);
     push(@G, $l);
  }
  closedir(O);
  return \@G;
}
    
  
sub updateEvent {
  my($class, $file, $type, $comp, $info, $cause, $action) = @_;

  my $h = Grid->read($file);
  #foreach my $k (keys %$h) {print "read=$k<br>"}
  my $e = $h->{"$type.$comp"};
  if ($e) {
    $e->{info} = $info     if (defined($info));
    $e->{cause} = $cause   if (defined($cause));
    $e->{action} = $action if (defined($action));
    $h->write( $file);

  } else {
    $ERROR = "Cannot find $type.$comp";
    return undef;
  }
}

sub readEvent {
  my($grid, $file, $type, $comp) = @_;

  $type = Util->rtrim($type);
  $comp = Util->rtrim($comp);

  my $h = Grid->read($file);
  return $h->{"$type.$comp"};
  

}

1;
