package GUIAdmin::VE;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: VE.pm,v 1.31 2003/03/10 03:23:31 ccadieux Exp $

use PDM;
use strict;
use Debug;
use Carp;
use GUIAdmin;
use GUI::Discover;
use GUI::Devices;
use GUI::Devices;
use GUIAdmin::Solution;
use base 'GUIAdmin';

sub description {}  # no entry in the discovery select-box

sub isDevice {      # no  manual addition.
   return 0;
}
sub ipRequired {1}

sub discover {
  my($q) = @_;

  if ($q->{ACTION_back1}) {
     GUI::Discover::run($q);
     return;
  } elsif ($q->{ACTION_back2}) {
     GUI::Devices::add($q);
     return;
  } elsif ($q->{ACTION} =~ /Confirm/) {
     &discover1($q);
     GUI::Devices::list($q);
     return;
  }

  # print Html->body();
  my($renv, $dev, $hostList, $notifs) = PDM::ConfigFile->read();

  my $hosts = "<select name=subhost><option value=\"\">Local</option>";

  foreach my $d (@$hostList) {
     next if($d->{dh} eq "Y");

     my $sel = $d->{hostname} eq $q->{select_host}? "selected" : "";
     $hosts .= "<option $sel>$d->{hostname}</option>";
  }
  $hosts .= "</select>";
  
  my ($ti, $head, $info, $back);
  if ($q->{ADD}) {
     $ti = "Add";
     $info = Util->readHtdocs("ve_discover");
     $back = "<input type=submit name=ACTION_back2 value=Back>";
  } else {
     $ti = "Discovery";
     $head = Html->body() . Html->header2("admin.gen_maint.discovery", undef, " Virtualization Engine", "ve_discover");
     $back = "<input type=submit name=ACTION_back1 value=Back>";
  }
  my $o =<<EOF;
$head
<table border=0 cellpadding=4 width=90% bgcolor=white><tr><td>
$info
</table>
  <form method=get>
  <input type=hidden name=GO value=GUI::Discover::discover>
  <input type=hidden name=PKG value=GUIAdmin::VE::discover>
  <table border=1 cellspacing=0 cellpadding=0 bgcolor=white width=90%>

    <tr><td width=30% align=right bgcolor=$Style::LIGHT><b>Select Host: </td>
        <td>$hosts</td>
    <tr><td width=30% align=right bgcolor=$Style::LIGHT><b>Turn Monitoring On: </td>
        <td><input type=checkbox checked name=monitor_on></td>
  </table>
  <b><center>&nbsp;<br>
    <input type=submit name=ACTION value="Confirm Sun VE $ti">&nbsp;
    $back 
    <br>&nbsp;
 </form>
EOF
  print $o;

}

sub discover1 {
  my( $q, $post, $util) = @_;

  my(%T, @a, $loc, $ip, %F, @NEW, $new_dev);

  my $monitor_on = $q->{monitor_on};
  my($renv, $devs, $hosts, $notifs) = PDM::ConfigFile->read;
 
  my($log) = $renv->{t300logfile};
  my($cnt) = 0;
  foreach my $d (@$devs) {
     if ($d->{class} =~ /^switch.ve/) {
        $cnt++;
        $F{$d->{key}} = 1;
     }
  }
  print "<pre>1 - Found $cnt Sun VE already registered ...\n";
  my $ALL;
  if (!$q->{subhost}) {
    print "2 - Finding local Sun VE ...\n";
    $ALL = Logic::Solution::get_rack({VEONLY => 1});
  } else {

    print "3 - Finding remote ve's...\n";
    foreach my $h (@$hosts) {
       next if($h->{dh} eq "Y");

       next if ($q->{subhost} && $q->{subhost} ne $h->{hostname});
       print "  - Querying host $h->{hostname} / $h->{ipno} ...\n";
       push(@$ALL, "**" . $h->{hostname});

       my $rc = Util::Http->getCommand($h->{ipno}, "Logic::Solution::rack&HTTP=1&VEONLY=1", 200);

       if (substr($rc,0,2) ne "OK") {
         print "<font color=red><b>Error: $rc";
         next;
       } else {
         my @A = split(/\n/, substr($rc,2));
         push(@$ALL, @A);
       }
    }
  }
  my($adding, $found, $short);

  my $curr_host = "";
  my $prefix = Util->shortHostname($renv->{hostname});
  $new_dev = $#$devs;
  foreach my $line (@$ALL) {
    my($class, $type, $name, $ip, $wwn, $key, $wwn2, $init) = split(/\|/, $line);
    if (substr($class,0,2) eq "**") {
       $curr_host = substr($class,2);
       $prefix    = Util->shortHostname($curr_host);
       next;
    }
    if ($class eq "ERR") {
       print "  Error: $type<br>\n";
       next;
    }
    next if ($class ne "switch.ve");
    if (!$wwn) {
       print "  No wwn for $type:$name:$ip, cannot add!<br>.\n";
       next;
    }
    if (!$F{$key}) {
      $F{$key} = 1;
      $adding = 1;
      $found++;
      $new_dev++;
      my($ip1,$ip2,$ip3, $ip4) = split(/\./, $ip);
      $devs->[$new_dev]{_name}    = "device" . $new_dev;
      $devs->[$new_dev]{type}     = $type;
      $devs->[$new_dev]{key}      = $key;
      $devs->[$new_dev]{wwn}      = $wwn;
      $devs->[$new_dev]{login}    = $wwn2;
      $devs->[$new_dev]{initiator}= $init;
      $devs->[$new_dev]{class}    = $class;
      if ($name) {
        $devs->[$new_dev]{name}   = "$prefix-$name";
      } else {
        $devs->[$new_dev]{name}   = $prefix."-" . sprintf("%3.3d", $ip4);
      }
      $devs->[$new_dev]{ip}       = $ip;
      $devs->[$new_dev]{ipno}     = $ip;
      $devs->[$new_dev]{host}     = $curr_host;
      #$devs->[$new_dev]{datahost} = "*None";
      $devs->[$new_dev]{active}   = ($monitor_on ? "Y":"N");
      print " $type:$ip added. \n";
    } else {
      print " $type:$ip already exist.\n";
    }
  }
  if ($adding) {
    PDM::ConfigFile->write( $renv, $devs, $hosts,$notifs);
  } else {
    print "  *** No new devices found***\n";
  }

  print "</pre>";
}

sub addDevice {
  my($class, $q) = @_;
  my($ho, $o, $err, $ipno, $x, $info);
  my($renv, $dev, $host,$notifs, $sel);
  my $deny = Roles->verifyRole($q, "admin");
  if ($deny) {
     print $deny;
     return;
  }
  $q->{ADD} = 1;
  print Html->body();
  print GUI::Devices::add0($q);
  print "&nbsp;";
  &discover($q);
}


sub updDevice {
  my($class, $q) = @_;
  my($ho, $o);
  my($name, $err, $ip, $ipno);
  my($renv, $dev, $host,$notifs, $x, $D, $type, $key, $h1, $h, $sel, $active);

  print Html->body();
  require "GUI/Devices.pm";
   my $deny = Roles->verifyRole($q, "admin");

  if ($q->{ACTION} eq "Back") {
    GUI::Devices::list($q);
    return;

  } elsif ($q->{ACTION} eq "Update") {
    ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
    $x = $q->{no};
    $D = $dev->[$x];

    $dev->[$x]{name} = $q->{name};

    GUIAdmin->clearSlave($q->{host}, $host);

    PDM::ConfigFile->write( $renv, $dev, $host,$notifs);
    $err = Html->error("Device $name updated!", "green");

  } elsif ($q->{ACTION} eq "Delete") {
    ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
    $x = $q->{no};
    $type = $dev->[$x]{type};
    $key =  $dev->[$x]{ip};
    GUIAdmin->clearSlave($q->{host}, $host);

    Events->saveEvent("DD", $type,  $key) if ($key);
    $dev->[$x]{_name} = "";
    $name = $dev->[$x]{name} . "/ " . $dev->[$x]{ip};
    PDM::ConfigFile->write( $renv, $dev, $host,$notifs);
    &main::log_change("Device $name deleted");
    $q->{ERR} = Html->error("Device $name deleted!");
    GUI::Devices::list($q);
    return;
  }
out:

 $h1 = Html->header2("admin.gen_maint.maint_device", undef, "Sun VE"," ");

  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
  $h = $dev->[$q->{no}];

  $ip = $h->{ip}; $ipno = $h->{ipno};

  $ho = $h->{host};

  $active = ($h->{active} eq "Y") ? "On":"Off";

  $o =<<EOF;
<body bgcolor=$Style::BGCOLOR>
<form method=get>
 <input type=hidden name=GO value="GUIAdmin::VE->updDevice">
 <input type=hidden name=no value=$q->{no}>
<center>
$h1
$err
<table border=1 cellspacing=0 width=90% bgcolor=white><tr><td>
<table border=0 cellspacing=2 cellpadding=2 width=100%>
<tr>
<td colspan=2 bgcolor=$Style::DARK><b><font color=white>&nbsp;Device Information</td>

<tr><td bgcolor=$Style::LIGHT align=right>Device Type :</td>
    <td>
      <table border=0 cellspacing=0 width=100%> <tr>
        <td><b>&nbsp;$h->{type}</td>
        <td bgcolor=$Style::LIGHT align=right>Monitoring:</td>
        <td ><b>&nbsp;$active</td>
      </table>

<tr><td bgcolor=$Style::LIGHT width=30% align=right>Device Name :</td>
    <td><input type=text name=name size=20 maxlength=40 value="$h->{name}">

<tr><td bgcolor=$Style::LIGHT width=30% nowrap align=right>IP Name/Address :</td>
    <td>&nbsp;$ip</td>
<tr><td bgcolor=$Style::LIGHT width=30% nowrap align=right>IP Number :</td>
    <td>&nbsp;$ipno</td>
<tr><td bgcolor=$Style::LIGHT width=30% nowrap align=right>SLICD Login:</td>
    <td>&nbsp;$h->{login}</td>

<tr><td bgcolor=$Style::LIGHT width=30% nowrap align=right>Initiator :</td>
    <td>&nbsp;$h->{initiator}</td>

<tr><td bgcolor=$Style::LIGHT align=right>WWN :</td>
    <td><b>$h->{wwn}</td>
<tr><td bgcolor=$Style::LIGHT align=right>Primary Host :</td>
    <td><b>$ho</td>

</table>
</table>
<b>
EOF

  print $o;
  if (!$deny) {
      print "<input type=submit name=ACTION value=\"Update\">
             <input type=submit name=ACTION value=\"Delete\">";
  }
  print " <input type=submit name=ACTION value=\"Back\">
  </form>";

}


1;

