package GUIAdmin::Subnet;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: Subnet.pm,v 1.39 2003/02/06 17:47:19 ccadieux Exp $

use PDM;

use strict;
use Debug;
use Carp;
use GUIAdmin;
use GUI::Discover;
use base 'GUIAdmin';
use Agent::T3;
use Logic::Subnet;

sub description {'Subnet'}
sub isDevice {0}

sub ipRequired {0}

sub discover {
  my( $q, $post, $util) = @_;
  my($o, $err);
  #print Html->body();
  my $LB = Labels->read("GUIAdmin::Subnet");
  my $G  = Labels->read();

  if ($q->{ACTION_back}) {
       GUI::Discover::run($q);
       return;

  } elsif ($q->{ACTION_confirm}) {
     print "<pre>";
     my($err, $nodes, $info) = Logic::Subnet->addToConfig($q);
     $info =~ s/\n/<br>/g;
     print $info ;
     if ($err) {
        print $err->toHtml();
     } elsif ($#$nodes >= 0) {
        print "Added " . ($#$nodes+1) . " devices! <br>";
     }
     print "</pre>";
  }

  my($h) = Html->header2("admin.gen_maint.discovery", undef, $LB->{subnet}, "discover_subnet");
  my($ip)    = Util->name2ip(System->hostname() );
  my($ix) = rindex($ip, ".");
  $ip = substr($ip, 0, $ix);
  my($renv, $dev, $host,$notifs) = PDM::ConfigFile->read();
  my $hosts = "<select name=host><option value=\"\">$G->{local}</option>";
  foreach my $d (@$host) {
     next if($d->{dh} eq "Y");
     my $sel;
     if($d->{hostname} eq $q->{select_host}){
        $sel = "selected";
	$ip  = Util->name2ip($d->{hostname} );
        my($ix) = rindex($ip, ".");
        $ip  = substr($ip, 0, $ix);

     }
     $hosts .= "<option $sel VALUE=\"$d->{hostname}\" > $d->{hostname} ($d->{ipno})";

  }
  $hosts .= "</select>";

  $o =<<EOF;
 <body bgcolor=$Style::BGCOLOR><center>
 $h  $err
  <form method=get>
  <input type=hidden name=GO value=GUI::Discover::discover>
  <input type=hidden name=PKG value=GUIAdmin::Subnet::discover>
  <tr><td bgcolor=white><center>
    <table border=0 cellspacing=1 cellpadding=0 bgcolor=white width=85%>
    <tr><td bgcolor=gray colspan=2><table border=0 cellpadding=1 cellspacing=0><tr><td></table></td>
    <tr><td align=right bgcolor=$Style::LIGHT><b>$LB->{run}: </td>
        <td><b>&nbsp;$hosts</td>
    <tr><td align=right bgcolor=$Style::LIGHT><b> $LB->{search}: </td>
        <td>&nbsp;$LB->{sub1}:<input type=text name=SUB1 value="$ip">&nbsp;
              $LB->{sub2}:<input type=text name=SUB2><br>
        &nbsp;$LB->{sub3}:<input type=text name=SUB3>&nbsp;
              $LB->{sub4}:<input type=text name=SUB4><br>
        &nbsp;$LB->{sub5}:<input type=text name=SUB5>&nbsp;
              $LB->{sub6}:<input type=text name=SUB6><br>
        </td>
    <tr><td align=right  bgcolor=$Style::LIGHT><b> $LB->{use}: </td>
        <td><b>&nbsp;<input type=checkbox name=prefixT></td>
    <tr><td align=right  bgcolor=$Style::LIGHT><b> $LB->{usecustom}: </td>
        <td>&nbsp;<input type=text name=prefix value="$q->{prefix}"</td>
    <tr><td align=right  bgcolor=$Style::LIGHT><b> $LB->{snmp}: </td>
        <td>&nbsp;<input type=text name=timeout size=2 value="$q->{timeout}"</td>

    <tr><td bgcolor=gray colspan=2><table border=0 cellpadding=1 cellspacing=0><tr><td></table></td>

    <tr><td align=right bgcolor=#F0F0C0><b>$LB->{mon_on}: </td>
        <td><input type=checkbox name=monitor_on CHECKED></td>
    <tr><td bgcolor=gray colspan=2><table border=0 cellpadding=1 cellspacing=0><tr><td></table></td>
    </table>
    <b><center>&nbsp;<br>
    <input type=submit name=ACTION_confirm value="$LB->{submit_confirm}">&nbsp;
    <input type=submit name=ACTION_back value="$LB->{submit_back}"><br>&nbsp;
 </form>
EOF

  print $o;
  return 0;

}


1;
