package GUIAdmin::Internal;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Id: Internal.pm,v 1.24 2003/03/29 16:52:34 ccadieux Exp $

use PDM;

use strict;
use Debug;
use Carp;
use GUIAdmin;
use GUI::Devices;
use base 'GUIAdmin';

sub description {'Sun Internal FC Disks'}
sub isDevice {1}


sub discover {
  my($class, $q) = @_;
  GUIAdmin::Internal->direct_add($q);
#  GUIAdmin::Internal->addDevice($q);
  return "DONE";
}
  
sub direct_add {
    my($class, $q) = @_;
    my $G = Labels->read();
    my($active) = "Y";
    my $done;
    my @F;
    my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
    my $agfile;
    $agfile = System->get_home()."/DATA/rasagent.conf";
    my $L = Labels->read("GUIAdmin::Internal");
    my %FOUND;
    foreach my $d (@$devs) {
        if ($d->{type} eq "internal" ) {
           $FOUND{$d->{host} || $renv->{hostname}} = 1;
        }
    }

    my $topology;
    if (-f System->get_home() ."/DATA/topo/MERGE-MASTER") {
      $topology = TO->readTopo("MERGE-MASTER");
    } else {
      $topology = TO->readTopo();
    }
    my $storage= TO::storageList($topology);
    my $cnt;
    foreach my $st (@$storage){
       if ($st->info("type") eq "internal") {
          my $h1 = $st->info("host");
          if ($FOUND{$h1}) {
              print &description() . " $h1 " . $G->{already_exist} . "<br>";
          } else {
	      my $n_host;
	      if($h1 =~ /$renv->{hostname}/){
	        $n_host ="";
	      }else{
	        $n_host = $h1;
	      }
              $FOUND{$h1} = 1;
              my $new_dev = $#$devs + 1;
              $devs->[$new_dev]{_name}    = "device" . $new_dev;
              $devs->[$new_dev]{type}     = "internal";
              $devs->[$new_dev]{class}    = "storage.internal";
              $devs->[$new_dev]{name}     = Util->shortHostname($h1);
              $devs->[$new_dev]{key}      = "ID$h1";
              $devs->[$new_dev]{host}     = $n_host;
              $devs->[$new_dev]{active}   = "Y";
              $cnt++;
              Logic->clearSlave($h1, $hosts);
          }
       }
    }
    if ($cnt) {
       PDM::ConfigFile->write( $renv, $devs, $hosts,$notifs);
       print $G->expand('x_devices_added', $cnt);
    } else {
       print Html->info($L->{no_disk_found});
    }
}


sub addDevice {
  my($class,$q) = @_;

  my($ho, $o, $err, $ipno, $x, $info);
  my($renv, $devs, $hosts,$notifs, $sel);
  print Html->body();

  my $deny = Roles->verifyRole($q, "admin");
  my $G = Labels->read();
  my $L = Labels->read("GUIAdmin::Internal");
  my %FOUND;
  require "GUI/Devices.pm";

  if ($q->{ACTION_back}) {
    if ($q->{DISCO}) {
      GUI::Discover::run($q);
    } else {
      GUI::Devices::add($q);
    }
    return;

  } elsif ($q->{ACTION_add}) {
    my($active) = "Y";
    my $done;
    ($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
    foreach my $d (@$devs) {
        if ($d->{type} eq "internal" ) {
           $FOUND{$d->{host} || $renv->{hostname}} = 1; 
           $done = 1;
        }
    }
    if ($done) {
       print Html->warning($L->expand('no_new2' => &description()));

    } else {   # not find internal disk in rasagent.conf file
               # need check topo file 

            my $topology;
            if (-f System->get_home() ."/DATA/topo/MERGE-MASTER") {
                 $topology = TO->readTopo("MERGE-MASTER");
            } else {
                 $topology = TO->readTopo();
            }

            my $storage= TO::storageList($topology);
            my $cnt;


            foreach my $st (@$storage) {
               if ( $st->info("type") eq "internal") {
                  my $h1 = $st->info("host");
                  if ($FOUND{$h1}) {
                      print &description() . " $h1 " . $G->{already_exist} . "<br>";
                  } else { 
                    $FOUND{$h1} = 1; 
                    my($new_dev) = $#$devs  + 1;
                    $devs->[$new_dev]{_name}    = "device" . $new_dev;
                    $devs->[$new_dev]{type}     = "internal";
                    $devs->[$new_dev]{class}    = "storage.internal";
                    $devs->[$new_dev]{name}     =  Util->shortHostname($h1);
                    $devs->[$new_dev]{key}      = "ID.$h1" ;
		    $devs->[$new_dev]{host}     = $q->{host};
                    $devs->[$new_dev]{active}   = "Y";
                    $cnt++;
                    Logic->clearSlave($q->{host}, $hosts);
                 }
              }
           }
           if ($cnt) {
                 PDM::ConfigFile->write( $renv, $devs, $hosts,$notifs);
                 print $G->expand('x_devices_added', $cnt);
           } else {
                 print Html->info($L->{no_disk_found});
           }
           GUI::Devices::list($q);
           return; 
      } 
   }
out:
  print GUI::Devices::add0($q) if (!$q->{DISCO});

  my($h) = Html->header($G->{add} . " " . &description() ,"","",
              "Maintenance.General#adddevice", undef, {nohelp => 1});

  my ($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read;

  $ho = "<select name=host><option value=\"\">$G->{local}</option>";
  foreach my $h1 (@$hosts) {
     next if($x->{dh} eq "Y");
       $ho .= "<option name=$h1->{hostname}>$h1->{hostname}</option>";
  }
  $ho .= "</select>";

  $o =<<EOF;
<form  method=get>
 <input type=hidden name=GO value="GUIAdmin::Internal->addDevice">
 <input type=hidden name=DISCO value=$q->{DISCO}>
<center>
$h
$info
<table border=2 cellspacing=2 width=90% bgcolor=white><tr><td>
<table border=0 cellspacing=2 width=100%>
<tr><td colspan=2 bgcolor=$Style::DARK><b><font color=white>&nbsp;$G->{enter_device_info}</td>
<tr><td bgcolor=$Style::LIGHT align=right>$G->{host}:</td><td>$ho</td>
</table>
</table>
<b>
EOF
  print $o;
  if (!$deny) {
     print "<input type=submit name=ACTION_add value=\" $G->{submit_add} \">";
  }
  print "<input type=submit name=ACTION_back value=\"$G->{submit_back}\"></form>";


}

1;

