package GUIAdmin::D2;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>


#       "@(#)D2.pm 1.9     01/09/18 SMI"

use PDM;
use Util;
use Agent;
use Agent::D2;
use strict;
use Debug;
use Carp;
use GUIAdmin;
use GUI::Devices;
use base 'GUIAdmin';

sub isDevice {1}
sub description {'Sun D2'};

sub ipRequired {1}


sub discover {
  my( $q, $post, $util) = @_;

  my $SELECT = $q->{select_host};

  my(%T, @a, $loc, $ip);
  my(%F);
  my(@NEW);
  my $G = Labels->read();

  my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read;
 
  my($cnt) = 0;
  foreach my $d (@$devs) {
     if ($d->{type} eq "d2") {
        $cnt++;
        $F{$d->{key}} = 1;
     }
  }
  print "<pre>1 - " . $G->expand('find_already', "$cnt D2") . " ($SELECT)...\n";

  if (!$SELECT || $SELECT eq "local") {
    print "2 - " . $G->expand('find_local', "D2") . "\n";
    my $local = &get_Devices($q,$post, $util);
  
    if (substr($local,0,3) eq "ERR") {
       print "LOCAL:   $local<br>";
    }
    my($skipit, $j, $addit) = 0;
  
    my($new_dev) = $#$devs;
  
    foreach my $l (@$local) {
       my($key, $path1, $path2) = split(/\|/, $l);
       next if (!$key);
       if (!$F{$key}) {
         $cnt++;
         print $G->expand('found_new',  "$path1/$key") . "\n";
         $new_dev++;
         $devs->[$new_dev]{_name}    = "device" . $new_dev;
         $devs->[$new_dev]{type}     = 'd2';
         $devs->[$new_dev]{class}    = 'storage.d2';
         $devs->[$new_dev]{name}     = $key;
         $devs->[$new_dev]{wwn}      = $path1;
         $devs->[$new_dev]{wwn2}     = $path2;
         $devs->[$new_dev]{key}      = $key;
         $devs->[$new_dev]{active}   = 'Y';
         $devs->[$new_dev]{host}     = "";
       } else {
         print "   $G->{already_exist} $path1/$key \n";
       }
    }
  }

  my($data, $d2, $file, $h, $url, $hbano);
  my($TO) = 20;
  print "3 - " . $G->expand('find_slave', "D2") . "\n";
  my($new_dev) = $#$devs;

  foreach $h (@$hosts) {
    next if($h->{dh} eq "Y");

    if (!$SELECT || $SELECT eq $h->{hostname}) {
      print "  - " . $G->expand('querying_host', "$h->{hostname} / $h->{ip}") .  "\n";
  
      if ( ($data = Util::Http->getCommand($h->{ip}, "GUIAdmin::D2::Devices&HTTP=1", $TO)) ) {
        @a = split(/\n/, $data);
        foreach my $d2 (@a) {
          my($key, $path1, $path2) = split(/\|/, $d2);
          next if (!$key);
	  next if ($key eq "OK ");
	  $key = substr($key,3);
          if (!$F{$key}) {
            $cnt++;
            print "    ". $G->expand('found_new', "$path1/ $key") . "\n";
            $new_dev++;
            $devs->[$new_dev]{_name}    = "device" . $new_dev;
            $devs->[$new_dev]{type}     = 'd2';
            $devs->[$new_dev]{class}    = 'storage.d2';
            $devs->[$new_dev]{name}     = $key;
            $devs->[$new_dev]{wwn}      = $path1;
            $devs->[$new_dev]{wwn2}     = $path2;
            $devs->[$new_dev]{key}      = $key;
            $devs->[$new_dev]{active}   = 'Y';
            $devs->[$new_dev]{host}     = $h->{hostname};
          }
        }
      }
    }
  }
  print $G->expand('fount_cnt_dev', $cnt,  "D2") . "\n";
  if ($cnt) {
     PDM::ConfigFile->write( $renv, $devs, $hosts,$notifs);
  }
  print "</pre>";
  GUI::Devices::list($q);
}

#
# returns the D2 that a slave has.
# response to a http request made by a master rasagent.

sub get_Devices {
  my($q, $post, $util) = @_;
  my(@out, $f, $l, $name, $hba, $in , $wwn);

  if ($q->{ACTION} =~ /identify/) {
     &identify($q);
     return ;
  }
  my($cnt) = 0;
  my($sesdev, $i, $found);
  my($error,$out) = Util->run_command("/bin/ls -C1 /dev/es", "",20);
  my($lux) = System->find_luxadm;
  my($TO) = 20;
  my $vpd = System->get_home() . "/bin/vpd";
  chdir System->get_home() . "/bin";
  my %K;

  foreach $sesdev (@$out) {
     my($err,$com) = Util->run_command("$lux inq /dev/es/$sesdev", "luxadm.txt" , $TO);
     if ("@$com" =~ / D2/) {
        my($err,$com) = Util->run_command("$vpd /dev/es/$sesdev 1", "luxadm.txt" , $TO);
        my $out;
        foreach my $l (@$com) {
           if (length($l) > 20) {
              $out .= substr($l,58);
           }
        }
        if ($out =~ /.SN (\d+)/) {
           my $key = $1;
           $K{$key} .= "|" if (exists($K{$key}));
           $K{$key} .= "/dev/es/$sesdev";
        }
     }
  }
  my @OUT;
  foreach my $k (keys %K) {
     push(@OUT, "$k|$K{$k}");
  }
  
  if ($q->{HTTP}) {
     print "OK " . join("\n", @OUT) . "\n";
  } else {
     return \@OUT;
  }
}


sub addDevice {
  my($class, $q) = @_;
  my($ho, $o, $err, $ipno, $x, $info);
  my($renv, $devs, $host,$notifs, $sel);
  my $G = Labels->read();

  print Html->body();
  my $deny = Roles->verifyRole($q, "admin");
  require "GUI/Devices.pm";
  if ($q->{ACTION_back}) {
    GUI::Devices::add($q);
    return;

  } elsif ($q->{ACTION_add}) {
    my($active) = "Y";
    while (1) {
     if ($q->{name} eq "" || $q->{serial}) {
        $err = Html->error($G->expand('device_X_mandat', "name/serial#"));
        last;
     } else {
        ($renv, $devs, $host,$notifs) =PDM::ConfigFile->read;
        foreach $x (@$devs) {
          if ($x->{name} eq $q->{name}) {
             $err = Html->error($G->expand('device_name_already'));
             goto out;
          } elsif ($x->{key} eq $q->{serial}) {
             $err = Html->error($G->expand('device_X_already', "Key"));
             goto out;
          }
        }
        $x = $#$devs + 1;
        $devs->[$x]{_name}    = "device$x";
        $devs->[$x]{type}     = "d2";
        $devs->[$x]{class}    = "storage.d2";
        $devs->[$x]{wwn}      = $q->{serial};
        $devs->[$x]{name}     = $q->{name};
        $devs->[$x]{active}   = "Y";
        $devs->[$x]{host}     = $q->{host};

        GUIAdmin->clearSlave($q->{host}, $host);

        if (!PDM::ConfigFile->write( $renv, $devs, $host,$notifs)) {
           print $G->{cannot_write_config} . "<br>";
        } else {
           $info = Html->info($G->{device_added});
        }

        GUI::Devices::list($q);
        return;
     }
     last;
    }
  }
out:
  print GUI::Devices::add0($q);

  my($h) = Html->header("$G->{add} Sun D2","","",
                "Maintenance.General#adddevice", undef, {nohelp => 1});

  ($renv, $devs, $host,$notifs) =PDM::ConfigFile->read();
  $sel = ($q->{host} eq "")? "selected":"";


  my($phost) = "<select name=host><option value=\"\">[$G->{select}]</option>".
              "<option value=\"\" $sel>$G->{local}</option>";
  foreach $x (@$host) {
    next if($x->{dh} eq "Y");
    $sel = ($q->{host} eq $x->{hostname})? "selected":"";
    $phost .= "<option value=" . $x->{hostname} . " $sel>" . $x->{hostname} ."</option>";
  }
  $phost .= "</select>";


  $o =<<EOF;
<form  method=get>
 <input type=hidden name=GO value="GUIAdmin::D2->addDevice">
<center>
$h
$err
<table border=1 cellspacing=0 width=90% bgcolor=white><tr><td>
<table border=0 cellspacing=2 width=100%>
<tr><td colspan=2 bgcolor=$Style::DARK><b><font color=white>&nbsp;$G->{enter_device_info}</td>

<tr><td bgcolor=$Style::LIGHT width=30% align=right>$G->{device_path}:</td>
    <td><input type=text name=name size=15 maxlength=35 value="$q->{name}">

<tr><td bgcolor=$Style::LIGHT align=right>$G->{primary_host}:</td>
    <td>$phost</td>
<tr><td bgcolor=$Style::LIGHT width=30% nowrap align=right>$G->{device_serial}:</td>
    <td><input type=text name=serial size=20 value="$q->{serial}">

</table>
</table>
<b>
EOF

  if (!$deny) {
     $o .= "<input type=submit name=ACTION_add value=\" $G->{submit_add} \">&nbsp;";
  }
  $o .= "<input type=submit name=ACTION_back value=\"$G->{submit_back}\"> </form>";
  print $o;

}

sub updDevice {
  my($class, $q) = @_;
  my($ho, $o);
  my($name, $err, $ip, $ipno);
  my($renv, $devs, $host,$notifs, $x, $D, $type, $key, $h1, $h, $sel, $active);
  my $G = Labels->read();

  my $deny = Roles->verifyRole($q, "admin");

  print Html->body();
  require "GUI/Devices.pm";

# print "updDevice: ACTION = $q->{ACTION}<br>";

  if ($q->{ACTION_back}) {
   my($hostname) = System->hostname();
   GUI::Devices::list($q);
   return;

  } elsif ($q->{ACTION_update}) {
    ($renv, $devs, $host,$notifs) =PDM::ConfigFile->read;
    $x = $q->{no};
    $D = $devs->[$x];

    $devs->[$x]{host} = $q->{host};
    $devs->[$x]{key}  = $q->{name};
    $devs->[$x]{name} = $q->{name};
    $devs->[$x]{wwn}  =  $q->{wwn};
    $devs->[$x]{wwn2} =  $q->{wwn2};

    GUIAdmin->clearSlave($q->{host}, $host);

    PDM::ConfigFile->write( $renv, $devs, $host,$notifs);
    $err = Html->info($G->expand('device_updated', $name));

  } elsif ($q->{ACTION_delete}) {
    ($renv, $devs, $host,$notifs) =PDM::ConfigFile->read;
    $x = $q->{no};
    $type = $devs->[$x]{type};
    $key =  $devs->[$x]{ip};
    GUIAdmin->clearSlave($q->{host}, $host);

    Events->saveEvent("DD", $type,  $key) if ($key);
    $devs->[$x]{_name} = "";
    $name = $devs->[$x]{name} . "/ " . $devs->[$x]{ip};
    PDM::ConfigFile->write( $renv, $devs, $host,$notifs);
    &main::log_change($G->expand('device_deleted',$name));
    $q->{ERR} = Html->error($G->expand('device_deleted',$name));
    GUI::Devices::list($q);
    return;
  }
out:

 $h1 = Html->header2("admin.gen_maint.maint_device", undef, "Sun D2"," ");

  ($renv, $devs, $host,$notifs) = PDM::ConfigFile->read;
  $h = $devs->[$q->{no}];

  $sel = ($h->{host})? "":"selected";

  $ho = "<select name=host><option value=\"\" $sel>$G->{local}</option>";
  foreach $h1 (@$host) {
       $sel = ($h1->{hostname} eq $h->{host}) ? "selected":"";
       $ho .= "<option name=$h1->{hostname} $sel>$h1->{hostname}</option>";
  }
  $ho .= "</select>";

  $active = ($h->{active} eq "Y") ? "On":"Off";

  $o =<<EOF;
<body bgcolor=$Style::BGCOLOR>
<form  method=get>
 <input type=hidden name=GO value="GUIAdmin::D2->updDevice">
 <input type=hidden name=no value=$q->{no}>
<center>
$h1
$err
<table border=1 cellspacing=0 width=90% bgcolor=white><tr><td>
<table border=0 cellspacing=2 width=100%>
<tr>
<td colspan=2 bgcolor=$Style::DARK><b><font color=white>&nbsp;$G->{enter_device_info}</td>

<tr><td bgcolor=$Style::LIGHT align=right>$G->{device_type}:</td>
    <td>
      <table border=0 cellspacing=0 width=100%> <tr>
        <td><b>&nbsp;$h->{type}</td>
        <td bgcolor=$Style::LIGHT align=right>$G->{monitoring}:</td>
        <td ><b>&nbsp;$active</td>
      </table>

<tr><td bgcolor=$Style::LIGHT width=30% align=right>$G->{device_name}:</td>
    <td><input type=text name=name size=20 maxlength=40 value="$h->{name}">

<tr><td bgcolor=$Style::LIGHT align=right>$G->{device_path1}:</td>
    <td><b><input type=text size=20 name=wwn value=\"$h->{wwn}\"></td>

<tr><td bgcolor=$Style::LIGHT align=right>$G->{device_path2}:</td>
    <td><b><input type=text size=20 name=wwn2 value=\"$h->{wwn2}\"></td>

<tr><td bgcolor=$Style::LIGHT align=right>$G->{primary_host}:</td>
    <td><b>$ho</td>

</table>
</table>
<b>
EOF

  if (!$deny) {
     $o .= "<input type=submit name=ACTION_update value=\"$G->{submit_update}\">&nbsp;
           <input type=submit name=ACTION_delete value=\"$G->{submit_delete}\">&nbsp;";
  }
  $o .= " <input type=submit name=ACTION_back value=\"$G->{submit_back}\"></form>";
  print $o;
}

#sub slave_identify {
#  my($q) = @_;
#
#  my($sesdev) = $q->{name};
#
##  print "got to slave_identify: sesdev = $sesdev<br>";
#
#  $q->{GET} = "device";
#
#  &identify($q);
#}
#
#
#sub identify {
#  my($q) = @_;
#
#  my($sesdev) = $q->{name};
#
##   print "Local: GET=$q->{GET}, host = $q->{host} <br>";
#
#   # Check if remote request via getDevices.
#   if ($q->{host} ne "") {
#      my($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
#
#      my($data, $d2, $file, $h, $url, $hbano);
#      my($TO) = 20;
#      foreach $h (@$host) {
##          print "hostname = $h->{hostname}<br>";
#          if ($h->{hostname} eq $q->{host}) {
#         print "  - Identify querying host $h->{hostname} ...<br>";
#         $url = Util->makeUrl($h->{ip}, "?GET=device&type=d2&ACTION=identify&name=$sesdev");
##         print "url = $url<br>";
#         if ( ($data = Util::Http->get($url, $TO)) ) {
#            if (substr($data,0,3) eq "ERR") {
#               print "  $data<br>";
#               next;
#            } else {
#               $data = substr($data,3);
#            }
#            print "  $data<br>";
#         }
#         return;
#          }
#      }
#      return;
#   }
#
#   #
#   # http being set indicates this is a remote host
#   #
#   my($hostname) = System->hostname();
#   my($http) = "";
#   if ($q->{GET} =~ /device/) { 
#      $http = "http://$hostname:7654";
##      print "REMOTE SETUP: http = $http<br>";
#   }
#
#   my($input) = "";
#   my($esm) = "";
#   my($boxid) = "";
#   my $command = System->get_home() . "/bin/identify -d -f /dev/es/$sesdev 2>&1";
##print "identify: command = $command <br>";
#   my($err,$com) = Util->run_command( $command, "identify.txt",20); # run the command, timeout after 20 secs.
#   if ($err) {
#      print "identify: err = $err <br>";
#      return;
#   }
#   my($cnt) = 0;
#   foreach my $l (@$com) { # $com is a pointer to an array, thus @$ is needed.
#      my($devname) = "";
#      my($showname) = "None";
##print "$l <br>";
#      if ($l =~ /ESM:/) {
#         $esm = $l;
#         $esm =~ s/^.*ESM: //;
#         $esm = substr($esm, 0, 1);
#         $boxid = $l;
#         $boxid =~ s/^.*Unit ID: //;
#         $boxid = substr($boxid, 0, 1);
#      }
#      if ($l !~ /rive/) {
#         next;
#      }
#      $cnt++;
#      if ($l =~ /after/) {
#         $l =~ s/ after.*/./;
#      }
#      if ($l =~ /Drive Ready for Removal./) {
#         $l =~ s/Ready for Removal.*/inserted./;
#      }
#      if ($l =~ /c/) {
#         $devname = $l;
#         $devname =~ s/^.*c/c/;
#         $devname =~ s/s2.*$/s2/;
#         $showname = $devname;
#         $showname =~ s/s2.*$//;
#      }
#      my($slot, $rest) = split(/   /, $l, 2); # separate TAB
#      my($id, $rest) = split(/   /, $rest, 2); # separate TAB
#
#      my($status) = $l;
#      $status =~ s/.*0x..........//;
##print "$status <br>";
#
#      my($href_pre) = "<center><td nowrap>&nbsp;<a href=$http$Http::WEBPROC?GO=GUIAdmin::D2::drive_identify&sesdev=$sesdev&slot=$slot&devname=$devname&http=$http>";
#      my($no_href_pre) = "<center><td nowrap>&nbsp;";
#      my($href_post) = "</a></center>";
#      my($no_href_post) = "</center>";
#      if ($l =~ /Drive inserted./) {
#         $input .= "<tr>$href_pre<b>$slot</b>$href_post $href_pre<b>$id</b>$href_post $href_pre<b>$showname</b>$href_post <center><td nowrap>&nbsp;<b>$status</b>";
#      } else {
#         $input .= "<tr>$no_href_pre<b>$slot</b>$no_href_post $no_href_pre<b>$id</b>$no_href_post $no_href_pre<b>$showname</b>$no_href_post <center><td nowrap>&nbsp;<b>$status</b>";
#      }
#   }
#   $input .= "<tr><td colspan=4 ><bgcolor=red><b>&nbsp;<a href=$http$Http::WEBPROC?GO=GUIAdmin::D2::drive_leds_off&sesdev=$sesdev&cnt=$cnt&http=$http><b>Turn off all Drive Identify LEDs @ /dev/es/$sesdev (ESM: $esm, Unit: $boxid)</b> </td>";
#   if ($esm !~ 0 && $esm !~ 1) {
#      print "<font size=+2 color=navy><center><b>D2 Identify<br>";
#      print "<font size=+2 color=red><center><b>Cannot connect to: /dev/es/$sesdev<br>";
#      return;
#   }
#
#
#  print "\n\n";
#
#  my($sespath) = "/dev/es/$sesdev";
#  my($sn) = D2Agent::get_esm_sn($sespath);
#  if ($sn eq "") {
#   $sn = 0;
#  }
##print "SN: $sn for /dev/es/$sesdev<br>";
#
#  my($o) =<<EOF;
#
#<body bgcolor=$Style::BGCOLOR>
#<form method=get>
# <input type=hidden name=GO value=GUI::Devices::list>
#<center>
#
#<table border=0 cellspacing=0 cellpadding=2 width=90%>
#  
# <tr>
#   <td>
#   <font size=+2 color=navy><b>Identify<br><br>
#   <font color=navy>Host: <font color=red>$hostname &nbsp;&nbsp;&nbsp;&nbsp<font color=navy>D2 ESM Device: <font color=red>/dev/es/$sesdev<br>
#   <font color=navy>D2 ESM SN: <font color=red>$sn &nbsp;&nbsp;&nbsp;&nbsp
#   <font color=navy>ESM: <font color=red>$esm &nbsp;&nbsp;&nbsp;&nbsp<font color=navy>Unit ID: <font color=red>$boxid</b>
#
#<hr noshade size="1">
#   <font color=navy><br><br>Drive Identify<br>
#   </td>
#
#   
#   <td align=right>
#   
#</table>
#<table border=1 width=90% cellpadding=4 cellspacing=0 bgcolor=white>
# <tr><td>
#To blink the amber
#Identify LED on a drive slot, click on the <b>Slot, ID,</b> or <b>Device Name</b> link below.
# <p>
# <li>The 'Slot' column represents the D2 Slot #.
# <li>The 'ID' column represents the SCSI Target ID for that slot.
# <li>The 'Device Name' column represents the drive's Solaris device name.
# <li>The 'Status' column represents the drive insertion status.<br><br>
# <li><b>NOTE: </b>It is a good idea to turn off all identify LEDs before leaving this window.
# </table>
#
#
#<table border=1 cellspacing=1 width=90% bgcolor=white><tr><td>
#<tr><td colspan=4 bgcolor=$Style::DARK>
#<tr>
#    <td bgcolor=$Style::LIGHT><center><b>Slot</td>
#    <td bgcolor=$Style::LIGHT><center><b>ID</td>
#    <td bgcolor=$Style::LIGHT><center><b>Device Name</td>
#    <td bgcolor=$Style::LIGHT><center><b>Status</td>
#
#EOF
#
#print $o;
#
#
#  $o =<<EOF;
#
#
#     <tr><td><bgcolor=white><b>$input</b></table></table></table>
#
#   </td></b>
#
#</table>
#
#</form>
#<br>
#<br>
#EOF
#
#  print $o;
#
###################################################################################
#my($o) =<<EOF;
#
#
#<table border=0 cellspacing=0 cellpadding=2 width=90%>
#  
# <tr>
#   <td>
#<hr noshade size="1"><br><br>
#   <font size=+2 color=navy>D2 Identify
#   </td>
#
#   
#   <td align=right>
#   
#</table>
#
#<table border=1 width=90% cellpadding=1 cellspacing=0 bgcolor=white>
# <tr><td>
#To blink the amber
#Subsystem LED on a D2, click on the <b>Identify D2</b> link below.
# <p>
# <li><b>NOTE: </b>If the D2 Subsystem LED is set solid amber, this is an indication of a fault
#in the D2 and clicking the <b>Identify D2</b> link below will not override it.
#The <b>Monitor -> Instrumentation</b> page should be checked to determine the cause of the fault.<br><br>
# <li><b>NOTE: </b>In split-bus mode (6 slots per ESM), both ESMs in the D2 can blink the same D2 Subsystem LED,
#but only the ESM that turned on the D2 Subsystem LED can turn it off.<br><br>
# <li><b>NOTE: </b>It is a good idea to turn off all identify LEDs before leaving this window.
# </table>
#
#
#<table border=1 cellspacing=1 width=90% bgcolor=white>
#
#EOF
#
#print $o;
#
#   $input = "<tr><td colspan=4 ><bgcolor=red><br><center><b>&nbsp;<a href=$http$Http::WEBPROC?GO=GUIAdmin::D2::global_warning_led_on&sesdev=$sesdev&cnt=$cnt&http=$http><b>Identify D2 @ /dev/es/$sesdev (ESM: $esm, Unit: $boxid) via Subsystem LED</b></center><br> </td>";
#   $input .= "<tr><td colspan=4 ><bgcolor=red><b>&nbsp;<a href=$http$Http::WEBPROC?GO=GUIAdmin::D2::global_warning_led_off&sesdev=$sesdev&cnt=$cnt&http=$http><center><b>Turn off Subsystem LED @ /dev/es/$sesdev (ESM: $esm, Unit: $boxid)</b></center> <br></td>";
#   $input .= "<tr><td colspan=4 ><bgcolor=red><b>&nbsp;<a href=$http$Http::WEBPROC?GO=GUIAdmin::D2::turn_off_all_leds&sesdev=$sesdev&cnt=$cnt&http=$http><center><b>Turn off all Identify LEDs (Subsystem and Drive) @ /dev/es/$sesdev</b></center> <br></td>";
#
#  $o =<<EOF;
#
#
#     <tr><bgcolor=white><b>$input</b></table></table></table>
#
#   </b>
#
#</table>
#
#</form>
#<br>
#<br>
#EOF
#
#  print $o;
#
###################################################################################
#
#  my($action) = "";
#  if ($http ne "") {
#   my($master) = Util->findMaster;
##   $action = "ACTION=http://$master:7654/";
##       print "action = $action<br>";
## FIXME - for now just return to avoid re-login to master
#   if ($master) {
#      print "<hr noshade size=1>";
#      return;
#   }
#  }
#
#  my($o) =<<EOF;
#<body bgcolor=$Style::BGCOLOR>
#<form $action  method=get>
#<form  method=get>
# <input type=hidden name=GO value=GUIAdmin::D2::updDevice>
# <input type=hidden name=no value=1>
#<center>
#
#
#
#<input type=submit name=ACTION value="Back">
#</form>
#</form>
#</form>
#
#EOF
#
#print $o;
#
#  print "<hr noshade size=1>";
#
#}
#
#sub drive_identify {
#  my($q) =  @_;
#
#  print "<body bgcolor=$Style::BGCOLOR><font size=+2 color=navy><b>Turn on D2 Drive Identify LED: Slot $q->{slot}, /dev/es/$q->{sesdev}</font><br><br>";
#
#  if (Util->findMaster) {
#   print "http = $q->{http}<br><br>";
#  }
#
##  print "got to drive_identify <br>";
#
#  if ($q->{sesdev} eq "") {
#   print "drive_identify: no device name <br>";
#   return;
#  }
#
##  my $command = System->get_home() . "/bin/identify -i -f /dev/rdsk/$q->{devname} 2>&1";
#  my $command = System->get_home() . "/bin/identify -i -s $q->{slot} -f /dev/es/$q->{sesdev} 2>&1";
##print "drive_identify: command = $command <br>";
#  my($err,$com) = Util->run_command( $command, "identify.txt",20); # run the command, timeout after 20 secs.
#  if ($err) {
#     print "drive_identify: err = $err <br>";
#     return;
#  }
#  print "&nbsp;&nbsp;&nbsp;&nbsp;Slot $q->{slot}: Drive Identify LED on. <br>";
#
#  my($dest) = "identify";
#  if ($q->{http} ne "") {
#        $dest = "slave_identify";
#  }
#
#  my($o) =<<EOF;
#<body bgcolor=$Style::BGCOLOR>
#<form  method=get>
#<form  method=get>
# <input type=hidden name=GO value=GUIAdmin::D2::$dest>
# <input type=hidden name=name value=$q->{sesdev}>
#<center>
#
#
#
#<input type=submit name=ACTION value="Back">
#</form>
#
#EOF
#
#print $o;
#
#}
#
#sub drive_leds_off {
#  my($q) =  @_;
#
#  print "<body bgcolor=$Style::BGCOLOR><font size=+2 color=navy><b>Turn off D2 Drive Identify LEDs: /dev/es/$q->{sesdev}</font><br><br>";
#
#  if (Util->findMaster) {
#   print "http = $q->{http}<br><br>";
#  }
#
#
##  print "got to drive_leds_off <br>";
#
#  if ($q->{sesdev} eq "") {
#   print "drive_leds_off: no device name <br>";
#   return;
#  }
#
#  for (my($i) = 0; $i < $q->{cnt}; $i++) {
#   my $command = System->get_home() . "/bin/identify -l 4 -s $i -f /dev/es/$q->{sesdev} 2>&1";
##print "drive_leds_off: command = $command <br>";
#   my($err,$com) = Util->run_command( $command, "identify.txt",20); # run the command, timeout after 20 secs.
#   if ($err) {
#      print "drive_leds_off: err = $err <br>";
#      return;
#   }
#   print "&nbsp;&nbsp;&nbsp;&nbsp;Slot $i: Drive Identify LED off. <br>";
#  }
#
#  my($dest) = "identify";
#  if ($q->{http} ne "") {
#        $dest = "slave_identify";
#  }
#
#  my($o) =<<EOF;
#<body bgcolor=$Style::BGCOLOR>
#<form  method=get>
#<form  method=get>
# <input type=hidden name=GO value=GUIAdmin::D2::$dest>
# <input type=hidden name=name value=$q->{sesdev}>
#<center>
#
#
#
#<input type=submit name=ACTION value="Back">
#</form>
#
#EOF
#
#print $o;
#}
#
#sub global_warning_led_on {
#  my($q) =  @_;
#
#  print "<body bgcolor=$Style::BGCOLOR><font size=+2 color=navy><b>Turn on D2 Subsystem LED: /dev/es/$q->{sesdev}</font><br><br>";
#
#  if (Util->findMaster) {
#   print "http = $q->{http}<br>";
#   print "sesdev = $q->{sesdev}<br><br>";
#  }
#
##  print "got to global_warning_led_on <br>";
#
#  if ($q->{sesdev} eq "") {
#   print "global_warning_led_on: no device name <br>";
#   return;
#  }
#
#  my $command = System->get_home() . "/bin/identify -l 3 -s 0 -f /dev/es/$q->{sesdev} 2>&1";
## print "global_warning_led_on: command = $command <br>";
#  my($err,$com) = Util->run_command( $command, "identify.txt",20); # run the command, timeout after 20 secs.
#  if ($err) {
#     print "global_warning_led_on: err = $err <br>";
#     return;
#  }
#  print "&nbsp;&nbsp;&nbsp;&nbsp; D2 Subsystem LED on. <br>";
#
#  my($dest) = "identify";
#  if ($q->{http} ne "") {
#        $dest = "slave_identify";
#  }
#
#  my($o) =<<EOF;
#<body bgcolor=$Style::BGCOLOR>
#<form  method=get>
#<form  method=get>
# <input type=hidden name=GO value=GUIAdmin::D2::$dest>
# <input type=hidden name=name value=$q->{sesdev}>
#<center>
#
#
#
#<input type=submit name=ACTION value="Back">
#</form>
#
#EOF
#
#print $o;
#
#}
#
#sub global_warning_led_off {
#  my($q) =  @_;
#
#  print "<body bgcolor=$Style::BGCOLOR><font size=+2 color=navy><b>Turn off D2 Subsystem LED: /dev/es/$q->{sesdev}</font><br><br>";
#
#  if (Util->findMaster) {
#   print "http = $q->{http}<br><br>";
#  }
#
##  print "got to global_warning_led_off <br>";
#
#  if ($q->{sesdev} eq "") {
#   print "global_warning_led_off: no device name <br>";
#   return;
#  }
#
#  my $command = System->get_home() . "/bin/identify -l 5 -s 0 -f /dev/es/$q->{sesdev} 2>&1";
## print "global_warning_led_off: command = $command <br>";
#  my($err,$com) = Util->run_command( $command, "identify.txt",20); # run the command, timeout after 20 secs.
#  if ($err) {
#     print "global_warning_led_off: err = $err <br>";
#     return;
#  }
#  print "&nbsp;&nbsp;&nbsp;&nbsp; D2 Subsystem LED off. <br>";
#
#  if ($q->{cnt} eq "0") {
#   return;
#  }
#
#  my($dest) = "identify";
#  if ($q->{http} ne "") {
#        $dest = "slave_identify";
#  }
#
#  my($o) =<<EOF;
#<body bgcolor=$Style::BGCOLOR>
#<form  method=get>
#<form  method=get>
# <input type=hidden name=GO value=GUIAdmin::D2::$dest>
# <input type=hidden name=name value=$q->{sesdev}>
#<center>
#
#
#
#<input type=submit name=ACTION value="Back">
#</form>
#
#EOF
#
#print $o;
#
#}
#
#sub turn_off_all_leds {
#  my($q) =  @_;
#
#  print "<hr noshade size=1>";
#  &drive_leds_off($q);
#  print "<hr noshade size=1>";
#  $q->{cnt} = 0;
#  &global_warning_led_off($q);
#  print "<hr noshade size=1>";
#}
#
#
#
1;
