package GUI::Start;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Id: Start.pm,v 1.35 2003/05/13 23:06:26 ccadieux Exp $

use Util;
use Util::Http;
use GUI::Hosts;
use System;
use Events;

sub Devices {

  my($q) = @_;
  my(@a, @b, %S);
  if ( Util->findMaster()) {
    print "\n<body bgcolor=white><h1><center>This function is not allowed on a slave!";
    return;
  }
  my $G = Labels->read();
  my $L = Labels->read('GUI::Start')->section('device');


  my $deny = Roles->verifyRole($q, "admin");

  print "\n";
  
  

  if ($q->{ACTION_submit}) {
     ($renv, $devs, $host,$notifs) = PDM::ConfigFile->read;
     my($hostlist);
     foreach $x (keys %$q) {
        $no = 0;
        if (substr($x,0,6) eq "start_") {
          $no = substr($x,6) ; $active = "Y";
        } elsif (substr($x,0,5) eq "stop_") {
          $no = substr($x,5); $active = "N";
        }
        next if (!$no);
        $no--;
        $dev = $devs->[$no];
        print "$L->{l1} $dev->{name} ...<br>";
        if ($active eq "Y") {
           Events->saveEvent("QE", $dev->{type}, $dev->{key}); # QuieceEnd
           delete $dev->{skip};
        } elsif ($active eq "N") {
           Events->saveEvent("QS", $dev->{type}, $dev->{key}); # QuiescStart
        }
        $dev->{active} = $active;
        if ($dev->{host}) {
           if (index(",$hostlist,", ",$dev->{host},") < 0) {
              $hostlist .= "$dev->{host}," ;
           }
        }
     }
     PDM::ConfigFile->write( $renv, $devs, $host,$notifs);
     if ($hostlist) {
        GUI::Hosts::push_slaves($q, $hostlist);
     }
  }

  ($renv, $devs, $host,$notifs) = PDM::ConfigFile->read;
  my($CAT);
  my %Agent;
  $Agent{""} = 1 if (-f System->get_home() . "/DATA/start");
  foreach my $h (@$host) {
     $CAT->{$h->{hostname}} = $h->{categories};
     $Agent{$h->{hostname}} = 1 if ($h->{active} eq "Y");
  }
  $h1 = Html->header2("admin.gen_maint.start_device");

  $o =<<EOF;

<body bgcolor=$Style::BGCOLOR>
<form  method=get>
 <input type=hidden name=GO value=GUI::Start::Devices>
 <input type=hidden name=HOST value=\"$q->{HOST}\">
<center>
$h1

<table border=1 cellspacing=0 cellpadding=2 width=90% bgcolor=white>
<tr><td colspan=7 bgcolor=$Style::DARK><b><font color=white>&nbsp;$L->{label1}</td>
<tr bgcolor=$Style::LIGHT>
   <th>$L->{host}</th>
   <th>$L->{name}</th>
   <th>$L->{type}</th>
   <th>$L->{add}</th>
   <th>$L->{mon}</th>
   <th>$L->{start}</th>
   <th>$L->{stop}</th>
EOF
  my(%DEV);
  foreach $dev (@$devs) {
     $DEV{"$dev->{host}:$dev->{name}:$dev->{key}"} = $dev;
  }
  my $lasth;
  foreach $dev0 (sort keys %DEV) {
    $dev = $DEV{$dev0};
    next if ($dev->{type} eq $renv->{solution});
    $type = uc($dev->{type});
    if ($dev->{ipno}) {
      $ip = ($dev->{name} eq $dev->{ip})? $dev->{ipno}:$dev->{ip};
    } else {
      $ip = $dev->{wwn};
    }
    $loc0 = $loc = $dev->{host} || $renv->{hostname};
    my $ii = index($loc, ".");
    $loc = substr($loc,0,$ii) if ($ii > 0);
    if ($loc ne $lasth) {
        $lasth = $loc;
        $o .= "<tr><td colspan=7>&nbsp;<b><a href=$Http::WEBPROC?GO=GUI::Start::Devices&HOST=$loc0>+ $loc0</a></td>";
    }
    next if ($loc0 ne $q->{HOST});

    $col = "";
    $start = $stop= "";
    $no = substr($dev->{_name},6);
    if ($dev->{active} eq "Y"){
       $active = "$L->{On}";
      $stop = "<input type=checkbox name=stop_$no>";
    }else{
       $active = "<font color=#FF0000>$L->{Off}</font>";
       $start = "<input type=checkbox name=start_$no>";
    }
    
    if($dev->{host}){
       $categories = $CAT->{$dev->{host}};
     }else{
       $categories = $renv->{categories};
     }
     $categories .= "|$renv->{solution}|";
     my $hactive;
     if (index("|$categories|", "|$dev->{type}|") < 0){
        $active .= " <font color=#FF0000>$L->{Off}</font>";
     }else{
        $active .= " $L->{On}";
     }
    $active .= $Agent{$dev->{host}} ? " $L->{On}" : " <font color=#FF0000>$L->{Off}";

    #$start = $stop= "";
    #$no = substr($dev->{_name},6);
    #if ($active eq "On") {
    #  $col = "bgcolor=#C0FFC0";
    #  $stop = "<input type=checkbox name=stop_$no>";
    #} else {
    #  $col = "bgcolor=#FFC0C0";
    #  $start = "<input type=checkbox name=start_$no>";
    #}
    
    $o .= "<tr>
   <td>&nbsp;$loc</td>
   <td>&nbsp;$dev->{name}</td>
   <td>&nbsp;$dev->{type}</td>
   <td>&nbsp;$ip</td>
   <td $col><center><b>$active</td>
   <td><center>$start&nbsp;</td>
   <td><center>$stop&nbsp;</td>
    ";
  }
  $o .= "</table><b>";
  if (!$deny) {
    $o .= "<input type=submit name=ACTION_submit value=\"$L->{submit1}\">";
  }
  $o .= "</form>";
  print $o;
}

sub Agents {
  my($q, $post, $util) = @_;

  print Html->body();
  my $G = Labels->read();
  my $L = Labels->read('GUI::Start')->section('agent');

 if ( Util->findMaster()) {
    print "<body bgcolor=white><h1><center>$G->{e_101}";
    return;
  }

  my $deny = Roles->verifyRole($q, "admin");

  $head = Html->header2("admin.gen_maint.start_agent");

  if ($q->{ACTION_update}) {
    ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;
    for ($x=0; $x <= $#$host; $x++) {
       $start = "";
       $h = $host->[$x];
       $h->{last_push} = "";
       if ($q->{"start_$h->{hostname}"}) {
             $start = "Y";
       } elsif ($q->{"stop_$h->{hostname}"}) {
             $start = "N";
       }
       if ($start) {
         my $ipno = $h->{ipno} || $h->{ip};
         print "Updating $ipno ...<br>\n";
         if ($start eq "Y") {
           $rc = Util::Http->getCommand($ipno, "CREAT&file=start", 30);
         } else {
           $rc = Util::Http->getCommand($ipno, "DELET&file=start", 30);
         }

         print "<b>$L->{err_1}: $url</b>" if ($rc !~ /Y/);
         $h->{active} = $start;
       }
    }
    if ($q->{start_LOCAL}) {
      open(O, ">" . System->get_home() ."/DATA/start");
      print O "Y";
      close(O);
    } elsif ($q->{stop_LOCAL}) {
      unlink System->get_home() ."/DATA/start";
    }
    PDM::ConfigFile->write( $renv, $dev, $host, $notifs);
  }


  $hname = System->hostname;
  $hid = System->hostid;
  $ip  = System->local_ip;
  my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read;

  $o =<<EOF;

<body bgcolor=$Style::BGCOLOR>
<center>
$head
<table border=1 cellspacing=0 cellpadding=2 width=90% bgcolor=white>
<tr><td colspan=7 bgcolor=$Style::DARK>
  <form  method=get><input type=hidden name=GO value=GUI::Start::Agents>
  <b><font color=white>&nbsp;$L->{label1}</td>
<tr>
    <td bgcolor=$Style::LIGHT><center><b>$L->{name}</td>
    <td bgcolor=$Style::LIGHT><center><b>$L->{type}</td>
    <td bgcolor=$Style::LIGHT><center><b>$L->{host}</td>
    <td bgcolor=$Style::LIGHT><center><b>$L->{ip}</td>
    <td bgcolor=$Style::LIGHT><center><b>$L->{mon}</td>
    <td bgcolor=$Style::LIGHT><center><b>$L->{start}</td>
    <td bgcolor=$Style::LIGHT><center><b>$L->{stop}</td>
<tr>
EOF
  $local = (-f System->get_home() . "/DATA/start")? "Yes":"No";
  $col = ($local =~ /Yes/)? "#C0FFC0" : "#FFC0C0";
  $start = $stop = "";
  if ($local =~ /Yes/) {
      $local0 = "On";
      $stop = "<input type=checkbox name=stop_LOCAL>";
  } else {
      $local0 = "Off";
      $start = "<input type=checkbox name=start_LOCAL>";
  }
  $o .= "<tr><td>&nbsp;$hname</td>
          <td>$G->{master}</td>
          <td>$hid</td>
          <td>$ip</td>
          <td bgcolor=$col><b><center>$L->{$local0}</td>
          <td><center>$start</td>
          <td><center>$stop</td>
          ";


  for ($x=0; $x <= $#$hosts; $x++) {
     $h = $hosts->[$x];
#     $url     =  Util->makeUrl($h->{ip}, "?GET=start");
     $start0 = $stop = "";

     if ($h->{dh} ne "Y") {
       print "$G->{calling} $h->{ipno}...<br>\n";
       $start = Util::Http->getCommand($h->{ipno}||$h->{ip}, 
                   "EXIST&file=start", 10) || "ERR: $Util::Http::ERROR";

       print $start. "<br>" if ($start =~ /ERR:/);
       $type = "Slave";
       $col = ($start =~ /Y/)? "#C0FFC0" : "#FFC0C0";
       if ($start =~ /Y/) {
         $stop = "<input type=checkbox name=stop_$h->{hostname} >";
         $mon = "On";
         $h->{active} = "Y";
       } else {
         $start0 = "<input type=checkbox name=start_$h->{hostname} >";
         $mon = "Off";
         $h->{active} = "N";
       }
     } else {
       $type = "DataHost";
       $col = "white";
       $mon = "datahost";
       $start0 = $stop = "&nbsp;";
     }
     $o .= "<tr><td>&nbsp;$h->{hostname}</td>
          <td>$type</td>
          <td>$h->{hostid}</td>
          <td>$h->{ipno}</td>
          <td bgcolor=$col><b><center>$L->{$mon}</td>
          <td><center>$start0</td>
          <td><center>$stop</td>
          ";
  }
  PDM::ConfigFile->write( $renv, $devs, $hosts, $notifs);
  
  $o .= "</table><br>";
  if (!$deny) {
    $o .= "<b><input type=submit name=ACTION_update value=\"$L->{submit1}\">&nbsp; ";
  }
  $o .= "<submit>";
  print $o;

}


1;
 
