package GUI::Options;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use PDM::ConfigFile;
use GUI::Hosts;
use strict;
use Html;

#  $Id: Options.pm,v 1.79 2003/05/20 16:57:19 ccadieux Exp $

sub upd {
  my($q, $post) = @_;
  my($renv, $dev, $host, $notifs, $c1, $c2);
  my($err1, $info, $err2, $err3, $err5, $err6, $err8);
  my($error);
  my $deny = Roles->verifyRole($q, "admin");
  my $G = Labels->read();
  my $L = Labels->read("GUI::Options");
  my $ruser = System->get_ruser();

  if ( Util->findMaster()) {
    print "\n<body bgcolor=white><h1><center>$G->{e_101}";
    return;
  }
  print Html->body();
  print "<a name=top>";
  $info = "";
  my($warn2, $warn3, $cat, $last_win);
  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read();

  if ($q->{ACTION_submit} ) {
    while (1) {
       my $mailer = $q->{mailer};
       my $ix = index($mailer, " ");
       $mailer = substr($mailer,0,$ix) if ($ix > 0);
       if ($mailer && !-x $mailer) {
         $err2 = Html->warning($G->expand('cannot_ex', $q->{mailer}));
       }
       $renv->{gui_bandwidth}       = $q->{band} || "L";
       $renv->{mailer}              = $q->{mailer};
       $renv->{email_from}          = $q->{email_from};
       $renv->{sendmail_server}     = $q->{sendmail_server};
       #$renv->{email_per_event}     = $q->{one} ? 1:0;
       $renv->{max_daily_email}     = $q->{max_daily_email};
       $renv->{use_hub}             = $q->{use_hub} ? 1:0;
       $renv->{production}          = $q->{production};
       $renv->{session_timeout}     = $q->{session} * 60;
       #$renv->{show_unk_wwn}        = $q->{show_unk_wwn} ? 1:0;
       $renv->{topo_history_size}   = $q->{topo} || 5;
       $renv->{max_event_file_size} = $q->{max_event_file_size};
       my $hh = System->get_home() . "/htdocs";
       #my $cmd = "/bin/cp $hh/graph$renv->{window}.html $hh/graph.html";
       #print "$cmd<br>";
       #system($cmd);
       $q->{test_refresh}           = 5 if ($q->{test_refresh} < 5);
       $renv->{'test.refresh_rate'} = ($q->{test_refresh} + 0) ;
  
       if (!PDM::ConfigFile->write( $renv, $dev, $host,$notifs)) {
          print "$G->{e_100} <br>";
       } else {
          System->set_renv($renv);
          $info = Html->info($L->{l1});
       }
       last;
    }

  } elsif ($q->{ACTION_submit2} ) {
    while (1) {
      $last_win = $renv->{window};
      $renv->{window}              = $q->{window};
      $renv->{accessible}          = "N";
      $renv->{color_scheme}        = $q->{color_scheme};
      Style->init($renv);
      if ($renv->{window} eq "A") {
        $renv->{window}     = "N";
        $renv->{accessible} = "Y";
      }
      if (!PDM::ConfigFile->write( $renv, $dev, $host,$notifs)) {
          print "$G->{e_100} <br>";
      } else {
          System->set_renv($renv);
          $info = Html->info($L->{l1});
      }
      last;
    }
    print "<meta http-equiv=Refresh target=_top content=\"0;URL=/\">";
    return;

  }

  my $extra = "</b><a href=#window>Window Options</a> " if ($ruser->{userid} eq "ROOT");
  my $h = Html->header2("admin.gen_maint.options", undef,  $extra);
  $renv->{topo_history_size} = 5 if (!$renv->{topo_history_size});

  my $showoob = "<input type=checkbox name=showoob " . 
                ($renv->{showoob} eq "Y"?"checked":"") .  ">";
  #my $ck5 = $renv->{email_per_event} ? "checked" : "";
  my $refresh = $renv->{'test.refresh_rate'} || 30;
  my $maxevents = $renv->{'max_event_file_size'} || 2;
  my $band = Util->makeSelect("band", "L=$L->{b_low}|H=$L->{b_high}", $renv->{gui_bandwidth});

  my $w = $renv->{window};
  $w = "A" if ($renv->{accessible} eq "Y");

  my $ssize = Html->makeSelect("window", "B=$L->{w_b}|S=$L->{w_s}|N=$L->{w_n}|A=$L->{w_a}",$w);
  my ($button1, $button2);
  if (!$deny) {
    $button1  = " <input type=submit name=ACTION_submit value=\" $L->{submit_options} \">" ;
    $button2  = " <input type=submit name=ACTION_submit2 value=\" $L->{submit_window} \">" ;
  }
  my $hub     = "checked" if ($renv->{use_hub});
  my $prod    = Html->makeSelect("production", "0=$L->{prod0}|1=$L->{prod1}", $renv->{production});
  my $max     = Html->makeSelect("max_daily_email", "8|6|4|2", $renv->{max_daily_email});
  my $scheme  = Html->makeSelect("color_scheme", $L->{scheme1}, $renv->{color_scheme});
  my $session =  Html->makeSelect("session", "0=$L->{never}|30=30 $L->{mins}|60=60 $L->{mins}|1440=1 $L->{day}", $renv->{session_timeout}/60);

  #my $ck10 = $renv->{show_unk_wwn} ? "checked" : "";
  my $prod_info = $renv->{production} ? $G->{yes} : $G->{no};

  my $o =<<EOF;
<body bgcolor=$Style::BGCOLOR>
<form method=post>
 <input type=hidden name=GO value=GUI::Options::upd>
<center>
$h
$info
$error
$err2
<table border=1 cellspacing=0 cellpadding=1 width=90% bgcolor=white>
<tr><td colspan=4 bgcolor=$Style::DARK><b><font color=white>&nbsp;$L->{label}</td>
<tr><td bgcolor=$Style::LIGHT width=40% align=right>$L->{old_topo_cnt}:</td>
    <td>&nbsp;<input type=text size=3 name=topo value=\"$renv->{topo_history_size}\"></td>

<tr><td align=right bgcolor=$Style::LIGHT width=40%> $L->{refresh}: </td>
    <td>&nbsp;<input type=text name=test_refresh size=4 value=$refresh> $L->{min}</td>

<tr><td align=right bgcolor=$Style::LIGHT width=40%> $L->{max_events}: </td>
    <td>&nbsp;<input type=text name=max_event_file_size size=4 value=$maxevents> (Meg)</td>


<tr><td align=right bgcolor=$Style::LIGHT width=40%> $L->{bandwidth}: </td>
    <td>$band </td>

<tr><td align=right bgcolor=$Style::LIGHT width=40%> $L->{use_hub}: </td>
    <td><input type=checkbox name=use_hub $hub>

<tr><td align=right bgcolor=$Style::LIGHT width=40%> $L->{production}: </td>
    <td> $prod</td>

<tr><td align=right bgcolor=$Style::LIGHT width=40%> $L->{timeout}: </td>
    <td> $session </td>


<tr><td colspan=2 bgcolor=$Style::DARK><b><font color=white>&nbsp;$L->{email}</td>

<tr><td align=right bgcolor=$Style::LIGHT width=40%>$L->{sendmail}: </td>
    <td>&nbsp;<input type=text name=sendmail_server size=30 value=\"$renv->{sendmail_server}\">  $L->{optional}

<tr><td align=right bgcolor=$Style::LIGHT width=40%> $L->{email_from}: </td>
    <td>&nbsp;<input type=text name=email_from size=30 value=\"$renv->{email_from}\"> $L->{optional}

<tr><td align=right bgcolor=$Style::LIGHT width=40%> $L->{max_daily_email}: </td>
    <td>&nbsp;$max $L->{max}


<tr><td align=right bgcolor=$Style::LIGHT width=40%> $L->{email_path}: </td>
    <td>&nbsp;<input type=text name=mailer size=30 value=\"$renv->{mailer}\"> 
</table>
<table border=0 width=90%>
  <td><center><b>$button1</form></td>
</table>
EOF

    if ($ruser->{userid} eq "ROOT") {
      $o .=<<EOF;
<a name=window>
<table border=0 cellpadding=8><tr><td></table>
<table border=0 cellspacing=0 width=90%>
 <tr><td><b>Window Options :</b> <a href=#top>Config Options</a></td>
</table>
<table border=1 cellspacing=0 cellpadding=1 width=90% bgcolor=white>
<tr><td colspan=4 bgcolor=$Style::DARK>
   <form method=post target=_top>
   <b><font color=white>&nbsp;$L->{submit_window}</td>
<tr><td colspan=4>$L->{window_info}
<tr><td align=right bgcolor=$Style::LIGHT width=40%> $L->{window}: </td>
    <td>&nbsp;$ssize
<tr><td align=right bgcolor=$Style::LIGHT width=40%> $L->{scheme}: </td>
    <td>&nbsp;$scheme
</table>
<b><table border=0><tr><td></table>
  $button2
</form>
EOF
  }
  print $o;
  print "&nbsp;<p>" x 2;
}

#<tr><td align=right bgcolor=$Style::LIGHT width=40%> $L->{show_unk_wwn}: </td>
#    <td>&nbsp;<input type=checkbox name=show_unk_wwn $ck10>
#<tr><td align=right bgcolor=$Style::LIGHT width=40%> $L->{scheme}: </td>
#    <td>&nbsp;$scheme

1;
 
