package GUI::Filters;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------

#</copyright>

use Html;
#  $Id: Filters.pm,v 1.5 2003/04/09 22:36:04 ccadieux Exp $

use Labels;
use Agent;
use  Html::Tabs;
use strict;
use Filters;
use GUI::Notifs;

sub get_DAYS {
  my $G = Labels->read();
  return 
        "0a=$G->{sun} 5am - 5pm|0p=$G->{sun} 5pm - 5am|".
        "1a=$G->{mon} 5am - 5pm|1p=$G->{mon} 5pm - 5am|".
        "2a=$G->{tue} 5am - 5pm|2p=$G->{tue} 5pm - 5am|".
        "3a=$G->{wed} 5am - 5pm|3p=$G->{wed} 5pm - 5am|".
        "4a=$G->{thu} 5am - 5pm|4p=$G->{thu} 5pm - 5am|".
        "5a=$G->{fri} 5am - 5pm|5p=$G->{fri} 5pm - 5am|".
        "6a=$G->{sat} 5am - 5pm|6p=$G->{sat} 5pm - 5am|";
}


sub list {
  my($q) = @_;
  my($ho, $o, $err);

  my $deny = Roles->verifyRole($q, "admin");
  my $G = Labels->read();
  my $L = Labels->read('GUI::Filters');
  my($renv, $dev, $host, $notifs) = PDM::ConfigFile->read;
  if ($q->{ACTION_add}) {
     &add($q);
     return;
  }
  if ($q->{ACTION_del}) {
     my $filters = Filters->new();
     foreach my $x (keys %$q) {
        if (substr($x,0,4) eq "del_") {
            my $ix = substr($x,4);
            $filters->[$ix] = undef;
        }
     }
     $filters->write();
  }

  my $filters = Filters->new();
  print Html->body();
  if ( Util->findMaster()) {
    print "\n<body bgcolor=white><h1><center>$G->{e_101}";
    return;
  }

  print Html->header2("admin.gen_maint.filters");

  my($x, $h, $lnk, $type, $device, $prio, $ho);

  print <<EOF;
<form  method=get>
 <input type=hidden name=GO value=GUI::Filters::list>
$q->{ERR}
<table border=2 cellspacing=1 width=90% bgcolor=white><tr><td>
<table border=0 cellspacing=2 width=100% bgcolor=#F0F0F0>
<tr><td colspan=7 bgcolor=$Style::DARK><b><font color=white>&nbsp;$L->{title}</td>
<tr>
    <td bgcolor=$Style::LIGHT><center><b>#</td>
    <td bgcolor=$Style::LIGHT><center><b>$L->{type}</td>
    <td bgcolor=$Style::LIGHT><center><b>$L->{code}</td>
    <td bgcolor=$Style::LIGHT><center><b>$L->{days}</td>
    <td bgcolor=$Style::LIGHT><center><b>$L->{pattern}</td>
    <td bgcolor=$Style::LIGHT><center><b>$L->{severity}</td>
    <td bgcolor=$Style::LIGHT><center><b>Del.</td>
EOF

  my $cnt;
  for ($x=0; $x <= $#$filters; $x++) {
    my $f = $filters->[$x];
    my $x2 = sprintf("%-5.5d", $x);
    $lnk  = "<a href=$Http::WEBPROC?GO=GUI::Filters::upd&ix=$x><b>0$x2</b></a>";
    $cnt++;
    my $del = "<input type=checkbox name=del_$x>";
    my $sev = $L->{"sev_$f->{severity}"};

    print "<tr><td>&nbsp;$lnk</td>
                <td><center>$f->{type}&nbsp;</td>
                <td>$f->{code}&nbsp;</td>
                <td>$f->{days}&nbsp;</td>
                <td>$f->{pattern}&nbsp;</td>
                <td><center>$sev</td>
                <td><center>$del</td>
          ";
  }
  if ($cnt == 0) {
     print "<tr><td colspan=5><b>$L->{none}</td>";
  }
  
  print "$o</table></table>";
  if (!$deny) {
    print "<table border=0 width=90%>
     <tr><td><b><input type=submit name=ACTION_add value=\"$L->{submit_add}\"></td>
     <td align=right><b>
          <input type=submit name=ACTION_del value=\"$L->{submit_del}\">
     </table>";
  }
  print "</form>";
}


sub upd {
  my($q) = @_;
  my($ho, $o);
  my($name,$renv, $dev, $hosts, $notifs);

  my $G = Labels->read();
  my $L = Labels->read('GUI::Filters');
  my $deny = Roles->verifyRole($q, "admin");
  my($err, $renv, $dev, $host, $notifs, $x, $h);
  my $filters = Filters->new();

  if ($q->{ACTION_upd}) {
    my $filter = $filters->[$q->{ix}];
    if ($filter) {
      $filter->{code}     = $q->{code};
      $filter->{type}     = $q->{type};
      $filter->{pattern}  = $q->{pattern};
      $filter->{days}     = $q->{days};
      $filter->{severity} = $q->{severity};
      $filters->write();
      $err = Html->info("Filter updated!");
    }
      
  } elsif ($q->{ACTION_back}) {
    $q->{option} = "";
    &list($q);
    return;
  }
  print Html->body();
  my $h = Html->header2("admin.gen_maint.filters", undef, "Update");

  ($renv, $dev, $hosts, $notifs) = PDM::ConfigFile->read();

  $h .= "<table border=0 width=90% cellpadding=3 bgcolor=white><tr><td>$L->{info}</table>";

  my $filter = $filters->[$q->{ix}];
  my($types, $days, $sevs);

  my $types = Html->makeSelect("type", GUI::Notifs::selectAgents() , $filter->{type},
                  {select => 1});

  my $days = Html->makeSelect("days",  &get_DAYS,$filter->{days}, {multiple => 4});

  my $sevs = Html->makeSelect("severity", 
          "1=$L->{dec_1}|2=$L->{dec_2}|0=$L->{dec_0}|9=$L->{dec_9}",
                    $filter->{severity});

  $o =<<EOF;

<body bgcolor=$Style::BGCOLOR>
<form  method=get>
 <input type=hidden name=GO value=GUI::Filters::upd>
<center>
$h
$err
<table border=2 cellspacing=2 width=90% bgcolor=white><tr><td>
<table border=0 cellspacing=2 width=100%>
<tr><td colspan=4 bgcolor=$Style::DARK><b><font color=white>&nbsp;$L->{title2} </td>
   <input type=hidden name=ix value=$q->{ix}>

<tr><td bgcolor=$Style::LIGHT align=right>$L->{days}:</td>
    <td colspan=3>$days ($L->{opt})</td>

<tr><td bgcolor=$Style::LIGHT align=right>$L->{type}:</td>
    <td colspan=3>$types </td>

<tr><td bgcolor=$Style::LIGHT align=right>$L->{code}:</td>
    <td colspan=3><input type=text name=code size=20 value=\"$filter->{code}\"> ($L->{opt})</td>


<tr><td bgcolor=$Style::LIGHT align=right>$L->{or} $L->{pattern}:</td>
    <td  colspan=3><input type=text size=60 name=pattern value=\"$filter->{pattern}\"> ($L->{opt})</td>


<tr><td bgcolor=$Style::LIGHT align=right>$L->{sev}:</td>
    <td colspan=3>$sevs


</table>
</table>
<b>
<input type=submit name=ACTION_upd value="$G->{submit_update}">
<input type=submit name=ACTION_back value="$G->{submit_back}">
</form>
EOF
   print $o;

}


sub add {
  my($q) = @_;
  my($ho, $o, $err);

  my $G = Labels->read();
  my($renv, $dev, $host, $notifs, $info);
  if ($q->{ACTION_add1}) {
     my $filters = Filters->new();
     $q->{code}    = Util->rtrim($q->{code});
     $q->{pattern} = Util->rtrim($q->{pattern});
     if (!$q->{code} && !$q->{pattern}) {
         print Html->error("Enter at least an EventCode or a Pattern!");
     } else {
       $filters->add($q->{code}, $q->{type}, $q->{days}, $q->{pattern}, $q->{severity});
       $filters->write();
       $err = Html->info("Filter added!");
     }
  }

  if ($q->{ACTION_back}) {
    $q->{option} = "";
    &list($q);
    return;
  }
  print Html->body();
  my $L = Labels->read('GUI::Filters');

  my $h = Html->header2("admin.gen_maint.filters", undef);

  my($types, $days, $sevs);
  my $types = Html->makeSelect("type", GUI::Notifs::selectAgents() , undef,
                  {select => 1});

  my $days = Html->makeSelect("days",  &get_DAYS, undef, {multiple => 4});

  my $sevs = Html->makeSelect("severity", 
                "1=$L->{dec_1}|2=$L->{dec_2}|0=$L->{dec_0}|9=$L->{dec_9}");

  $o =<<EOF;

<body bgcolor=$Style::BGCOLOR>
<form  method=get>
 <input type=hidden name=GO value=GUI::Filters::add>
<center>
$h
$err
<table border=2 cellspacing=2 width=90% bgcolor=white><tr><td>
<table border=0 cellspacing=2 width=100%>
<tr><td colspan=4 bgcolor=$Style::DARK><b><font color=white>&nbsp;$L->{title2} </td>

<tr><td bgcolor=$Style::LIGHT align=right>$L->{days}:</td>
    <td colspan=3>$days ($L->{opt})</td>

<tr><td bgcolor=$Style::LIGHT align=right>$L->{type}:</td>
    <td colspan=3>$types </td>

<tr><td bgcolor=$Style::LIGHT align=right>$L->{code}:</td>
    <td colspan=3><input type=text name=code size=20> ($L->{opt})</td>


<tr><td bgcolor=$Style::LIGHT align=right>$L->{or} $L->{pattern}:</td>
    <td  colspan=3><input type=text size=60 name=pattern> ($L->{opt})</td>


<tr><td bgcolor=$Style::LIGHT align=right>$L->{sev}:</td>
    <td colspan=3>$sevs


</table>
</table>
<b>
<input type=submit name=ACTION_add1 value="$G->{submit_add}">
<input type=submit name=ACTION_back value="$G->{submit_back}">
</form>
EOF

  print $o;

}

sub display_event_list {
  my($q, $filter) = @_;
  my($x, $ck, $out);

  foreach $x (sort keys %{Event->get_types} ) {
     if (substr($filter,0,1) eq "-") {
        next if (Event->get_category($x) eq substr($filter,1));
        $ck = ($q->{"event_$x"})? "checked":"";
        $out .= "<input type=checkbox name=event_$x $ck>: " .
             Event->get_description($x) . "<br>";

     } else {
       if (Event->get_category($x) eq $filter) {
         $ck = ($q->{"event_$x"})? "checked":"";
         $out .= "<input type=checkbox name=event_$x $ck>: " .
             Event->get_description($x) . "<br>";
       }
     }
  }
  return $out;
}


sub find_events {
  my $ruser = System->get_ruser();
  my $renv = System->get_renv();
  my($l);
  my $lang = $ruser->{language} || $renv->{language};

  my $F = System->get_home() ."/Lang/System/Labels/$lang/Events.lb";
  if (-f $F) {
    open(O, $F);
  } else {
    open(O, System->get_home() . "/System/Labels/Events.lb");
  }
  my($out); 
  while ($l = <O>) {
    chop($l);
    $l =~ s/\s*=\s*/=/;
    $out .= "$l|";
  }
  close(O);
  chop($out);
  return $out;
}




1;
