package GUI::Devices;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Id: Devices.pm,v 1.80 2003/05/13 23:06:26 ccadieux Exp $

use PDM;
use Launch;
use Report;
use Serialize;
use GUI::Config;
use GUI::Hosts;
use AdminGroup;
#
# List all devices, refer to GUIAdmin::<device>::addDevice and updDevice for 
# maintenance.

sub list {
 my($q) = @_;
 my($ho, $o, @devs);
 my $deny = Roles->verifyRole($q, "admin");
 my $G = Labels->read();
 my $L = Labels->read('GUI::Devices');
 my $ruser = System->get_ruser();
 print Html->body();
 
  if ( Util->findMaster()) {
    print "\n<body bgcolor=white><h1><center>$G->{e_101}";
    return;
  }
  my $groups = AdminGroup->new();
  $q->{GROUP} = $ruser->{adm_group} if (! exists $q->{GROUP} && $ruser->{adm_group});

  if ($q->{ACTION_ass} && $q->{GROUP}) {
    if (!exists $groups->{$q->{GROUP}}) {
       print Html->warning("Invalid group: $q->{GROUP}");
    } else {
      my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
      my $cnt;
      foreach my $d (@$devs) {
        if ($d->{host} eq $q->{HOST}) {
           $d->{adm_group} = $q->{GROUP};
           $cnt++;
        }
      }
      PDM::ConfigFile->write($renv, $devs, $hosts, $notifs);
      print Html->info("Updated $cnt devices!");
    }

  } elsif ($q->{ACTION_selected}) {
    my $err;
    my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
    foreach my $e (keys %$q) {
       if (substr($e,0,4) eq "del_") {
          my $no = substr($e,4);
          $devs->[$no] = undef;     
       }
    }
    PDM::ConfigFile->write($renv, $devs, $hosts, $notifs);
    print Html->warning("Invalid group(s): $err") if ($err);

  } elsif ($q->{ACTION_all}) {
    ($renv, $dev, $hosts,$notifs) = PDM::ConfigFile->read;
    PDM::ConfigFile->write( $renv, [], $hosts,$notifs);

  } elsif ($q->{ACTION_group}) {
    ($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
    my $x;
    for ($x=0; $x <= $#$devs; $x++) {
      my $d = $devs->[$x];
      if ($q->{GROUP} && $d->{adm_group} eq $q->{GROUP}) {
          $devs->[$x] = undef;
      }
    }
    print $G->expand('deleted', $q->{GROUP});

    PDM::ConfigFile->write( $renv, $devs, $hosts,$notifs);

  } elsif ($q->{ACTION_only}) {
    ($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read;
    my $x;
    for ($x=0; $x <= $#$devs; $x++) {
      my $d = $devs->[$x];
      if (($q->{HOST} && $d->{host} eq $q->{HOST}) ||
          ($q->{HOST} eq "LOCAL" && !$d->{host}))  {
          $devs->[$x] = undef;
      }
    }
    print $G->expand('deleted', $q->{HOST});
    delete $q->{HOST};
    PDM::ConfigFile->write( $renv, $devs, $hosts,$notifs);

  } elsif ($q->{ACTION} eq "Push Slave Configs") {
    GUI::Hosts::push_slaves($q);
  }

  ($renv, $dev, $hosts,$notifs) = PDM::ConfigFile->read;

  if (!$renv->{site_country}) {
     $q->{SITE_FIRST} = 1;
     GUI::Config::site($q);
     return;
  }

  $head = Html->header2("admin.gen_maint.maint_device");
  %H = ();

  $H{Master} = (-f System->get_home() . "/DATA/start")? "Y":"N";
  foreach $h (@$hosts) {
    $H{$h->{hostname}} = $h->{active};
  }
  my $sel;
  if ($#$dev > 200 && !$q->{HOST}) {
     $sel = "selected";
     $q->{HOST} = "LOCAL";
  }
  my $groupsD = $groups->select("GROUP", $q->{GROUP}, $G->{all});

  my($hostsD) = "<select name=HOST><option value=LOCAL $sel>$renv->{hostname}</option>";

  $sel = ($q->{HOST} eq "")? "selected":"";
  $hostsD .= "<option value=\"\" $sel>$G->{all_hosts}</option>";
  my(@H);
  my($CAT, %AGENT);
  $AGENT{""} = (-f System->get_home() . "/DATA/start") ? "Y" : "N";

  foreach $h (@$hosts) {
     $AGENT{$h->{hostname}} = $h->{active};
     push(@H, $h->{hostname});
     $CAT->{$h->{hostname}} = $h->{categories};
  }
  foreach $h (sort @H) {
     $sel = ($h eq $q->{HOST})? "selected":"";
     $hostsD .= "<option value=\"$h\" $sel>$h</option>";
  }
  $hostsD .= "</select>";

  $q->{sort} = 3 if (!$q->{sort});
  my $categories;
  for ($x=0; $x <= $#$dev; $x++) {
     $d = $dev->[$x];
     next if ($ruser->{isCustomer} && $d->{mgmtLevel} eq "C");
     my $ho = $d->{host} || "LOCAL" ;
     next if ($q->{HOST} && $q->{HOST} ne $ho);
     next if ($q->{GROUP} && $d->{adm_group} ne $q->{GROUP});
     $d->{no} = $x;
     if($d->{host} && ($renv->{solution} eq "N")){
       $categories = $CAT->{$d->{host}};
     }else{
       $categories = $renv->{categories};
     }
     $categories .= "|$renv->{solution}|";
     $d->{hactive} = "Y";
     $d->{hactive} = "N" if (index("|$categories|", "|$d->{type}|") < 0);
     $s = Serialize->hash_join($d);
     $loc = lc($d->{host}) || (System->hostname() . " (local)");
     if ($q->{sort} == 1) {
       $v = sprintf("%-30.30s %s", lc($d->{name}), $s);
     } elsif ($q->{sort} == 2) {
       $v = sprintf("%-30.30s %s", lc($d->{type}). $d->{name}, $s);
     } elsif ($q->{sort} == 3) {
       $v = sprintf("%-30.30s %s", $loc, $s);
     }
     push(@devs, $v);
  }
  my $urls = Launch->read();
  
  my($last, $cnt2);
  foreach $line (sort @devs) {
    $h = Serialize->hash_split(substr($line,31));
#   $h = $dev->[$x];
    $type = $h->{userLabel} || $h->{type};
    $type .= "-$h->{model}" if ($h->{model} && $h->{model} ne $h->{userLabel});

    my $agent = $AGENT{$h->{host}} eq "Y" ? " $G->{On}" : " <font color=red>$G->{Off}</font>";
    $ip  = $h->{ipno} || $h->{ip};
    $loc = $h->{host} || System->hostname();
    my $ix2 = index($loc, ".");
    $col = "black";

    if($h->{active} eq "Y"){
       $active =  "$G->{On}";
    }else{
      $active = "<font color=red>$G->{Off}</font>";
    }
    if($h->{hactive} eq "Y"){
       $active .=" $G->{On}";
    }else{
       $active .= " <font color=red>$G->{Off}</font>";
    }
    $active .= $agent;
    if ($h->{skip}) {
       $active .= "<br></b></b><font color=red><small>(Skipped since " . Util->get_today($h->{skip}) . ")";
    }
    my($bold);

    $loc0 = $loc;
    $loc0 = substr($loc,0,$ix2) if ($ix2 > 0);

    if (!$q->{sort} || ($q->{sort} == 3)) {
      if ($loc ne $last) {
         $ho .= "<tr><td colspan=6></td>" if ($last);
         $loc0 = "<b><a href=\"$Http::WEBPROC?GO=GUI::Devices::list&HOST=$h->{host}\">$loc0</a>";
         $last = $loc;
      }
    }
    my $WWN = $h->{wwn} || $h->{key};
    my $wwn_err;
    if ($h->{type} eq "t3" && length($WWN) < 2) {
       $wwn_err = "<font color=red>$L->{'dev_list.err_1'}";
    }
    if ($h->{type} eq "t3" && (!$h->{key} || index($h->{key}, ". .") >= 0)) {
       $wwn_err .= "<font color=red>$L->{'dev_list.err_2'}";
    }
    $wwn_err = "<br>$wwn_err" if ($wwn_err);
    my $module = Modules->findFromClass('GUIAdmin', $h->{class});
    $lnk = "<a href=\"$Http::WEBPROC?GO=${module}->updDevice&no=$h->{no}\">$h->{name}</a>";
    $xurl = "";
    if ($module) {
      my $mlist = {};
      if ($module->can("MAINTAIN")) {
         $mlist = $module->MAINTAIN();
      }
      my $xurl;
      foreach my $x (keys %$mlist) {
          $xurl  .= " | <a href=\"$Http::WEBPROC?GO=GUIAdmin::${b}::$x\">$mlist->{$x}</a>";
      }
    } else {
      $lnk = "$h->{name}";
    }
    my $agroup = $h->{adm_group};
    if (!$deny){
      $xurl = "<input type=checkbox name=del_$h->{no}>";
      #$agroup = "<input type=text size=8 name=group_$h->{no} value=\"$h->{adm_group}\">";
    }
    my $l1;
    if ($urls->{$h->{type}}[0] && $h->{mgmtLevel} ne "DS") {

        $launch = $urls->link($h->{type}, $h);
        $l1 = "<table border=0 width=100% cellspacing=0 cellpadding=0><tr><td>$lnk</td><td align=right>$launch</table>";
     } else {
        $l1 = $lnk;
     }
    $WWN = substr($WWN,0,6) . ".." if ($q->{DOC});
    $ho .= "<tr>
                <td $col>&nbsp;$loc0 </td>
                <td nowrap>$l1</td>
                <td><center>$type</td>
                <td><center><a href=$Http::WEBPROC?GO=GUI::Devices::comments&key=$h->{key}>Info</a></td>
                <td>$ip&nbsp;</td>
                <td>&nbsp;$WWN$wwn_err</td>
                <td><b><center><font color=$col>$active</td>
                <td><center>$agroup&nbsp;</td>
                <td nowrap><center>&nbsp;$xurl</td>
           ";
    $bold="";
    $cnt2++;
  }
  if ($cnt2 == 0) {
     $ho .= "<tr><td colspan=9><b>$L->{'dev_list.err_3'}</td>";
  }

  my $comment = GUI->needToPush($hosts);
  my $cnt = $#devs + 1;
  my $g1 = "&GROUP=$q->{GROUP}" if (exists $q->{GROUP});
  $o =<<EOF;

<body bgcolor=$Style::BGCOLOR>
<form method=get>
 <input type=hidden name=GO value=GUI::Devices::list>
<center>
$head
$q->{ERR}
$comment
<table border=1 cellspacing=0 width=90% bgcolor=white>
<tr><td colspan=9 bgcolor=$Style::DARK>
  <table border=0 cellspacing=0 cellpadding=0 width=100%>
    <tr><td nowrap><b><font color=white>&nbsp;$L->{'dev_list.l1'}</td>
    <td align=right width=10% nowrap><font color=white>&nbsp;
      <b>$L->{'dev_list.group'}: $groupsD &nbsp; $G->{host}: $hostsD<input type=submit name=ACTION value=GO></td><td></form></td>
  </table>
<tr>
    <td bgcolor=$Style::LIGHT><center><b>
        <form method=post>
        <input type=hidden name=GO value=GUI::Devices::list>
        <input type=hidden name=HOST value=\"$q->{HOST}\">
        <a href=$Http::WEBPROC?GO=GUI::Devices::list&sort=3&HOST=$q->{HOST}$g1>$G->{primary_host}</a></td>
    <td bgcolor=$Style::LIGHT><center><b>
        <a href=$Http::WEBPROC?GO=GUI::Devices::list&sort=1&HOST=$q->{HOST}$g1>$L->{'dev_list.l3'}</a></td>
    <td bgcolor=$Style::LIGHT><center><b>
        <a href=$Http::WEBPROC?GO=GUI::Devices::list&sort=2&HOST=$q->{HOST}$g1>$L->{'dev_list.l4'}</a></td>
    <td bgcolor=$Style::LIGHT><center><b>$L->{'dev_list.comment'}</td>
    <td bgcolor=$Style::LIGHT><center><b>$L->{'dev_list.l5'}</td>
    <td bgcolor=$Style::LIGHT><center><b>$L->{'dev_list.l6'}</td>
    <td bgcolor=$Style::LIGHT><center><b>$L->{'dev_list.l7'}</td>
    <td bgcolor=$Style::LIGHT><center><b>$L->{'dev_list.group'}</td>
    <td bgcolor=$Style::LIGHT><center><b>$L->{'dev_list.l8'}</td>
$ho
</table>
&nbsp;<br>
EOF
   print $o;
   my ($assign, $del_group);
   my $del_all = "<input type=submit name=ACTION_all value=\"$L->{'dev_list.submit2'}\"
         onclick=\"return confirm('$L->{'dev_list.l11'}')\">";

   if (!$deny) {
     my $del_host;
     my $h1 = $q->{HOST};
     my $gr_select = $groups->select("GROUP", undef, $L->{'dev_list.sel'});
     $del_all = "" if ($q->{GROUP});
     if ($q->{GROUP}) {
        $del_group = "<input type=submit name=ACTION_group value=\"$L->{'dev_list.submitG'} $q->{GROUP}\"
         onclick=\"return confirm('$L->{'dev_list.lgroup'}')\">"
     }
     if ($cnt && $h1 &&  $h1 !~ /^\d+\.\d+\./) {
        my $ix = index($h1, ".");
        $h1 = substr($h1,0,$ix) if ($ix > 0);
        $del_all = "";
        $del_host =  "<input type=submit name=ACTION_only value=\"" . 
         $L->expand('dev_list.submit1', $h1) . "\" onclick=\"return confirm('" . 
         $L->expand('dev_list.l10', $h1) . "')\">&nbsp;";
        if ($groups->count() > 0) {
          $assign = "<tr><td colspan=2>
           <table border=0 bgcolor=#F0F0F0><tr><td>&nbsp;
             <b>" . $L->expand('dev_list.assign' => $h1) . ":$gr_select
           <input type=submit name=ACTION_ass value=\"$L->{'dev_list.assign0'}\">&nbsp;</table>";
        }
     }
     print <<EOF;
 <table border=0 width=90%>
   <tr><td><b>
      $del_all &nbsp; $del_group
      $del_host
     </td>
     <td align=right><b>
        <input type=submit name=ACTION_selected value=\"$L->{'dev_list.submit3'}\">
    $assign
 </table>
</form>
EOF
    }
}

sub comments {
  my($q) = @_;

  my $G = Labels->read();
  my $L = Labels->read('GUI::Devices')->section("comments");
  print Html->body();
  my $key = $q->{key};

  if ($q->{ACTION_back}) {
    &list($q);
    return;
  }
  my $deny = Roles->verifyRole($q, "admin|c_admin");
  my $button;
  if (!$deny) {
    $button = "<b><input type=submit name=ACTION_update value=$G->{submit_update}>";
  }
  
  print Html->header2("admin.gen_maint.maint_device", undef, $L->{comment}, 
      undef, {noDoc => 1});

  if ($q->{ACTION_update}) {
    my $comment = Util->deserialize("Comments.txt") || {};
    $q->{comments} =~ s/\r//g;
    $q->{comments} =~ s/\n /\n/g;
    $comment->{$key} = $q->{comments};
    Util->serialize("Comments.txt", $comment);
    print Html->info($L->{updated});
  }
  my $renv   = System->get_renv();
  my $Config = PDM::ConfigFile->read();
  
  my $dev1 = $Config->deviceByKey($q->{key});
  my $comment = Util->deserialize("Comments.txt") || {};
  my $co = $comment->{$key};
  print <<EOF;
<table border=1 cellspacing=0 width=90% bgcolor=white cellpadding=2>
  <tr><td bgcolor=$Style::DARK colspan=2>
      <form><input type=hidden name=GO value=GUI::Devices::comments>
      <input type=hidden name=key value="$q->{key}">
      <font color=white><b>$L->{enter_info}
      </td>
  <tr><td align=right bgcolor=$Style::LIGHT> Device:</td>
      <td><b>$dev1->{name} </td>
  <tr><td bgcolor=$Style::LIGHT align=right>IP:</td>
      <td> $dev1->{ipno} &nbsp;</td>
  <tr><td bgcolor=$Style::LIGHT align=right>$L->{comment}:</td>
    <td ><textarea name=comments cols=80 rows=20>$co</textarea></td>
  </table>
   $button
     &nbsp;<td align=right><b><input type=submit name=ACTION_back value=\"$G->{back}\">
    </form>
EOF
}


sub add {
  my ($q) = @_;
  print Html->body();

  my $deny = Roles->verifyRole($q, "admin");
  if ($deny) {
    print $deny;
    return;
  }
  print &add0($q);
}

sub add0 {
  my($q) = @_;
  my $add ;
  my $L = Labels->read("GUI::Devices")->section("dev_list");
  my $categories = Modules->load("GUIAdmin");
  my $renv = System->get_renv();
  $add = "<table border=0 width=80%><tr><td valign=top>";
  my $cn = 0;
  my $tot = 0;
  foreach my $cat (sort @$categories) {
    next if ($renv->{solution} ne "N" && index(Report::CAT_LEGACY, lc(",$cat,")) >= 0);
    my $fun = "GUIAdmin::${cat}";
    if ($fun->isDevice() ) {
      $tot++;
    }
  }
  $tot++;
  foreach my $cat (sort @$categories) {
    next if ($renv->{solution} ne "N" && index(Report::CAT_LEGACY, lc(",$cat,")) >= 0);
    my $fun = "GUIAdmin::${cat}";
    if ($fun->isDevice() ) {
       my $desc = $fun->description() ;
       my $b = ($cat eq $q->{ADD}) ? "<b>": "";
       $add .= "<big>&nbsp;</big>-<a href=\"$Http::WEBPROC?GO=GUIAdmin::${cat}->addDevice\">" .($desc||$cat) . "</a><br>";
       $cn++;
       $add .= "</td><td valign=top>"  if ($cn == int($tot/3) || $cn == int(2*$tot/3));
    }
  }
  $add .= "</table>";

  my $h = Html->header2("admin.gen_maint.add_device");
  return "
    $h
   <table border=1 cellspacing=0 width=90% bgcolor=white>
   <tr><td colspan=3 bgcolor=$Style::DARK>
   <table border=0><tr><td><b><font color=white>&nbsp;$L->{select}
   </table></td>
   <tr><td colspan=3 bgcolor=white><center>$add</td>
   </table>";

}

sub selectList {
  my($q) = @_;

}


1;
