package GUI::DeviceReport;
use Report;
use System;
use strict;
use State;
use Html::List;

use vars qw (@E @GIF);
@E = ('ok', 'Warning', 'Error', 'Critical');

sub make_link {
  my($type, $h, $name ) = @_;
  my $h0 = $h;
  $h0 =~ s/\W//g;
  $name = $h if (!$name);
  return "<a href=javascript:win1('$type:$h','$h0')>$name</a>";
}


sub run {
 my($q) = @_;
 my $deny = Roles->verifyRole($q, "admin");
 print Html->body();
 print "<table border=0><tr><td></table>";

 my $summ = $q->{summary};

 if ($q->{ACTION_refresh}) {
    print "<meta http-equiv=Refresh content=\"70;URL=$Http::WEBPROC?".
          "GO=GUI::DeviceReport::run&summary=$summ&SIGN=$q->{SIGN}&SORT=$q->{SORT}&ACTION_refresh=1\">";

 } elsif ($q->{ACTION_clear}) {
    State->clearAllComponents();
    State->clearAllLinks();
    State->write();
 }
 print Html->header2("report.general.dev_report", "95%", undef, undef, {noDoc => 1});

 my %REPORT;
 my $LB = Labels->read("GUI::AlertReport");

 my $RL = Report->reportList();
 foreach my $r0 (keys %$RL) {
    $REPORT{$r0} = 1;
 }
 my($renv, $devs, $hosts, $notifs, $Config) = PDM::ConfigFile->read;
 my $State = State->read();
 State->cleanState();
 my $DB = State->getComponentState(1); # worst severity for each comp.
 my @report;

 my($sw, $st, $ho);
 my $file =  "host:" . $renv->{hostname};
 my ($sev, $err, $col, $sev_no) = &sev($DB, $file, $summ);
 my $mon = "On";
 $mon .= "/" . $LB->{no_report} if (!$REPORT{$file});
 my $url = &make_link("host", $renv->{hostname});

 $ho=1;
 if ($sev_no || $summ > 0) {
   push(@report, ["host", $url, $sev, Util->name2ip(),$mon, $err, $col ]);
 }

 foreach my $h (@$hosts) {
   ($sev, $err, $col, $sev_no) = &sev($DB, "host:" . $h->{hostname}, $summ);
   $ho++;
   next if (!$sev_no && $summ == 0);
   my $file =  "host:" . $renv->{hostname};
   my $mon = "On";
   $mon .= "/NoReport" if (!$REPORT{$file});
   my $url = &make_link("host", $h->{hostname});
   push(@report, ["host", $url, $sev, $h->{ipno},  $mon, $err, $col]);
 }
 foreach my $dev (@$devs) {
    my $file = $dev->{type} . ":" . $dev->{key};
    my $mon = ($dev->{active} eq "Y") ? "On" : "Off";
    $mon .= " <font color=red><small>(Skipped since " . Util->get_today($dev->{skip}) . ")</small></font>" if ($dev->{skip});

    $mon .= "/NoReport" if (!$REPORT{$file});

    if ($dev->{class} =~ /^switch/) {
       $sw++;
    } else {
       $st++;
    }
    my $label= $dev->{userLabel} || $dev->{type};

    next if (index($Report::EXCLUDE, ",$dev->{type},") >= 0);
    
    my $state = $DB->{$file};
    ($sev, $err, $col, $sev_no) = &sev($DB, $file, $summ, $q);
    next if (!$sev_no && $summ == 0);
    
    my $url = &make_link($dev->{type}, $dev->{key}, $dev->{name});
    push(@report, [$label, $url, $sev, $dev->{ipno},  $mon, $err, $col]);
 }
 my $f = "<font color=white>";
 my $f2 = "</font>";
 my($h1,$h2,$h, $links, $title);

 foreach my $el (
       "0=health=$LB->{title3}",
       "2=detail=$LB->{title1}",
         ) {
   my($el1, $el2, $h) = split(/\=/, $el);
   my ($b, $b2);
   if ($el1 == $summ) {
     $title = $h; $b = "<b>"; $b2 = "</b>";
   }
   $links .= " <a href=$Http::WEBPROC?GO=GUI::DeviceReport::run&summary=$el1>".
             "$f$b$LB->{$el2}$b2</font></a>" . " |";
 }
 chop($links);
 
 print "
  <script>
 function win1(a, winname) {
   var b = '$Http::WEBPROC?GO=GUI::Instr::rStart&Roption=2&topo=MERGE-MASTER&file=' + a;
   var O = window.open(b,winname,'menubar=no,resizable=yes,scrollbars=yes,width=550,height=700');
   O.focus();
 }
</script>
<table border=1 cellspacing=0 cellpadding=1 width=95% bgcolor=white>
  <tr bgcolor=$Style::DARK><td colspan=5>
      <table border=0 cellspacing=0 cellpadding=2 width=100%>
         <tr><td><font color=white><b>$title</td>
         <td align=right><font color=white>[ $links ]
      </table></td>";
 $q->{SORT} = 1 if (!$q->{SORT});
 my($pageInfo, $list) = Html::List->makeList($q,
                        \@report,
               [$LB->{type},   $LB->{name},  $LB->{health0} , $LB->{ip},  $LB->{mon} ],
               [  'l',     'l',     'c',       'l',      'c'  ],
               [  '+',     '+',     '-',       '+',      '+'  ],
                {line2 => "5", 
                colorRow => 8, 
                pageSize => 2000, interactive => 1});

  $sw += 0;
  $ho += 0;
  print " $list
  </table>
  <table border=0><tr><td></table>
  <table border=0 width=95%>
    <tr><td>$LB->{sw}: $sw, $LB->{st}: $st, $LB->{ho}: $ho <td align=right>
  </table>
  <form>
    <input type=hidden name=summary value=$summ>
    <input type=hidden name=SORT value=$q->{SORT}>
    <input type=hidden name=SIGN value=$q->{SIGN}>
    <input type=hidden name=GO value=GUI::DeviceReport::run>
    <b><input type=submit name=ACTION_refresh value=\"$LB->{submit_reload}\">";
  if (!$deny) {
    print "<b><input type=submit name=ACTION_clear value=\"$LB->{submit_ack}\">";
  }
  print "</form>";
}

my @GIF = (  "&nbsp;", # <ximg src=/gif/al_ok3.gif alt=OK>",
             "<img src=/gif/al_alert3.gif alt=Warning border=0>",
             "<img src=/gif/al_crit3.gif alt=Error border=0>",
             "<img src=/gif/al_down3.gif alt=Critical border=0>",
             );

sub sev {
  my($DB, $k, $summ) = @_;
  my $state = $DB->{$k};
  my $sev = int($state->[0]+0.5);
  my ($col, $b);
  if ($sev >= 1) {
     $col = "#FFFFE0";
     $b = "<b>";
  }
  my $d = "<small>$state->[1]" if ($state->[1] && $summ == 1);
  return ("<xx $sev>$b$GIF[$sev]", $d, $col, $sev);
}

1;

