package FSA::RuleSet1;
use strict;

# each event-aggregate goes thru each rule until one fires.

sub run {
 my($class, $Config, $topo, $targets, $elist, $data) = @_;
 my ($x);
 foreach $x (1,3,4,5,51,101) {
   my $rule = "RULE$x";
   my $ev;
   my($ev, $pertains) = FSA::RuleSet1->$rule($Config, $topo, $targets, $elist, $data);
   if ($ev) {
      return ($ev, $pertains, $x);
   }
 }
 return ();
}


# Confirmed communication lost oob
# returns ($ev, $pertains)
#
sub RULE1 {
 my($class, $Config, $topo, $targets, $elist, $data) = @_;
 my ($cnt, $cl, $seen, $ev, $pertains);

 foreach my $ed (@$elist) {
    my $ev = $ed->instances(0);
    if ($ev->value("EventType") =~ /CommunicationLostEvent/ && 
        $ev->value('Caption') eq "e") {
      $cl = $ev;
      $cnt++;
    } elsif ($ev->value("Component") =~ /^port.\d+/ || 
             $ev->value("Caption") =~ /driver/ ) {
      $seen = 1;
    }
 }
 if ($cl && ($cnt==1) && $seen) {
    my $targetName = $cl->value("TargetName");
    my $target     = $cl->value("Target");
    my $ix = index($target, ":");
    $target = substr($target,$ix+1) if ($ix > 0);
    my ($type, $et) = split(/\./, $cl->value("EventType"));
    my $desc = "$type device $targetName is not available anymore, ". 
               "confirmed by the following " .  ($#$elist) . " subEvents:";

    my $key = CIM::Key->new( ['NWS_System',
                                Name  => $target,
                    CreationClassName => 'NWS_System']);
  
    my $id = PDM->getEventSequence(); 
    $ev = CIM::Instance->new('NWS_Event', [
                  [ EventId     => $id          ],
                  [ EventType   => "$type.DeviceLostEvent"   ],
                  [ Target      => $cl->value("Target")    ],
                  [ TargetName  => $cl->value("TargetName")],
                  [ Caption     => "aggregate"               ],
                  [ Component   => $cl->value("Component") ],
                  [ SourceIP    => $cl->value("SourceIP")  ],
                  [ Actionable  => $cl->value("Actionable")],
                  [ Severity    => 3            ],
                  [ Aggregate   => ($#$elist+1) ],
                  [ Description => $desc        ],
                  [ Data        => $data        ],
                         ]);

    $pertains = CIM::Instance->new('NWS_EventPertainsToSystem', [
                  [ Event       => $ev  ],
                  [ Element     => $key ],
                    ]);

    return ($ev, $pertains);
 }
 return ();
}


# look for an unconfirmed CommLostEvent, decrease ACTIONABLE
#
sub RULE3 {
 my($class, $Config, $topo, $targets, $elist, $data) = @_;

 if ($#$elist == 0) {
   my $ed = $elist->[0];
   my $ev = $ed->instances(0);
   if ($ev->value("EventType") =~ /CommunicationLostEvent/ && 
        $ev->value('Caption') eq "e") {
     print "FS-RULE3\n";
     my $target = $ev->value("Target");
     my $node;
     if ($node = $topo->nodeByName($target)) {
       my $ports = $node->port();
       if ($#$ports >= 0) {
         $ev->setValue("Actionable", "FALSE");
       }
     }
   }
 } 
}

# CABLE DISCONNECTED BETWEEN SWITCH and HOST/SWITCH or DEVICE
# requires at least 2 events, switch-port-offline and hba or device or 
# other switch.

sub RULE4 {
 my($class, $Config, $topo, $targets, $elist, $data) = @_;

 my($sc, $hc, $log, $al, $others, $event, $cat, $edoc1, $host_flag, $edocH );
 my $target = $targets->[0];
 my $target_count = $#$targets + 1;
 
 $DB::single = 1;
 foreach my $ed (@$elist) {
    my $ev    = $ed->instances(0);
    my $et    = $ev->value("EventType");
    my $cap   = $ev->value("Caption");
    my $class = $ed->id("class");
    if ($et =~ /StateChangeEvent/ && $class =~ /^switch/) {
       $sc++;
       $edoc1 = $ed if (!$edoc1);
    } elsif ($et =~ /LogEvent/) {
       $log++;
    } elsif ($et =~  /host.AlarmEvent/) {
       $al++;
       $hc++ if ($cap =~ /M.hba/);
    } else {
       $others++;
    }
  }
  return () if ($others);
  my ($ev_targetName, $targetName, $sw_event, $dev, $found, $desc, $ev_target);

  if (($sc == 2) ||                                            # sw2sw
      ($sc == 1 && ($al+$log) > 0 && $target_count == 1) ||    # sw2dev, 1 target
      ($sc == 1 && $hc == 1)                                   # sw2host
      ) { 
     $cat          = $edoc1->id("category");
     $sw_event     = $edoc1->instances(0);
     $ev_target    = $sw_event->value("Target");
     $ev_targetName= $sw_event->value("TargetName");
     my $node      = $topo->nodeByName($ev_target);
     return () if (!$node);
     my $ports     = $node->port();
     my $p         = $sw_event->value("Component");
     $p            =~ /port\.(\d+)/;
     my $pno       = $1;
     my $port      = $ports->[$pno];
     return () if (!$port);
     my @a         = split(/\:/, $port);
     my $ev_target2   = "$a[0]:$a[1]";
     my $node2      = $topo->nodeByName($ev_target2);
     $dev = $Config->deviceByKey($ev_target2); 
     my $devName = $dev ? "$dev->{type} $dev->{name}/$dev->{ipno}" : $ev_target2;
     my $info;
     if ($a[0] eq "host") {
       my $pi = $node2->portInfo($a[2]);
       $info = "hba-$a[2] ($pi->{path})";
     } else {
       $info = $node2->portLabel($a[2]);
     }
     $desc = "Lost connectivity between $cat $ev_targetName port-$pno and $devName $info:";

     my $key = CIM::Key->new( ['NWS_System', Name  => $ev_target,
                     CreationClassName => 'NWS_System']);

     my $id   = PDM->getEventSequence(); 

     my $ev = CIM::Instance->new('NWS_Event', [
        [ EventId     => $id          ],
        [ EventType   => "$cat.ConnectivityLostEvent"   ],
        [ Target      => $ev_target    ],
        [ TargetName  => $sw_event->value("TargetName")],
        [ Caption     => $sw_event->value("Caption")   ],
        [ Component   => $sw_event->value("Component") ],
        [ SourceIP    => $sw_event->value("SourceIP")  ],
        [ Actionable  => $sw_event->value("Actionable")],
        [ Severity    => $sw_event->value("Severity")  ],
        [ Aggregate   => ($#$elist+1) ],
        [ Description => $desc        ],
        [ Data        => $data        ],
               ]);

     my $pertains = CIM::Instance->new('NWS_EventPertainsToSystem', [
        [ Event       => $ev  ],
        [ Element     => $key ],
          ]);

     return ($ev, $pertains);
  }
  return ();
}

#
# make battery event non-actionable if logfile says its refreshing
#

sub RULE5 {
 my($class, $Config, $topo, $targets, $elist, $data) = @_;
 my ($bat, $log, $other, $bat_ev);
 $DB::single = 1;

 foreach my $ed (@$elist) {
    my $ev    = $ed->instances(0);
    my $et    = $ev->value("EventType");
    my $cap   = $ev->value("Caption");
    my $class = $ed->id("class");
    if ($et =~ /AlarmEvent/ && $cap =~ /fruPowerBatState/) {
       $bat++;
    } elsif ($et =~ /LogEvent/ && $cap =~ /refresh_battery/) {
       $log++;
    } else {
       $other++;
    }
  }
  if ($bat && $log && !$other) {
    foreach my $ed (@$elist) {
      my $ev  = $ed->instances(0);
      $ev->setValue("Actionable", "FALSE"); # minimize if it's a refresh
      print "here\n";
    }
  }
  return ();
}

#
# aggregate around missing loopcable E: u1l2: UP cable not present
# when volume, disks and loopcard not present appear at the same time.
#

sub RULE51 {
 my($class, $Config, $topo, $targets, $elist, $data) = @_;
 my ($vol, $disk, $cable, $log, $other);
 $DB::single = 1;
 my ($cl, $details);
 foreach my $ed (@$elist) {
    my $ev    = $ed->instances(0);
    my $et    = $ev->value("EventType");
    my $cap   = $ev->value("Caption");
    my $class = $ed->id("class");
    my $desc  = $ed->id("Description");
    if ($et =~ /AlarmEvent/ && $cap =~ /volume/) {
       $vol++;
    } elsif ($et =~ /AlarmEvent/ && $cap =~ /disk/) {
       $disk++;
    } elsif ($et =~ /LogEvent/ && $cap =~ /loopcard/ && $desc =~ /cable not present/) {
       $details = $cap;
       $cl = $ev;
       $cable++;
    } else {
       $other++;
    }
  }
  if ($disk && $cable && $vol) {
    my $targetName = $cl->value("TargetName");
    my $target     = $cl->value("Target");
    my $ix = index($target, ":");
    $target = substr($target,$ix+1) if ($ix > 0);
    my ($type, $et) = split(/\./, $cl->value("EventType"));
    my $desc = "Loop Interconnect Cable $details was disconnected on $target, ".
               "confirmed by the following " .  ($#$elist) . " subEvents:";

    my $key = CIM::Key->new( ['NWS_System',
                                Name  => $target,
                    CreationClassName => 'NWS_System']);
  
    my $id = PDM->getEventSequence(); 
    my $ev = CIM::Instance->new('NWS_Event', [
                  [ EventId     => $id          ],
                  [ EventType   => "$type.LoopCableDisconnect"   ],
                  [ Target      => $cl->value("Target")    ],
                  [ TargetName  => $cl->value("TargetName")],
                  [ Caption     => $details ],
                  [ Component   => $cl->value("Component") ],
                  [ SourceIP    => $cl->value("SourceIP")  ],
                  [ Actionable  => $cl->value("Actionable")],
                  [ Severity    => 2            ],
                  [ Aggregate   => ($#$elist+1) ],
                  [ Description => $desc        ],
                  [ Data        => $data        ],
                         ]);

    my $pertains = CIM::Instance->new('NWS_EventPertainsToSystem', [
                  [ Event       => $ev  ],
                  [ Element     => $key ],
                    ]);

    return ($ev, $pertains);
  }
  return ();
}



#
# only one actionable-error against the agg-target and other events are less than an error
#
sub RULE101 {
  my($class, $Config, $topo, $targets, $elist, $data) = @_;
  my($sc, $log, $al, $others, $event, $cat, $edoc1, $data);
  return if ($#$targets != 0); # one target

  my $agg_target = $targets->[0];
  my ($cnt, $other);
  $DB::single = 1;

  foreach my $ed (@$elist) {
    my $ev    = $ed->instances(0);
    my $et    = $ev->value("EventType");
    my $sev   = $ev->value("Severity");
    my $ac    = $ev->value("Actionable");

    if ($sev >= 2 && $ac eq "TRUE") {
       $cnt++;
       $event = $ed;
       $data  = $ev->value("Data");
    } elsif ($sev >= 2) {
       $other++;
    }
  }
  if ($cnt == 1 && $other == 0 && !$data) {
    my $ev = $event->instances(0);
    my $ev_target = $ev->value("Target");
    if ($ev_target eq $agg_target) {

       my $key = CIM::Key->new( ['NWS_System', Name  => $ev_target,
                     CreationClassName => 'NWS_System']);

       my $id   = PDM->getEventSequence(); 

       my $ev = CIM::Instance->new('NWS_Event', [
        [ EventId     => $id                        ],
        [ EventType   => $ev->value("EventType")    ],
        [ Target      => $ev->value("Target")       ],
        [ TargetName  => $ev->value("TargetName")   ],
        [ Caption     => $ev->value("Caption")      ],
        [ Component   => $ev->value("Component")    ],
        [ SourceIP    => $ev->value("SourceIP")     ],
        [ Actionable  => $ev->value("Actionable")   ],
        [ Severity    => $ev->value("Severity")     ],
        [ Aggregate   => ($#$elist+1)               ],
        [ Description => $ev->value("Description")  ],
        [ Data        => $ev->value("Data")         ],
               ]);

       my $pertains = CIM::Instance->new('NWS_EventPertainsToSystem', [
        [ Event       => $ev  ],
        [ Element     => $key ],
          ]);

       return ($ev, $pertains);
    }
  }
}
     
   
1;
