# "Single target device error (tape or T3 or A3500FC device)
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

package FCRules::Rule3;
use TO;
use Data::Dumper;
use Catalog;
use strict;

# WRITE
sub description {
  return "Single target device error (tape or T3 or A3500FC device)";
}

sub category {
  return "CRC";
}
# key= ' |100000c0dd00885d|port.002|switch'
# key= '0|100000000c0d0|port.1|t3'
# key= '0|10000000000de0|front.0|a5k'

sub run {
  my($class, $To, $hm, $report,  $count, $key, $info, $reads, $writes,
     $fc_type) = @_;

  my($CIMKey1, $CIMKey2, $key1, $key2, $ctrl_port, $port_desc, $linkno);
  my $Config = PDM::ConfigFile->read();
  my($hba, $wwn, $port0, $type) = split(/\|/, $key);

  return(undef,undef) if ($type eq "switch" || $type eq "host");
  my($st, $port, $head, $linkno);

  if ($type eq 'a5k') {
     ($st, $port) = $To->nodeByKey($wwn);
     return undef if (!$st);
     my $hba_path = $info->{hba}{$hba};
     my $port_type = substr($port0,0,1) ; # s=ses, f=front, r=re
     $linkno =  FCRules->a5kIsFirst($hba_path, $st, $port_type);
     return undef if (!defined($linkno));
     $port = $linkno;

  } elsif (($st = $To->nodeByName("$type:$wwn")) ) {  # t4
     $linkno = $port0; $linkno =~ s/port\.//;
     $port = $linkno;

  } else {  # t3 inband
     my $wwn0 = $wwn;
     substr($wwn0,7,1) = "3" if (length($wwn) > 8);
     ($st, $linkno) = $To->nodeByKey($wwn0);
     $port = $linkno;
  }
  return undef if (!$st);

  $type       = $st->type();
  my $st_info = $st->{info};
  my($portI)  = $st->portInfo();
  my $links   = $st->port();        # ports of array
  my $link    = $links->[$linkno];  # could be 0 or 1

  my($ltype, $t_key, $pno) = split(/:/, $link);

  my $target = $To->nodeByName("$ltype:$t_key");
  if (!$target) {
     Debug->print2("Rule3: Cannot find $ltype:$t_key");
     return ();
  }
  my($host, $hbas, $sw, $sw_info, $ip);

  my($level, $cnt, $desc, $mins) = Thresholds->test("${fc_type}counters","rule3","$wwn-$port" , $count);

  $mins = 1 if (!$mins);

  if ( $level eq "E") { # error level threshold fired

     my $target_ports = $target->{portInfo};
     my $target_port  = $target_ports->[$pno];

     my($desc) = "$fc_type-ERROR ($cnt in $mins mins): Origin: " .
                  $target->portLabel($pno) . " on '" . 
                  $target->id() . "'. Destination: " . 
                  $st->portLabel($port) . " on '" . $st->id() ;

     $hm->linkEvent($report, 
              $ltype, $target->name() . ":$pno", 
              $type,  $st->name(). ":$linkno", 
              $desc, $reads, $writes, $hba, $fc_type);

   } else {
      return ("$type should be connected to a host or switch : ltype=$ltype",undef);
   }

   return (undef, "");
}


1;


