package Command;
use strict;
use Proc::Background;

use System;

# allows to run commands that take forever and wait for them just
# a little while and let them still run and get the results on the
# next run of the agent.

# sleep TO in case it's done by then, otherwise returns nothing
# kill at $MAX_TO
#
# RC:   
#       0 => not finisned after TO, return nothing.
#       1 => ok, 
#       2 => cannot kill, 
#       3 => killed after MAX_TO

sub run {
  my($class, $command, $TO, $MAX_TO) = @_;

  my $D = System->get_home() . '/DATA/Commands';
  my $file0 = $command;
  $file0 =~ s/\W/_/g;
  my $file = "$D/$file0";
  my $proc = Util->deserialize("Commands/$file.db");

  my ($exit, $show);

  if ($proc) {  # OLD
     if ($proc->alive()) {
        my $age = time - $proc->start_time();
        if ($age > $MAX_TO) {
           my $rc = $proc->die();
           $exit = $rc ? 3:2;
        }
           
     } else {
       $show =1;
     }

  } else {      # NEW PROCESS
    unlink $file;
    my $proc =  Proc::Background->new("$command > $file.out 2>&1");
    my $to = $TO;
    while ($to > 0) {
        sleep(5);
        $to -= 5;
        last if (!$proc->alive());
    }
    if ($proc->alive()) {
       $exit = 0;     
    } else {
       $exit = 1; $show = 1;
    }
  }

  Util->serialize("Commands/$file.db", $proc);

  if ($show) {
     open(RR, "$file.out");
     my @L = <RR>; close(RR);
     return ($exit, \@L);
  } else {
     return ($exit,undef);
  }
}

sub out {
  my($class, $file) = @_;
  open(RR, "$file.out");
  my @L = <RR>; close(RR);
  return (1, \@L);
}



1;
