package Checksum;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use strict;

use vars qw($CK_TIME);

$CK_TIME = -1;

# 1 = success

sub checksum {
  my($class,  $file) = @_;
  my($found, @a, $text, @text, $l);
  return 1;  # off for now

  $CK_TIME = Timer->isXdays("checksum", 1) if ($CK_TIME == -1);
  return 1 if (!$CK_TIME);

  Debug->print3("Doing checksum on $file.");

  my($fname) = System->get_home() . "/DATA/ck_list";
  if (-f $fname) {
    if (open(O, $fname)) {
      while ($l = <O>) {
         @a = split(/=/, $l);
         if ($a[0] eq $file) {
            $found = $a[1];
         }
      }
      close(O);
    }
  }
  open(O, $file);
  <O>;
  @text = <O>; close(O);
  $text= "@text";
  my $newck = Util->_checksum($text);

  if ($found) {
     if ($newck != $found) {
        Timer->reset("checksum");
        return 0;
     }
  } else {
    open(O, ">>$fname");
    print O "$file=$newck\n";
    close(O);
  }
  return 1;
}

sub _checksum {
    my ($class,
        $msg            # The message to checksum
        ) = @_;
    my ($len_msg,       # Length of the message
        $num_short,     # The number of short words in the message
        $short,         # One short word
        $chk            # The checksum
        );

    $len_msg = length($msg);
    $num_short = $len_msg / 2;
    $chk = 0;
    foreach $short (unpack("S*", $msg))
    {
        $chk += $short;
    }                                           # Add the odd byte in
    $chk += unpack("C", substr($msg, $len_msg - 1, 1)) if $len_msg % 2;
    $chk = ($chk >> 16) + ($chk & 0xffff);      # Fold high into low
    return(~(($chk >> 16) + $chk) & 0xffff);    # Again and complement
}

1;

