package Cache;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>


use Util;
use System;
use Data::Dumper;
$CACHE = undef;

sub _load {
  my($class, $cat) = @_;
  my($VAR1);
  if (!$CACHE->{$cat}) {
     my $file = System->get_home() . "/DATA/cache_$cat";
     if (open(CACHER, $file)) {
       @x = <CACHER>;
       eval "@x";
       $CACHE->{$cat} = $VAR1;
       close(CACHER);
     } else {
       $CACHE->{$cat} = {};
     }
  }
}
   

sub read {
  my($class, $cat, $name) = @_;
  my($x, $VAR1);
  $class->_load($cat);

  return $CACHE->{$cat}{$name};
}
 
sub write {
  my($class, $cat, $name, $var) = @_;
  $class->_load($cat);
  $CACHE->{$cat}{$name} = $var;
  $class->_save($cat);
}
  
  

sub _save {
  my($class, $cat) = @_;

  if ($CACHE) {
     my $file = System->get_home() . "/DATA/cache_$cat";
     open(CACHEO, ">$file");
     $Data::Dumper::Indent = 1;
     print CACHEO Dumper($CACHE->{$cat});
     close(CACHEO);
     chmod 0666, $file;
  }
}


#
# read if var is missing, otherwise write
#
sub cache {
  my($class, $cat, $name, $var) = @_;
  $class->_load($cat);

  if ($var) {
     $CACHE->{$cat}{$name} = $var;
     $class->_save($cat);
  } else {
     return $CACHE->{$cat}{$name};
  }
  return $var;
}



1;
