package Agent::SWITCH_Parent;

use System;
use strict;
use Agent;
use base 'Agent';
use Thread;

sub MAX_THREADS {
  my $renv = System->get_renv();
  return $renv->{switch_max_thread} ;
}

sub CONFLICTS {
  return "";
}

sub printit {
  my($dev) = @_;
  Debug->print1("-> Reading $dev->{type}:$dev->{name}/$dev->{ip}");
}


sub RUN {
  my($agent,$ras_flag) = @_;
  my(%DONE, $HBA, $logfile, $r, @results);
  my($dif, $xml, @all_dif, $ev, @stats, $id, $log_lines, $sdt);
  my($renv) = System->get_renv();

  $DB::single=1;
  Timelapse->start(ref($agent));

  my($today) = Util->today("YMDH");
  my($dc) = 0;
  my $se_conflict = $agent->CONFLICTS();
  my $max_threads = $agent->MAX_THREADS();
  my @LIST;
  Debug->print1("-> Doing $max_threads switches at a time") if ($max_threads > 1);


  foreach my $device ( $agent->deviceList()) {
     next if ($device->{active} eq "N"); # skip extra switches
     if ($se_conflict && index($se_conflict, $device->{name}) >= 0) {
       Debug->print2("-> $device->{type}: skipping $device->{name},".
                        " detected device lockFile");
       next;
     }
 
     $dc++;
     #Debug->print1("-> $device->{type}: Reading device $device->{name}: $device->{ip}");
 
     if (!$device->{ip}) {
         Debug->errNoRepeat( 'SWITCH_IP',$device->{name}, 8 );
         next;
     }
     push(@LIST, $device);
  }

  my $TO = $renv->{'timeout.snmp'};
  my $thread = Thread->new({          TO => $TO * 10, 
                             device_list => \@LIST,
                                     max => $max_threads ,
                         displayFunction => \&printit,
                            });
  while (1) {
     my $run_list = $thread->run();
     last if ($#$run_list < 0);
     foreach my $run (@$run_list) {
       my $report = $run->[1];
       my $device = $run->[0];
       Debug->print1("-> Processing $device->{type}:$device->{name}/$device->{ip}  ($run->[2] secs)") if ($max_threads  > 1);


       my $connect_errs = $report->{'rc.error'};
       my $wwn          = lc($report->{'rc.key'});
   
       if ($wwn && $wwn ne $device->{wwn}) {
         PDM->fixConfig("switch", $device->{wwn}, $wwn);
         Debug->errNoRepeat( 'SWITCH_NEWIP', $device->{name}, 24,
              "wwn of switch $device->{ip} changed from $device->{wwn} to $wwn");
       }
   
       my $t1 = $device->{ipno} || $device->{ip};
       $id = {
                 deviceName  => $device->{wwn},
                 active      => $device->{active},
                 name        => $device->{name},
                 class       => $device->{class},
                 display     => "$device->{name} (ip=$t1)",
                 category    => $device->{type},
                 ip          => $device->{ip},
              };
   
       $report = {} if (!$report);
       $agent->copyDev($device, $report);
   
       $report->{"id.name"} = $device->{name};
       $report->{"id.mgmtLevel"} = $device->{mgmtLevel};
       $report->{"id.ip"}   = $device->{ip};
       $report->{"id.ipno"} = $device->{ipno};
       $report->{"id.wwn"}  = $device->{wwn};
       if ($device->{primary}) {
         $report->{'id.primary'} =
             $device->{primary} . ":" . $device->{fc} . ":" . $device->{port};
       }
       my $new_rep;
       if ($connect_errs || !$wwn) {
           $report->{'id.connect_errs'} = $connect_errs;
           $new_rep = Report->new($id, $report , [], Report::STATUS_CANNOT_CONNECT);
       } else {
           $new_rep = Report->new($id, $report , $log_lines);
       }
       PDM->saveReport($new_rep);
    }
  }
  Debug->print2("  No devices found") if (!$dc);

  Timelapse->stop(ref($agent));
}


1;

