package Agent::SAN;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>


#  $Name:  $
#  $Id: SAN.pm,v 1.24 2003/05/27 21:49:14 ccadieux Exp $
use strict;
use Agent;
use base 'Agent';
use Agent::SWITCH;
use Agent::T3;
use Agent::SWITCH;
use Agent::VE;
use vars qw( %RAID);

sub isSelectable {"FC-Counters"}

sub revision {'$Revision: 1.24 $'}


sub new {
  my($self) = Agent->new();

  bless ($self, 'Agent::SAN');
  return $self;
}

sub RUN {
  my($agent, $ras_flag) = @_;
  my($mod, @mods, $x, @writes, @reads, $report);
  my($a5, $t3, $sw, $sum, @fc, $l, $ib, $ob, $skip);

  my($cache) = 0;
  my($pdm) = $agent->{pdm};

  my ($renv, $devs, $hosts, $notifs) = PDM::ConfigFile->read();
  $report = {};

  $DB::single=1;
  
  my $freq = $renv->{fc_frequency} + 0;
  $freq = 60 if (!$freq);

  Debug->print2("SAN: extracting counters...");
  my $agents = Modules->load("Agent");
  foreach my $ag0 (@$agents) {
     next if (index("|$renv->{categories}|", "|". lc($ag0) . "|") < 0);
     my $ag = "Agent::$ag0";
     if ($ag->can("FCCounters")) {
        my $rep = $ag->FCCounters( { responsibleOnly => 1} );
        if (!exists $report->{"FC_$ag" }) {
          $report->{"FC_$ag"} = $rep;
        } else {
          &merge( $report->{"FC_$ag" }, $rep);
        }
     }
  }
  # done already by INSTRUMENTATION, just extract

  my $list = Report->newReportList("switch2,brocade,mcdata");
  foreach my $key (@$list) {
     my $rep = Report->readNew($key);
     my $v = $rep->value();
     if (exists $v->{FC_COUNTERS}) {
        my $ag = "Agent::" . uc($rep->category());
        if (!exists $report->{"FC_$ag"}) {
           $report->{"FC_$ag" } =  $v->{FC_COUNTERS};
        } else {
          &merge($report->{"FC_$ag" }, $v->{FC_COUNTERS});
        }
     }
  }
     
  my($id) = {  
           deviceName  => "san",
           name        => "san",
           category    => Report::CAT_SAN,
           ip          => "",
           };

  $pdm->saveReport( Report->new($id, $report , undef) , {skip_health => $skip} );
  Timelapse->stop(ref($agent));
}

sub merge {
  my($R, $r) = @_;
  
  my $r_data = $r->{data};

  foreach my $el (keys %$r_data) {
     $R->{data}{$el} = $r_data->{$el};
  }
}



1;
