package Agent;

#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Id: Agent.pm,v 1.75 2003/04/24 18:33:14 ccadieux Exp $

use strict;
use Util;
use PDM;
use Carp;
use vars qw($AUTOLOAD);
use System;
use Debug;
use Timelapse;
use Thresholds;
use Report;


use vars qw(%_FIELDS %LOGFILES $WWNINFO $ERROR);

%_FIELDS = ('can_be_turned_off', undef);

#
# $agent = Agent->new({data => $DATA, today => $today, opt_T => $opt_T,
#                   });
# Usage:
# $agent->last_run
#       ->new
#       ->read_log_file 
#       ->format_dev_info 
#       ->ping 
#       ->telnet
#       ->diff 
#       ->load_cache
#       ->save_cache
#

sub new {
  my($this) = {};
  bless($this, 'Agent');
  my $hostid   = `/bin/hostid`; chomp($hostid);

  $this->{hostid} = $hostid;
  return $this;
}

sub init {
  my($agent,$vals) = @_;
  my($x);

  foreach $x (keys %$vals) {
    $agent->{$x} = $vals->{$x};
  }
}

sub copyDev {
  my($class, $dev, $report) = @_;

  foreach my $x (keys %$dev) {
     next if (substr($x,0,1)eq "_");
     $report->{"id.device_$x"} = $dev->{$x};
  }
}

#
# returns a list of agents that can be selected (turned on/off)
# used for Email/ hosts etc..
#
sub findSelectableAgents {
  my($class, $solution) = @_;
  my(@MODS, @dirs, $x);
  my $renv = System->get_renv();
  $solution = $renv->{solution} if (!defined($solution));

  my($list) = Util->findMethods("Agent",undef, "isSelectable");
  my $L = ",6120,t3,switch,switch2,sve2,host,san,brocade,ve,3510,";
  my $LSE2 = ",6120,host,san,";

  foreach my $f (sort @$list) {
    my(@b) = split(/=/, $f);
    if ($b[1]) {
      my $ag = lc($b[0]);
      next if ($solution eq "se" && index($L, ",$ag,") < 0);
      next if ($solution eq "se2" && index($LSE2, ",$ag,") < 0);
      push(@MODS, $ag . "=$b[1]" );
    }
  }
  return \@MODS;
}



sub newId {
  my($class, $reportCat, $key, $logfile, $displayName) = @_;

  return {category   => $reportCat,
          deviceName => $key,
          logFile    => $logfile,
          display    => $displayName,
         };
}

# sun or brocade

sub switchFCCounters {
  my($class, $TYPE, $arg) = @_;
  require PDM::ConfigFile;

  my($renv, $devs, $host,$notifs) = PDM::ConfigFile->read;
  my(%SW, %DONE);
  my $masterLoc  = Util->findMaster();

  foreach my $d (@$devs) {
    next if ($d->{type} ne $TYPE);
    next if ($d->{active} eq "N");
    next if ($DONE{$d->{wwn}});
    $DONE{$d->{wwn}} = 1;

    next if (!$d->isMineToMonitor() );

    Debug->print2("FC-Switch: Reading switch $d->{name}");

    my $db = $class->FCfromDevice($d);
    next if (!$db);

    foreach my $l (keys %{$db->{enc}}) {
        $SW{enc}{$l} = $db->{enc}{$l};
    }
    foreach my $l (keys %{$db->{data}}) {
        $SW{data}{$l} = $db->{data}{$l};
    }
    #$SW{data_info} = $db->{data_info};
  }
  return \%SW;
}



sub stor_conflicts {
  my($class) = @_;
  my $STOR_PROCS =",stexpert,stresstest,linktest,a3500fctest,a5ktest,fcdisktest,t3test,a5ksestest,ifptest,qlctest,socaltest,switchtest,disktest,fctapetest,t3ofdg,t3volverify,sve_probe,vediag,sve_sudiag,sve_sddiag,daktest,daksestest,brocadetest,d2disktest,daktest,daksestest,switch2test,veluntest,linktest";

  require Scheduler;
  my $l;
  my($renv)     = System->get_renv();

  my $list = Scheduler->processList("ST", "*", {status => 'O'});
  my (%SC, $sc_list);
  foreach my $l (@$list) {
    $SC{$l->{command}} = 1;
  }
  foreach my $x (keys %SC) {
    $sc_list .= "$x,";
  }

  my ($err, $ras) = Util->run_command("/usr/bin/ps -ef", "ps", 30);
  foreach my $x0 (@$ras) {
     my $x = Util->ltrim($x0);
     my @a = split(/\s+/, $x);

     #Grab the name of the perl module since stresstest will show here
     foreach my $no (7,9) {
       my $pname  = $a[$no];

       my $ix  = index($pname, " ") ;
       $pname = substr($pname, 0, $ix) if ($ix >= 0);
       $ix = rindex($pname, "/");
       $pname = substr($pname, $ix+1) if ($ix >= 0);

       if (index($STOR_PROCS, ",$pname,") >= 0) {
          $sc_list .= "$pname,";
       }
     }
  }
  return $sc_list;

}




sub hostInfo {
  my($class) = @_;
  require PDM;
  my($h) = PDM->getCacheHandle("HostInfo");
  require CIM;
  require Timer;

  if (Timer->isXdays("hostInfo", 1) || !$h->{hostid}) {
    $h->{hostid}   = System->hostid();
    $h->{hostinfo} = System->hostinfo();
    $h->{hostname} = System->hostname();
    $h->{os}       = System->os();
    $h->{os_version} = System->os_version();
    $h->{model}    = System->model();
    $h->{swap}     = System->swap();
    $h->{memory}   = System->memory();
    $h->{domain}   = System->domain();
    $h->{cpus}     = System->cpus();
    $h->{ip}       = Util->name2ip($h->{hostname} );
    $h->{tz}       = CIM->tz();
  }
  return $h;
}



#
# find details about a wwn from OLD_REPORTS

sub wwnInfo {
  my($class, $wwn) = @_;
  my($report, $details, $l, $VAR1);

  my($grepf) = System->get_home() . "/DATA/tmp/WWNINFO";
  my($dir)   = System->get_home() . "/DATA/OLD_REPORTS";

  if (!$WWNINFO) {
     chdir(System->get_home() . "/DATA/OLD_REPORTS/");
     open(O, "/usr/bin/grep -i wwn *:*|");
     open(W, ">$grepf");
     while ($l = <O>) {
       print W $l;
     }
     close(O);
     close(W);
     $WWNINFO= 1;
  }
  open(O, $grepf);
  my(@a);
  while ($l = <O>) {
     if ($l =~ /$wwn/i) {
       @a = split(/:/, $l);
       next if (index("host,mcdata,backup,brocade,switch2,", $a[0]) >= 0);
       $report = "$a[0]:$a[1]";
       my $ix = index($l, "=>");
       my $st = length($report);
       if ($ix > $st) {
         $details = Util->ltrim(substr($l, $st+1, $ix - $st - 1));
         $details =~ s/\.portWWN//;
         $details =~ s/\.volWWN//;
       }
       last;
     }
  }
  close(O);
  if ($report) {
     if (open(O, "$dir/$report")) {
       my @b = <O>; close(O);
       eval "@b";
       if ($VAR1) {
         return ($VAR1->category(), $VAR1->name(), $details, $report);
       }
     } else {
         my($a,$b) = split(/\:/, $report);
         return ($a, $b, $details, $report);
     }
  }
  return ();
}




#############################################################
#       READK_LOG_FILE
#############################################################

%LOGFILES = ();

# flag = NEW : new lines since last run
#        24  : lines written in the ast 24 hours.
#
# << Oct092000_16:31:20 >>
# Oct 11 14:52:05
#
  
sub read_log_file {
  my($agent, $file, $flag, $is24) = @_;
  my(@lines, $startdate, $seek, $size, $tell, $size0, $clear_seek);
  return ('',[]) if (!$file);
  require PDM;
  my($cache) = PDM->getCacheHandle("read_log_file");

  if ($LOGFILES{$file}) {
    return ('', $LOGFILES{$file});
  }

  if (!(-r $file && -f $file)) {
    $LOGFILES{$file} = [];
    return ("CANNOT_READ $file", []);
  }

  my $today = Util->today;
  if ($cache->{START}{$file}) {
      $startdate = $cache->{START}{$file};
  } else {
      $startdate= substr($today,0,5) . " 00:00:00";
  }
  
  Debug->print2("READING_MESSAGE_FILE: $file");

  open(FILE_F1, $file); 
  my $cnt=0;
  $seek = $cache->{SEEK}{$file};

  if ($flag eq "NEW") {    # find new stuff.
    $size = (stat($file))[7];
    if ($seek) {
      if ($seek < $size) {
         seek(FILE_F1, $seek, 0);

      } elsif ($seek == $size) {
         close(FILE_F1);
         $LOGFILES{$file} = [];
         return ('',[]);     # found nothing

      } elsif (-f "$file.0") {
         $size0 = (stat("$file.0"))[7];
         if ($size0 > $seek) {  # do this one also
            open(FILE_F1, "$file.0"); 
            seek(FILE_F1, $seek, 0);
            $clear_seek = 1;
         }
      }
    }         
  }
  my($line, $current);
  my $count;
  for ($tell = tell(FILE_F1); $line = <FILE_F1>; $tell = tell(FILE_F1)) { 
      chop($line);
      last if ($line eq "exit"); # for tests only

      if (substr($line,0,1) eq "\t") {
         $lines[$#lines] .= substr($line,1) if ($#lines >= 0);
         next;
      }
      my @a = split(/ +/, $line,6);
      if ($a[0] =~ /^\d\d\d\d\-\d\d\-\d\d/) {
        $current = substr($a[0],5) . " " . $a[1];

      } elsif ($a[0] eq "<<") {
        $current = sprintf("%2.2d-%2.2d %s", Util->MTH(substr($a[1],0,3)), 
                       substr($a[1],3,2), substr($a[1],10) );
      } else {
        $current = sprintf("%2.2d-%2.2d %s", Util->MTH($a[0]), $a[1], $a[2]);
      }

      next if (substr($current,0,5) gt substr($today,0,5)); # if too big, probably the wrong year.
      if ($flag eq "NEW" &&  $current ge $startdate) {
         push(@lines, $line);
         last if ($count++ > 7000);
      }
      if ($flag eq "24") {
        if ($is24 && $current ge $is24 ) { # find 24 hours for thresholds
          push(@lines , $line);
          last if ($count++ > 7000);
        }
      }
  }
  Debug->print2("Found $count lines") if ($count > 0);
  if ($clear_seek) {
    $cache->{SEEK}{$file} = 0;
  } elsif ($tell && $tell != $seek) {
    $cache->{SEEK}{$file} = $tell;
  }
  close(FILE_F1);
  $LOGFILES{$file} = \@lines;  # save for next request.
  $cache->{START}{$file} = $current; # move pointer to end of file.

  return ('', \@lines);
}

# sp monitor their devices, master monitor non-sp devices only.
#
sub NUresponsibleForDevice {
  my($class, $d, $masterLoc, $renv) = @_;

  if ($renv->{solution} eq "se") {
    return 0 if (!$d->isMineToMonitor());

  } elsif (!$masterLoc) {  #master
    return 0 if ($d->isInSolution());
  }

  return 1;
}


#
# select devices to monitor

sub deviceList {
  my($class) = @_;
  my(@LIST);
  my(@a) = split(/=/, $class);
  
  my $prefix = lc($a[0]);
  $prefix = substr($prefix,7) ;

  my($devs) = System->get_configDevices();
  foreach my $d (@$devs) {
     next if ($d->{type} ne $prefix);
     next if (!Util->isMineToMonitor($d));
     push(@LIST, $d);
  }
  return @LIST;
}


sub get_pdm {
  my($class) = @_;

  return $class->{pdm};
}

sub reportHead {
  my($class, $id, $report, $cols, $errors) = @_;
  my ($name, $cat);
  $cols = 4 if (!$cols);

  if ($report) {
    $name = $report->name();
    $cat = $report->value('id.device_userLabel') || uc($report->category());

  }

  my $e1 = "<tr><td colspan=$cols>
      <font color=red><center>
        Errors during last report generation ($errors), data may be old.</td>" if ($errors);

  return "
   <table border=1 cellspacing=0 cellpadding=1 width=95% bgcolor=white>
     <tr><td bgcolor=$Style::DARK colspan=$cols>
          <font color=white><b>$cat $name</td>
     $e1
   ";
}
  

sub format_dev_info {
  my($device) = @_;
  my($info);
  if ($device->{serial}) {
     $info = "S" . $device->{serial};
  } else {
     $info = "N" . $device->{type} . "-" . $device->{_name} . "-" . $device->{name} . "-" . $device->{ip};
  }
  $info;
}

sub addIdentification {
  my($agent, $report) = @_;

  my($env) = System->get_renv();
  $report->{'location.customerNo'}   = $env->{cust_no};
  $report->{'location.customerName'} = $env->{customer};
  $report->{'location.contractNo'}   = $env->{contract};
  $report->{'location.hostId'}        = System->hostid;

  $report->{'location.siteName'}      = $env->{site_name};
  $report->{'location.siteAddress'}   = $env->{site_address};
  $report->{'location.siteCity'}      = $env->{site_city};
  $report->{'location.siteState'}     = $env->{site_state};
  $report->{'location.siteCountry'}   = $env->{site_country};
  $report->{'location.siteZip'}       = $env->{site_zip};
  $report->{'location.siteContact'}   = $env->{site_contact};
  $report->{'location.siteEmail'}     = $env->{site_email};
  $report->{'location.ticker'}        = $env->{ticker};
  $report->{'location.production'}    = $env->{production};

}




####################################################
#             DIFF
####################################################
sub get_category {
  my($agent) = @_;
  my($cat) = ref($agent);
  $cat =~ s/Agent//;
  return $cat;
}


# new: a string with \n in it
# returns: a pointer to an array of differences
# n=new, i=insert, d=delete, u=update
# flags : {xml => 1, ignorePattern=> "Temp,other", hash => 1, rawdata => 1, block => 1, 
#          xml_key=>}
# block : the content is compare as ablack, not line by line
# xml_key: xml key to help comparing the right lines
# DIFF saves the current values to TMP_DIFF
# Hash : Only report differences to entry with same hash value
#     needs 3 values Key | value | 0/1   0=bad, 1=good

sub diff_entry {
  my($agent, $type, $key, $value, $info, $error) = @_;
  return "<elem elem_type=\"$type\" key=\"$key\" value=\"$value\" info=\"$info\" error=\"$error\" />\n";
}



sub AUTOLOAD {
  my $self = shift;
  my $type = ref($self) || croak "$self is not an object";

  my $name = $AUTOLOAD;
  $name =~ s/.*://;   # strip fully-qualified portion

  unless (exists $_FIELDS{$name} ) {
   croak "Can't access `$name' field in class $type";
  }
  if (@_) {
     return $self->{$name} = shift;
  } else {
     return $self->{$name};
  }
}


sub found_pattern {
  my($list, $el) = @_;
  my($v);
  my(@a) = split(/,/, $list);
  foreach $v (@a) {
    if ($el =~ /$v/) {
print STDERR "     Ignoring $el in $list \n";
      return 1;
    }
  }
  return 0;
}




#########################################################################
#    CONFIG FILE UTILITIES
#########################################################################

#
# find the right devices in Config for a certain Agent module
# modules are called a5k, a35k, t3, switch, switch.brocade etc..
# types from configfile are
#
sub get_config_devices {
  my($agent) = @_;
  my($d, @results, $type);
  my($ag) = lc(ref($agent));
  $ag = substr($ag, 0, -5) if (substr($ag, -5) eq "agent");

  foreach $d (@{$agent->{devices}} ) {
#     next if ($d->{active} eq "N"); # active is set by the GUI start/stop monitoring
#     and it should only impact the emailing of events, not the monitoring.

     push(@results, $d) if (lc($d->{type}) eq $ag);
  }
  return \@results;
}

sub category_selected {
  my($agent,$cat) = @_;

  my($renv) = System->get_renv();
  my $list = lc($renv->{categories}) . "|message";
  $cat = substr($cat,0,-5) if (substr($cat,-5) eq "Agent");

  if (index("|$list|", lc("|$cat|")) >= 0) {
     return 1;
  } else {
     return 0;
  }
}



#/usr/sbin/osa/lad
#c1t5d0 1T80703654 LUNS: 0 1 2


# $ lad
# c2t5d0 1T93000132 LUNS: 0 1 
# c3t4d2 1T70211709 LUNS: 2
# $ rdacutil
#  A3500FC_array_1:   active/passive
#     Active    controller a (c2t5d0)               units:    0 1 2 
#     Failed    controller b (1T70211709)           units:    none

sub get_RM6Devices {
  my($q) = @_;
  my($type) = $q->{type};
  my(@out, $f, $l, $name, $hba, $in , $wwn, $x, $i, $path, $out, $out2, $err);
  my($details, $dev, $vendor, %A3, %WWN);

  require  Agent::A3500FC;
  my $DIR = Agent::A3500FC::find_raid();

  my $di = "$DIR/lad";

  ($err,$out) = Util->run_command($di, "luxprobe.txt", 20);

  return "ERR $err" if ($err);
  return "ERR @$out" if ("@$out" =~ /No RAID devices/);
  my %SER;
  for ($x=0; $x <= $#$out; $x++) {
    $l= $out->[$x];
    my(@a) = split(/\s+/, $l);
    $dev = $a[0]; $wwn = $a[1];

    my($di2) = "$DIR/raidutil -c $dev -i";

    ($err,$out2) = Util->run_command($di2, "luxprobe.txt", 20);
    my $label;
    foreach my $l (@$out2) {
        if ($l =~ /ProductID\s+(.*)/) {
           $label = $1;
           last;
        }
    }
    my($err,$rdac) = Util->run_command("$DIR/rdacutil -i $dev", "luxprobe.txt", 20);

    my(@b) = split(/\:\s+/, $rdac->[1]);
    my $enc_name = $b[0];
    if ($enc_name) {
       $A3{$enc_name}{dev} = $dev;
       if (exists($A3{$enc_name}{wwn1})) {
          $A3{$enc_name}{wwn2}  = $wwn;
       } else {
          $A3{$enc_name}{wwn1}  = $wwn;
          $A3{$enc_name}{label} = $label;
       }
    }
  }
  foreach my $k (keys %A3) {
     my $type = "a3500fc";
     $type = "a1000" if ($A3{$k}{label} =~ /A1000/);
     $f .= "$k=$A3{$k}{dev}=$A3{$k}{wwn1}=$A3{$k}{wwn2}=$type\n";
  }
  if ($q->{print}) {
    print "OK $f\n";
  } else {
    return "OK $f";
  }
}






   

1;
