package AdminGroup;
use System;
use strict;

sub new {
  my($class) = @_;

  my $var = Util->deserialize("admin_groups") || {};

  bless($var, 'AdminGroup');

  return $var;
}

sub save {
  my($class) = @_;

  Util->serialize("admin_groups", $class);
}

sub count {
  my($class) = @_;
  my $v = (keys %$class);
  return $v;
}

sub select {
  my($groups, $name ,$val, $default, $clear) = @_;

  my $groupsD =  "<select name=$name>";
  if ($default) {
    $groupsD .= "<option value=\"\">[ $default ]";
  }

  foreach my $g (sort keys %$groups) {
    my $sel = "selected" if ($g eq $val);
    $groupsD .= "<option $sel>$g";
  }
  if ($clear) {
    $groupsD .= "<option value=\"_CLEAR_\">Clear</option>";
  }
  $groupsD .= "</select>";

  return $groupsD;
}

sub list {
  my($group) = @_;
  my $l;
  foreach my $g (sort keys %$group) {
     $l .= "$g|";
  }
  chop($l) if ($l);
  return $l;
}


1;
