#
# Copyright 2001-2003 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
#ident   "@(#)Banner.pm 1.41     03/02/26 SMI"
#
# Banner-related methods

package Cluster::Banner;
use strict;
use POSIX;
use Cluster::Help;
use Cluster::RBAC;
use Cluster::Common;
use Sun::Solaris::Utils qw(gettext);
use vars qw(@ISA $VERSION);
$VERSION = '1.00';
@ISA = qw(Cluster::Common);

use constant TRUE  => 0;
use constant FALSE => 1;

# Create the rbac object
my $rbac = new Cluster::RBAC;

# Create the help object
my $help = new Cluster::Help;

#
# Class constructor
#

sub new {
	my $proto = shift;
	my $class = ref($proto) || $proto;
	my $self  = {};
	bless ($self, $class);
	return $self;
}

# 
# Print the Sun Web banner
#

sub print_banner($$) {
	my ($self, $q) = @_;

	# Define the general help link location
	my $basic_help_url = $help->get_basic_help_url($q);

	# Get the javascript code for context-help links
	my $help_function_jscript = $help->get_help_function_jscript($q);

	# fnx code embedded in banner
    	my $help_link_jscript = $help->get_help_link_jscript();

	# Get the hostname
	my $hostname = $self->get_hostname() . "." . $self->get_hostdomain();

	# Get the port 
	my $port = $self->get_http_port();

	# Get the mode
	my $mode = "";
	if (defined $q->param("mode")) {
		$mode = $q->param("mode");
	}

	# Print the html header
	print $q->header();

	# Reference to the 'masthead-background' class to support
	# different body definitions across the entire application
	print $q->start_html({ TITLE => gettext("SunPlex Manager Login"),
			       STYLE  => { 'src' => '/css/clustmgr-style.css'},
			       CLASS  => "masthead-background",
			       SCRIPT => $help_function_jscript,
			       onResize => "self.location.reload(true)",
			       LEFTMARGIN => 0,
			       TOPMARGIN => 0,
			       MARGINHEIGHT => 0,
			       MARGINWIDTH => 0
			       });

	# Start the form
	print $q->start_form();

	print $q->start_table({ WIDTH       => "100%",
			    BORDER      => 0,
			    CELLSPACING => 0,
			    CELLPADDING => 0
			    });

	# The only row in the main table: Sun Logo / nested table with the
	# remainder of the masthead
	print $q->start_Tr({ VALIGN => "top" });

	# Sun Logo
	print $q->start_td({ WIDTH => "1%" });

	print $q->img({ ALT => gettext("Sun Microsystems, Inc."),
		    BORDER => 0,
		    HEIGHT => 60,
		    WIDTH  => 118,
		    SRC    => "/images/banner5_fullcut.gif"
		    });

	print $q->end_td();

	#  Nested table with the majority of the content; cell widths are
	#  a kludge for Netscape 4
	print $q->start_td({ WIDTH => "99%" });
	# Print the applet if we're an installed cluster

	print $q->start_table({ WIDTH       => "100%",
				BORDER      => 0,
				CELLSPACING => 0,
				CELLPADDING => 0
				});	

	# 6 columns: 1-pixel white line / spacer column / Product logo /
	# spacer column / general links / spacer column
	print $q->start_Tr({ BGCOLOR => "#000000",
			     HEIGHT  => 25
			     });

	# Another kludge for Netscape 4: a 2-pixel gif with one white
	# (left) and one black (right) pixel
	print $q->start_td();

	print $q->img({ ALT => "",
			BORDER => 0,
			HEIGHT => 25,
			WIDTH  => 2,
			SRC    => "/images/white-black.gif"
			});

	print $q->end_td();
	print $q->start_td();

	print $q->img({ ALT => "",
			BORDER => 0,
			HEIGHT => 25,
			WIDTH  => 2,
			SRC    => "/images/dot.gif"
			});

	print $q->end_td();

	# Product logo
	print $q->start_td();
	my $locale = ($q->getlocale())[0];

	print $q->img({ ALT => gettext("SunPlex Manager"),
			BORDER => 0,
			HEIGHT => 25,
			WIDTH  => 156,
			SRC    => "/$locale/cm-banner-txt.gif"
			});

	print $q->end_td();
	print $q->start_td();

	print $q->img({ ALT => "",
			BORDER => 0,
			HEIGHT => 25,
			WIDTH  => 5,
			SRC    => "/images/dot.gif"
			});

	print $q->end_td();

	# For clustermode, print all links.
	# For installmode, print just logout link and user info.
	# General links: Up to six are permitted
	print $q->start_td({ ALIGN => "right" });

	if ($self->is_clustermode() == TRUE) {
    
	    # Refresh link
	    print $q->start_a({ CLASS   => "masthead-link-text",
				TITLE   => gettext("Click to refresh"),
				ALT     => gettext("Click to refresh"),
				ONCLICK => "top.content.location.reload(true);" .
					"top.menu.location.reload(true); return false; " .
					"top.banner.location.reload(true); return false; ",
				ONMOUSEOVER => "window.status='" . gettext("Refresh") . "'; return true",
				HREF    => "/cgi-bin/index.pl",
				TARGET  => "_top"
				});

	    print gettext("Refresh");
	    print $q->end_a();

	    # Divider
	    print $q->start_span({ CLASS => "masthead-link-divider" });
	    print "&nbsp;|&nbsp;";
	    print $q->end_span();

	}

	# Display logout link in either mode

	# Logout link
	print $q->start_a({ CLASS   => "masthead-link-text",
			    TITLE   => gettext("Click to log out"),
			    ALT     => gettext("Click to log out"),
			    ONMOUSEOVER => "window.status='" . gettext("Log Out") . "'; return true",
			    HREF    => "/cgi-bin/session/logout.pl",
			    TARGET  => "_top"
			    });
	print gettext("Log Out");
	print $q->end_a();

	if ($self->is_clustermode() == TRUE) {
    
	    # Divider
	    print $q->start_span({ CLASS => "masthead-link-divider" });
	    print "&nbsp;|&nbsp;";
	    print $q->end_span();

	    # Online Help link
	    print $q->start_a({ CLASS   => "masthead-link-text",
				TITLE   => gettext("Click to access Help"),
				ALT     => gettext("Click to access Help"),
				ONCLICK => "return " . $help_link_jscript,
				ONMOUSEOVER => "window.status='" . gettext("Help") . "'; return true",
				HREF    => $basic_help_url,
			});

	    print gettext("Help");
	    print $q->end_a();

	}

	# Display role info in either mode

	print $q->img({ ALT => "",
		    BORDER => 0,
		    HEIGHT => 16,
		    WIDTH  => 16,
		    SRC    => "/images/dot.gif"
		    });

	my ($r);

	$r = Apache->request();
	my ($user) = $r->connection()->user();

	if ($user =~ /\(/) { # Role contains parenthesis
	    print $q->img({ ALT => "Role Logged In",
			BORDER => 0,
			HEIGHT => 16,
			WIDTH  => 16,
			SRC    => "/images/admin_roles_16.gif"
			});
	} else {
	    print $q->img({ ALT => "User Logged In",
			BORDER => 0,
			HEIGHT => 16,
			WIDTH  => 16,
			SRC    => "/images/user_16.gif"
			});
	}
	print $q->start_span({ CLASS => "masthead-role-text" });
	print $user;
	print $q->end_span();
	print $q->end_td();

	print $q->start_td();

	print $q->img({ ALT => "",
		    BORDER => 0,
		    HEIGHT => 25,
		    WIDTH  => 5,
		    SRC    => "/images/dot.gif"
		    });

	print $q->end_td();
	print $q->end_Tr();

	# Thin white line separating the black top from the blue bottom
	print $q->start_Tr({ BGCOLOR => "#FFFFFF" });
	print $q->start_td();

	print $q->img({ ALT => "",
		    BORDER => 0,
		    HEIGHT => 1,
		    WIDTH  => 2,
		    SRC    => "/images/dot.gif"
		    });

	print $q->end_td();
	print $q->start_td({ COLSPAN => "5" });

	print $q->img({ ALT => "",
		    BORDER => 0,
		    HEIGHT => 1,
		    WIDTH  => 1,
		    SRC    => "/images/dot.gif"
		    });

	print $q->end_td();
	print $q->end_Tr();

	# Application specific row may typically include a global tool bar
	# on the left and status information on the right
	print $q->start_Tr({ BGCOLOR => "#666699",
			 HEIGHT  => 35 
			 });

	print $q->start_td();

	print $q->img({ ALT => "",
		    BORDER => 0,
		    HEIGHT => 35,
		    WIDTH  => 2,
		    SRC    => "/images/dot.gif"
		    });

	print $q->end_td();
	    print $q->start_td();
	    print $q->end_td();
	    print $q->start_td({ CLASS => "masthead-text" });
	    print "&nbsp;";
	    print $q->end_td();
	    print $q->start_td();
	    print $q->end_td();

	print $q->start_td({ CLASS => "masthead-text",
			     ALIGN => "right"
			     });

	# Only get the status if we're in cluster mode and we have
	# system read authorization.
	if ($self->is_clustermode() == TRUE &&
	    $rbac->check_auth($CL_AUTH_SYSTEM_READ)) {
		print $q->start_p({ CLASS => "cluster-status-text" });
		my ($cluster_state, $onlinenodelist) = 
			$self->get_cluster_state();
		print gettext("Cluster Status: ") . $cluster_state; 
		print $q->end_p();
	} else {
		print "&nbsp;";
	}

	print $q->end_td();
	print $q->start_td();
	print $q->end_td();
	print $q->end_Tr();
	print $q->end_table();

	# Nested table ends
	print $q->end_td();
	print $q->end_Tr();
	print $q->end_table();
	print $q->end_form();

	# Draw the applet at the bottom if we're installed and we have
	# system read authorization.
	if ($self->is_installed_cluster() == TRUE &&
	    $rbac->check_auth($CL_AUTH_SYSTEM_READ)) {

		print $q->applet({ codebase => '/',
				   code     => 'ClusterStatus.class',
				   width    => 1,
				   height   => 1,
				   NAME     => "statusApplet"
				   });
		
		print $q->Param({ name => 'hostname',
				  value => "$hostname"
				  });

		print $q->Param({ name => 'port',
				  value => "$port"
				  });
	
		# Register default event handlers
		if (defined($q->param('mode')) &&
			$q->param('mode') eq "events") {
		    print $q->Param({ name => 'event0',
				      value =>
	  "menu;ESC_cluster_rg_config_change,ESC_cluster_quorum_config_change;/cgi-bin/menu/menu.pl"
				  });
		}

		print $q->Param({ name => 'event1',
				  value =>
      "content;ESC_cluster_rg_config_change,ESC_cluster_cmm_reconfig;/cgi-bin/cluster/cluster_status.pl"
				  });

		print $q->end_applet();
	}

	# End the html
	print $q->end_html();
}

# 
# Print a simplified Sun Web banner for user & role login
#

sub print_login_banner($$$$) {
	my ($self, $q, $onload, $script) = @_;

	# Get the javascript code for context-help links
	my $help_function_jscript = $help->get_help_function_jscript($q);

	# Get the help mark mappings
	my $help_marker_mapping = $help->get_helpMarker_mapping();

	# Create the help javascript
	my $help_script = $help_marker_mapping .
		$help->get_help_function_jscript($q);

	# Print the html header
	print $q->header();

	# Reference to the 'masthead-background' class to support
	# different body definitions across the entire application
	print $q->start_html({ TITLE => gettext("SunPlex Manager Login"),
			       STYLE  => { 'src' => '/css/clustmgr-style.css'},
			       CLASS  => "default-body",
			       onResize => "self.location.reload(true)",
			       onLoad => $onload,
			       LEFTMARGIN => 0,
			       TOPMARGIN => 0,
			       MARGINHEIGHT => 0,
			       MARGINWIDTH => 0,
			       BACKGROUND => "#FFFFFF",
			       SCRIPT => $script . $help_script
			       });
	
	# Start the form
	print $q->start_form();

	print $q->start_table({ WIDTH   => "100%",
			    BORDER      => 0,
			    CELLSPACING => 0,
			    CELLPADDING => 0,
			    BGCOLOR     => "#666699"
			    });

	# The only row in the main table: Sun Logo / nested table with the
	# remainder of the masthead
	print $q->start_Tr({ VALIGN => "top" });

	# Sun Logo
	print $q->start_td({ WIDTH => "1%" });

	print $q->img({ ALT => gettext("Sun Microsystems, Inc."),
		    BORDER => 0,
		    HEIGHT => 60,
		    WIDTH  => 118,
		    SRC    => "/images/banner5_fullcut.gif"
		    });

	print $q->end_td();

	#  Nested table with the majority of the content; cell widths are
	#  a kludge for Netscape 4
	print $q->start_td({ WIDTH => "99%" });
	# Print the applet if we're an installed cluster

	print $q->start_table({ WIDTH       => "100%",
				BORDER      => 0,
				CELLSPACING => 0,
				CELLPADDING => 0
				});	

	# 6 columns: 1-pixel white line / spacer column / Product logo /
	# spacer column / general links / spacer column
	print $q->start_Tr({ BGCOLOR => "#000000",
			     HEIGHT  => 25
			     });

	# Another kludge for Netscape 4: a 2-pixel gif with one white
	# (left) and one black (right) pixel
	print $q->start_td();

	print $q->img({ ALT => "",
			BORDER => 0,
			HEIGHT => 25,
			WIDTH  => 2,
			SRC    => "/images/white-black.gif"
			});

	print $q->end_td();
	print $q->start_td();

	print $q->img({ ALT => "",
			BORDER => 0,
			HEIGHT => 25,
			WIDTH  => 2,
			SRC    => "/images/dot.gif"
			});

	print $q->end_td();

	# Product logo
	print $q->start_td();
	my $locale = ($q->getlocale())[0];

	print $q->img({ ALT => gettext("SunPlex Manager"),
			BORDER => 0,
			HEIGHT => 25,
			WIDTH  => 156,
			SRC    => "/$locale/cm-banner-txt.gif"
			});

	print $q->end_td();
	print $q->start_td();

	print $q->img({ ALT => "",
			BORDER => 0,
			HEIGHT => 25,
			WIDTH  => 5,
			SRC    => "/images/dot.gif"
			});

	print $q->end_td();

	# For clustermode, print all links.
	# For installmode, print just logout link and user info.
	# General links: Up to six are permitted
	print $q->start_td({ ALIGN => "right" });
	print "&nbsp;";
	print $q->end_td();

	print $q->start_td();

	print $q->img({ ALT => "",
		    BORDER => 0,
		    HEIGHT => 25,
		    WIDTH  => 5,
		    SRC    => "/images/dot.gif"
		    });

	print $q->end_td();
	print $q->end_Tr();

	# Thin white line separating the black top from the blue bottom
	print $q->start_Tr({ BGCOLOR => "#FFFFFF" });
	print $q->start_td();

	print $q->img({ ALT => "",
		    BORDER => 0,
		    HEIGHT => 1,
		    WIDTH  => 2,
		    SRC    => "/images/dot.gif"
		    });

	print $q->end_td();
	print $q->start_td({ COLSPAN => "5" });

	print $q->img({ ALT => "",
		    BORDER => 0,
		    HEIGHT => 1,
		    WIDTH  => 1,
		    SRC    => "/images/dot.gif"
		    });

	print $q->end_td();
	print $q->end_Tr();

	# Application specific row may typically include a global tool bar
	# on the left and status information on the right
	print $q->start_Tr({ BGCOLOR => "#666699",
			 HEIGHT  => 35 
			 });

	print $q->start_td();

	print $q->img({ ALT => "",
		    BORDER => 0,
		    HEIGHT => 35,
		    WIDTH  => 2,
		    SRC    => "/images/dot.gif"
		    });

	print $q->end_td();
	    print $q->start_td();
	    print $q->end_td();
	    print $q->start_td({ CLASS => "masthead-text" });
	    print "&nbsp;";
	    print $q->end_td();
	    print $q->start_td();
	    print $q->end_td();

	print $q->start_td({ CLASS => "masthead-text",
			     ALIGN => "right"
			     });

	print "&nbsp;";

	print $q->end_td();
	print $q->start_td();
	print $q->end_td();
	print $q->end_Tr();
	print $q->end_table();

	# Nested table ends
	print $q->end_td();
	print $q->end_Tr();
	print $q->end_table();
	print $q->end_form();

	# End the html
	print $q->end_html();
}
