#!/usr/bin/perl -w
#
# Copyright 2001-2003 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
#ident   "@(#)transport_config.pl 1.10     03/02/26 SMI"
#
# transport_config.pl -- Generate Sun Cluster transport config page
#

require 5.005;
use strict;
use lib '/opt/SUNWscvw/lib/perl';
use Cluster::Cgi;
use Cluster::Common;
use Cluster::Menu;
use Cluster::RBAC;
use Cluster::Transport;
use Sun::Solaris::Utils qw(gettext);

# Create the html query object
my $q = new Cluster::Cgi;

# Create a transport object
my $transport = new Cluster::Transport;

# Create the rbac object
my $rbac = new Cluster::RBAC;

my $name = $q->param('name');
my $type = $q->param('type');
my $func = $q->param('func');
my $step = $q->param('step');

# Set the page title
my $title = gettext("Configure Transport");

# Check if in Cluster mode
if ($transport->is_clustermode($q) != 0) {
        # not in cluster mode
        $transport->print_nonclustermode_error($q);
        exit;
}

print $q->header();

my $menu_jscript = $q->jump_menu_jscript();
my $transport_jscript = $transport->transport_jscript();
my $jscript = $menu_jscript . "\n" . $transport_jscript .
    $q->yoke_jscript("t");

# Start the document
print $q->start_html({  TITLE  => $title,
			STYLE  => { 'src' => '/css/clustmgr-style.css'},
                        CLASS  => "default-body",
                        SCRIPT => $jscript
                        });

# Check for transport modify or admin authorization
if ((($func eq "Add" || $func eq "Remove") && 
    !$rbac->check_auth($CL_AUTH_TRANSPORT_MODIFY)) || 
    (($func eq "Enable" || $func eq "Disable") && 
     !$rbac->check_auth($CL_AUTH_TRANSPORT_ADMIN))) {
	$rbac->auth_error($q, $title);
	exit;
}

# Read the configuration and status into memory if needed
$transport->get_commandoutput();

if (defined $step && $step == 1) {
	# If this is the first step, display a list of items for user to choose
	SWITCH: {
		if ($type eq "Adapter") {
			$transport->display_adapterlist($q, $func, $name);
			last SWITCH;
		}
		if ($type eq "Junction") {
			$transport->display_junctionlist($q, $func, $name);
			last SWITCH;
		}
		if ($type eq "Cable") {
			$transport->display_cablelist($q, $func);
			last SWITCH;
		}
	}
	goto DONE;
}	 
	
SWITCH: {
	if ($func eq "Add") {
		$transport->config_add($q, $type, $name);
		last SWITCH;
	} 
	if ($func eq "Remove") {
		$transport->config_remove($q, $type, $name);
		last SWITCH;
	}
	if ($func eq "Disable") {
		$transport->config_changestate($q, $type, $name, $func);
		last SWITCH;
	}
	if ($func eq "Enable") {
		$transport->config_changestate($q, $type, $name, $func);
		last SWITCH;
	}
}

# End the html document
DONE: $transport->footer($q);
