#!/usr/perl5/bin/perl -w
#
# Copyright 2003 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
#ident	"@(#)role.pl	1.1	03/02/26 SMI"
#
# Login page for user roles
#

require 5.005;
use strict;
use lib '/opt/SUNWscvw/lib/perl';
use Cluster::Cgi;
use Cluster::RBAC;
use Cluster::Banner;
use Sun::Solaris::Utils qw(gettext);

# Create the needed objects
my $q = new Cluster::Cgi;
my $rbac = new Cluster::RBAC;
my $banner = new Cluster::Banner;

# Get the apache request object
my $r = Apache->request;

# Get the final destination
my $destination = $q->param("destination");

# Get the user
my (@entry) = &Cluster::CookieStorage::get_cookie(
		  $r->prev->subprocess_env("AuthCookie"));
my $user = $entry[0];

# Get roles associated with the user
my (@roles, %labels);
push (@roles, "NULL", $rbac->get_roles($user));

# Make the first label "No role"
$labels{'NULL'} = gettext("No role");

# Create the labels hash with the rest of the values
for (my $i=1; $i <= $#roles; $i++) {
	$labels{$roles[$i]} = $roles[$i];
}

# Set labels
my $roletext = gettext("If you log in as a role, you relinquish your " .
                  "own user account properties and assume all " .
                  "properties of that role. To log in as yourself, " .
                  "choose \"No Role\" and press Return.");
my $userlabel = gettext("User Name:");
my $rolelabel = gettext("Role Name:");
my $rolepassword = gettext("Role Password:");
my $login = gettext("&nbsp;Log In&nbsp;");

# Set the error text
my $text = "";
if (defined($r->prev->subprocess_env("AuthCookieReason"))) {
    if ($r->prev->subprocess_env("AuthCookieReason") eq "bad_cookie" ||
	$r->prev->subprocess_env("AuthCookieReason") eq "bad_credentials") {
	if ($r->prev->subprocess_env("AuthInfo") eq "role_authentication") {
	    $text = $q->login_alert(gettext("Role Authentication Failed"),
		gettext("Select a role and enter the role password."));
	} elsif ($r->prev->subprocess_env("AuthInfo") eq
		 "role_authorization") {
	    $text = $q->login_alert(gettext("Role Authorization Failed"),
		gettext("Select a role and enter the role password."));
	}
    }
}

# Print the banner
$banner->print_login_banner($q, "document.Role.credential_3.focus();");
print $q->start_form({ NAME   => "Role",
		       METHOD => "post",
		       ACTION => "/ROLE"
		       });

# Start the table for layout of images and form fields
print $q->start_table({ BORDER => 0,
			CELLSPACING => 0,
			CELLPADDING => 0
			});

# Print the warning text
if ($text ne "") {
	print $text;
}

# Spacer
print $q->start_Tr();
print $q->start_td({ COLSPAN => 4 });
print $q->img({ SRC    => "/images/dot.gif",
		ALT    => " ",
		HEIGHT => 10,
		BORDER => 0
		});
print $q->end_td();
print $q->end_Tr();

# Begin inline help
print $q->start_Tr();
print $q->start_td({ COLSPAN => 2 });
print $q->img({ SRC    => "/images/dot.gif",
		ALT    => " ",
		HEIGHT => 20,
		BORDER => 0
		});
print $q->end_td();
print $q->start_td();
print $q->start_div({ CLASS => "help-text" });
print $roletext;
print $q->end_div();
print $q->end_td();
print $q->end_Tr();
print $q->start_Tr();
print $q->start_td({ COLSPAN => 4 });
print $q->img({ SRC    => "/images/dot.gif",
		ALT    => " ",
		HEIGHT => 10,
		BORDER => 0
		});
print $q->end_td();
print $q->end_Tr();

# Login form fields
print $q->start_Tr();
print $q->start_td({ COLSPAN => 2 });
print $q->img({ SRC    => "/images/dot.gif",
		ALT    => " ",
		BORDER => 0
		});
print $q->end_td();
print $q->start_td();
print $q->start_table({ BORDER => 0,
			CELLSPACING => 0,
			CELLPADDING => 0
			});

# Begin user prompt
print $q->start_Tr();
print $q->start_td({ WIDTH => 115 });
print $userlabel;
print $q->end_td();
print $q->start_td();
print $q->img({ SRC    => "/images/dot.gif",
		ALT    => " ",
		HEIGHT => 10,
		BORDER => 0
		});
print $q->end_td();
print $q->start_td();
print $user;
print $q->end_td();
print $q->end_Tr();
print $q->start_Tr();
print $q->start_td({ COLSPAN => 3 });
print $q->img({ SRC    => "/images/dot.gif",
		ALT    => " ",
		HEIGHT => 1,
		BORDER => 0
		});
print $q->end_td();
print $q->end_Tr();

# Begin role selection
print $q->start_Tr();
print $q->start_td({ WIDTH => 115 });
print $rolelabel;
print $q->end_td();
print $q->start_td();
print $q->img({ SRC    => "/images/dot.gif",
		ALT    => " ",
		HEIGHT => 10,
		BORDER => 0
		});
print $q->end_td();
print $q->start_td();
print $q->popup_menu({ NAME     => "credential_2",
		       VALUES   => \@roles,
		       LABELS   => \%labels
		       });
print $q->end_td();
print $q->end_Tr();
print $q->start_Tr();
print $q->start_td({ COLSPAN => 3 });
print $q->img({ SRC    => "/images/dot.gif",
		ALT    => " ",
		HEIGHT => 1,
		BORDER => 0
		});
print $q->end_td();
print $q->end_Tr();
print $q->end_table();
print $q->end_td();
print $q->start_td();
print $q->img({ SRC    => "/images/dot.gif",
		ALT    => " ",
		HEIGHT => 10,
		BORDER => 0
		});
print $q->end_td();
print $q->end_Tr();
print $q->start_Tr();
print $q->start_td();
print $q->img({ SRC    => "/images/dot.gif",
		ALT    => " ",
		WIDTH  => 40,
		HEIGHT => 1,
		BORDER => 0
		});
print $q->end_td();
print $q->start_td();
print $q->img({ SRC    => "/images/dot.gif",
		ALT    => " ",
		WIDTH  => 50,
		HEIGHT => 1,
		BORDER => 0
		});
print $q->end_td();
print $q->start_td();
print $q->img({ SRC    => "/images/dot.gif",
		ALT    => " ",
		WIDTH  => "100%",
		HEIGHT => 1,
		BORDER => 0
		});
print $q->end_td();
print $q->start_td();
print $q->img({ SRC    => "/images/dot.gif",
		ALT    => " ",
		WIDTH  => 10,
		HEIGHT => 1,
		BORDER => 0
		});
print $q->end_td();
print $q->end_Tr();

# Begin login form fields
print $q->start_Tr();
print $q->start_td({ COLSPAN => 2 });
print $q->img({ SRC    => "/images/dot.gif",
		ALT    => " ",
		BORDER => 0
		});
print $q->end_td();
print $q->start_td();
print $q->start_table({ BORDER => 0,
			CELLSPACING => 0,
			CELLPADDING => 0
			});

# Begin password prompt
print $q->start_Tr();
print $q->start_td({ WIDTH => 115,
		     NOWRAP => 1
		     });
print $rolepassword;
print $q->end_td();
print $q->start_td();
print $q->img({ SRC    => "/images/dot.gif",
		ALT    => " ",
		WIDTH  => 10
		});
print $q->end_td();
print $q->start_td({ ALIGN => "right" });
print $q->input({ TYPE => "password",
		  NAME => "credential_3",
		  VALUE => ""
		  });
print $q->end_td();
print $q->end_Tr();
print $q->start_Tr();
print $q->start_td({ COLSPAN => 3 });
print $q->img({ SRC    => "/images/dot.gif",
		ALT    => " ",
		HEIGHT => 10,
		BORDER => 0
		});
print $q->end_td();
print $q->end_Tr();

# Submit button row
print $q->start_Tr();
print $q->start_td({ COLSPAN => 3,
		     ALIGN => "right"
		     });

# Print submit button
$q->html_button("/ROLE", $login, "document.Role.submit();return false;");

print $q->end_td();
print $q->end_Tr();

# End login form fields
print $q->start_Tr();
print $q->start_td({ COLSPAN => 3 });
print $q->img({ SRC    => "/images/dot.gif",
		ALT    => " ",
		HEIGHT => 10,
		BORDER => 0
		});
print $q->end_td();
print $q->end_Tr();
print $q->end_table();
print $q->end_td();
print $q->start_td();
print $q->img({ SRC    => "/images/dot.gif",
		ALT    => " ",
		BORDER => 0
		});
print $q->end_td();
print $q->end_Tr();

# Spacer
print $q->start_Tr();
print $q->start_td({ COLSPAN => 4 });
print $q->img({ SRC    => "/images/dot.gif",
		ALT    => " ",
		HEIGHT => 20,
		BORDER => 0
		});
print $q->end_td();
print $q->end_Tr();
print $q->end_table();

# Hidden destination field
print $q->input({ TYPE => "hidden",
		  NAME => "destination",
		  VALUE => $destination
		  });

# End the submit form
print $q->end_form();

# End the page
print $q->end_html();
