#!/usr/perl5/bin/perl -w
#
# Copyright 2001-2003 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
#ident	"@(#)rg_config.pl	1.20	03/02/26 SMI"
#
# Configure resource groups

require 5.005;
use strict;
use lib '/opt/SUNWscvw/lib/perl';
use Cluster::Rg;
use Cluster::Cgi;
use Cluster::RBAC;
use Cluster::RunCommand;
use Cluster::common;
use Cluster::scrgcommon;
use Sun::Solaris::Utils qw(gettext);

# Create the html query object
my $q = new Cluster::Cgi;

# Create a rg object
my $rg_obj = new Cluster::Rg;
my $rbac = new Cluster::RBAC;
my $run = new Cluster::RunCommand;

# Get the parameters
my $rg = $q->param("rg");
my $func = $q->param("func");

$Cluster::common::cmd_save = "";
$Cluster::common::result = "";

my $CONFIG = "/cgi-bin/rg/rg_config.pl";

my $jscript = $q->jump_menu_jscript() . "\n" .
    "\tfunction rg_submit() {\n" .
    "\t\tself.location.href = '/cgi-bin/rg/scstat.pl?rg=' + document.inputs.rg_name.options[document.inputs.rg_name.selectedIndex].value + " .
    "'&node=' +document.inputs.node.options[document.inputs.node.selectedIndex].value\n" .
    "}";

# Check for device modify or admin authorization
if ((($func eq "delete" ||
      $func eq "editrg" ||
      $func eq "edit" ||
      $func eq "weights" ||
      $func eq "deleters") &&
     !$rbac->check_auth($CL_AUTH_RESOURCE_MODIFY)) ||
    (($func eq "online" ||
      $func eq "offline" ||
      $func eq "restart" ||
      $func eq "manage" ||
      $func eq "unmanage" ||
      $func eq "enable" ||
      $func eq "disable" ||
      $func eq "enable_mon" ||
      $func eq "disable_mon" ||
      $func eq "clear") &&
     !$rbac->check_auth($CL_AUTH_RESOURCE_ADMIN))) {
	$rbac->auth_error($q, gettext("Resource Groups"));
	exit;
}

# Delete the rg
if ($q->param('func') eq "delete") {
    # Start the html document
    $rg_obj->header($q, [gettext("Resource Groups"), "/cgi-bin/rg/rg_view.pl",
	gettext("Delete Resource Group")], "rg");
    print $q->start_form({ ACTION => "/cgi-bin/rg/scstat.pl",
			   METHOD => "POST"
			   });
    print $q->hidden({ NAME => "cmd_rgrs_delete", VALUE => 1});
    my @rgs = $rg_obj->get_rglist();
    if ($#rgs < 0) {
	$rg_obj->need_rg($q);
    } else {
	$rg_obj->select_rg($q, \@rgs);
	$rg_obj->action_table_line($q);
	$rg_obj->warning($q, gettext("This action will permanently delete " .
	    "the selected resource group and all of the resources it " .
	    "contains."));
	$rg_obj->submit_button($q, gettext(" Delete Resource Group "),
	    "cancel");
    }
    print $q->end_form();

# Online rg
} elsif ($q->param('func') eq "online") {
    # Start the html document

    $rg_obj->header($q, [gettext("Resource Groups"), "/cgi-bin/rg/rg_view.pl",
	gettext("Bring Group Online")], "rg", $jscript);
    print $q->start_form({ ACTION => "/cgi-bin/rg/scstat.pl",
			   NAME   => "inputs",
			   METHOD => "GET"
			   });
    print $q->hidden({ NAME => "cmd_rgprim", VALUE => 1});
    my @rgs = $rg_obj->get_rglist();
    if ($#rgs < 0) {
	$rg_obj->need_rg($q);
    } else {
	$rg_obj->select_rg($q, \@rgs, "$CONFIG\?func=online\&rg=");

	if (! defined($q->param('rg'))) {
	    # Set a default value
	    $q->param('rg', $rgs[0]);
	}
	&getrgprops($q->param('rg'));
	print $q->hidden({NAME => "rg"});

	&primary_selector($rg_obj, $q, gettext("New Primary:"),
	    gettext("New Primaries:"),
	    gettext(" Bring Online / Set Primary "),
	    gettext(" Bring Online / Set Primaries "));
	print $q->end_table();
    }
    print $q->end_form();

    # Offline rg
} elsif ($q->param('func') eq "offline") {
    # Start the html document
    $rg_obj->header($q, [gettext("Resource Groups"), "/cgi-bin/rg/rg_view.pl",
	gettext("Take Group Offline")], "rg");
    print $q->start_form({ ACTION => "/cgi-bin/rg/scstat.pl",
			   METHOD => "POST"
			   });
    print $q->hidden({ NAME => "cmd_rgoffline", VALUE => 1});
    my @rgs = $rg_obj->get_rglist();
    if ($#rgs < 0) {
	$rg_obj->need_rg($q);
    } else {
	$rg_obj->select_rg($q, \@rgs);

	$rg_obj->action_table_line($q);
	$rg_obj->warning($q, gettext("This action will take the selected " .
	    "resource group and all of the resources it contains offline " .
	    "on all nodes."));
	$rg_obj->submit_button($q, gettext(" Take Resource Group Offline "),
	    "cancel");
    }
    print $q->end_form();

# Restart rg
} elsif ($q->param('func') eq "restart") {
    # Start the html document
    $rg_obj->header($q, [gettext("Resource Groups"), "/cgi-bin/rg/rg_view.pl",
	gettext("Restart Resource Group")], "rg", $jscript);
    print $q->start_form({ ACTION => "/cgi-bin/rg/scstat.pl",
			   NAME   => "inputs",
			   METHOD => "GET"
			   });
    print $q->hidden({ NAME => "cmd_rgrestart", VALUE => 1});
    my @rgs = $rg_obj->get_rglist();
    if ($#rgs < 0) {
	$rg_obj->need_rg($q);
    } else {
	$rg_obj->select_rg($q, \@rgs, "$CONFIG\?func=restart\&rg=");

	if (! defined($q->param('rg'))) {
	    # Set a default value
	    $q->param('rg', $rgs[0]);
	}
	&getrgprops($q->param('rg'));
	print $q->hidden({NAME => "rg"});

	&primary_selector($rg_obj, $q, gettext("Primary:"), 
	    gettext("Primaries:"));
	print $q->end_table();

	$rg_obj->action_table_line($q);
	$rg_obj->warning($q, gettext("This action will take the selected " .
	    "resource group and all of the resources it contains offline " .
	    "and then back online.  The selected node(s) must be current " .
	    "primaries."));
	$rg_obj->submit_button($q, gettext(" Restart Resource Group "),
	    "jump");
    }
    print $q->end_form();
# Manage rg
} elsif ($q->param('func') eq "manage") {
    # Start the html document
    $rg_obj->header($q, [gettext("Resource Groups"), "/cgi-bin/rg/rg_view.pl",
	gettext("Put Group into Managed State")], "rg");
    print $q->start_form({ ACTION => "/cgi-bin/rg/scstat.pl",
			   METHOD => "POST"
			   });
    print $q->hidden({ NAME => "cmd_rgmanage", VALUE => 1});
    my @rgs = $rg_obj->get_rglist();
    if ($#rgs < 0) {
	$rg_obj->need_rg($q);
    } else {
	$rg_obj->select_rg($q, \@rgs);

	$rg_obj->submit_button($q, gettext(" Manage Resource Group "),
	    "cancel");
    }
    print $q->end_form();

# Unmanage rg
} elsif ($q->param('func') eq "unmanage") {
    # Start the html document
    $rg_obj->header($q, [gettext("Resource Groups"), "/cgi-bin/rg/rg_view.pl",
	gettext("Put Group into Unmanaged State")], "rg");
    print $q->start_form({ ACTION => "/cgi-bin/rg/scstat.pl",
			   METHOD => "POST"
			   });
    print $q->hidden({ NAME => "cmd_rgunmanage", VALUE => 1});
    my @rgs = $rg_obj->get_rglist();
    if ($#rgs < 0) {
	$rg_obj->need_rg($q);
    } else {
	$rg_obj->select_rg($q, \@rgs);

	$rg_obj->action_table_line($q);
	$rg_obj->warning($q, gettext("This action will put the selected " .
	    "resource group into an unmanaged state on all nodes."));

	$rg_obj->submit_button($q, gettext(" Unmanage Resource Group "),
	    "cancel");
    }
    print $q->end_form();

# Edit rg properties
} elsif ($q->param('func') eq "editrg") {
    # Start the html document

    $rg_obj->header($q, [gettext("Resource Groups"), "/cgi-bin/rg/rg_view.pl",
	gettext("Modify Group Properties")], "rg", $jscript);
    print $q->start_form({ ACTION => "/cgi-bin/rg/rg_add.pl",
			   NAME   => "inputs",
			   METHOD => "GET"
			   });
    print $q->hidden({ NAME => "edit", VALUE => 1});
    my @rgs = $rg_obj->get_rglist();
    if ($#rgs < 0) {
	$rg_obj->need_rg($q);
    } else {
	$rg_obj->select_rg($q, \@rgs);

	$rg_obj->submit_button($q, gettext(" Next "),
	    "cancel");
    }
    print $q->end_form();

#enable rs
} elsif ($q->param('func') eq "enable") {
    # Start the html document
    $rg_obj->header($q, [gettext("Resource Groups"), "/cgi-bin/rg/rg_view.pl",
	gettext("Enable Resource")], "rg");
    print $q->start_form({ ACTION => "/cgi-bin/rg/scstat.pl",
			   METHOD => "POST"
			   });
    print $q->hidden({ NAME => "cmd_rsenable", VALUE => 1});

    my ($rsnames, $rslabels) = $rg_obj->get_rslists($q);
    if ($#{@{$rsnames}} < 0) {
	$rg_obj->need_rs($q);
    } else {
	$rg_obj->select_rs($q, $rsnames, $rslabels);

	$rg_obj->submit_button($q, gettext(" Enable Resource "),
	    "cancel");
    }
    print $q->end_form();

#disable rs
} elsif ($q->param('func') eq "disable") {
    # Start the html document
    $rg_obj->header($q, [gettext("Resource Groups"), "/cgi-bin/rg/rg_view.pl",
	gettext("Disable Resource")], "rg");
    print $q->start_form({ ACTION => "/cgi-bin/rg/scstat.pl",
			   METHOD => "POST"
			   });
    print $q->hidden({ NAME => "cmd_rsdisable", VALUE => 1});
    my ($rsnames, $rslabels) = $rg_obj->get_rslists($q);
    if ($#{@{$rsnames}} < 0) {
	$rg_obj->need_rs($q);
    } else {
	$rg_obj->select_rs($q, $rsnames, $rslabels);

	$rg_obj->action_table_line($q);
	$rg_obj->warning($q, gettext("This action will put the selected " .
	    "resource into a disabled state."));

	$rg_obj->submit_button($q, gettext(" Disable Resource "),
	    "cancel");
	}
    print $q->end_form();

#enable rs monitor
} elsif ($q->param('func') eq "enable_mon") {
    # Start the html document
    $rg_obj->header($q, [gettext("Resource Groups"), "/cgi-bin/rg/rg_view.pl",
	gettext("Enable Resource Monitor")], "rg");
    print $q->start_form({ ACTION => "/cgi-bin/rg/scstat.pl",
			   METHOD => "POST"
			   });
    print $q->hidden({ NAME => "cmd_rsmenable", VALUE => 1});
    my ($rsnames, $rslabels) = $rg_obj->get_rslists($q);
    if ($#{@{$rsnames}} < 0) {
	$rg_obj->need_rs($q);
    } else {
	$rg_obj->select_rs($q, $rsnames, $rslabels);

	$rg_obj->submit_button($q, gettext(" Enable Resource Monitor"),
	    "cancel");
    }
    print $q->end_form();

#disable rs
} elsif ($q->param('func') eq "disable_mon") {
    # Start the html document
    $rg_obj->header($q, [gettext("Resource Groups"), "/cgi-bin/rg/rg_view.pl",
	gettext("Disable Resource Monitor")], "rg");
    print $q->start_form({ ACTION => "/cgi-bin/rg/scstat.pl",
			   METHOD => "POST"
			   });
    print $q->hidden({ NAME => "cmd_rsmdisable", VALUE => 1});
    my ($rsnames, $rslabels) = $rg_obj->get_rslists($q);
    if ($#{@{$rsnames}} < 0) {
	$rg_obj->need_rs($q);
    } else {
	$rg_obj->select_rs($q, $rsnames, $rslabels);

	$rg_obj->action_table_line($q);
	$rg_obj->warning($q, gettext("This action will disable the " .
	    "monitor for the selected resource."));

	$rg_obj->submit_button($q, gettext(" Disable Resource Monitor"),
	    "cancel");
    }
    print $q->end_form();

#edit rs
} elsif ($q->param('func') eq "edit") {
    # Start the html document
    $rg_obj->header($q, [gettext("Resource Groups"), "/cgi-bin/rg/rg_view.pl",
	gettext("Modify Resource Properties")], "rg");
    print $q->start_form({ ACTION => "/cgi-bin/rg/scstat.pl",
			   METHOD => "POST"
			   });
    print $q->hidden({ NAME => "cmd_rsmodify", VALUE => 1});
    my ($rsnames, $rslabels) = $rg_obj->get_rslists($q);
    if ($#{@{$rsnames}} < 0) {
	$rg_obj->need_rs($q);
    } else {
	$rg_obj->select_rs($q, $rsnames, $rslabels);

	$rg_obj->submit_button($q, gettext(" Next > "),
	    "cancel");
    }
    print $q->end_form();

#modify weights
} elsif ($q->param('func') eq "weights") {
    # Start the html document
    $rg_obj->header($q, [gettext("Resource Groups"), "/cgi-bin/rg/rg_view.pl",
	gettext("Modify Load Balancing")], "rg");
    print $q->start_form({ ACTION => "/cgi-bin/rg/scstat.pl",
			   METHOD => "POST"
			   });
    print $q->hidden({ NAME => "cmd_rs_weights", VALUE => 1});
    my ($rsnames, $rslabels) = $rg_obj->get_rslists($q);
    if ($#{@{$rsnames}} < 0) {
	$rg_obj->need_rs($q);
    } else {
	$rg_obj->select_rs($q, $rsnames, $rslabels);

	$rg_obj->submit_button($q, gettext(" Modify Load Balancing "),
	    "cancel");
    }
    print $q->end_form();


#clear stop-failed
} elsif ($q->param('func') eq "clear") {
    # Start the html document
    $rg_obj->header($q, [gettext("Resource Groups"), "/cgi-bin/rg/rg_view.pl",
	gettext("Clear Stop-Failed Flag")], "rg");
    print $q->start_form({ ACTION => "/cgi-bin/rg/scstat.pl",
			   METHOD => "POST"
			   });
    print $q->hidden({ NAME => "cmd_rs_failed", VALUE => 1});
    my ($rsnames, $rslabels) = $rg_obj->get_rslists($q);
    if ($#{@{$rsnames}} < 0) {
	$rg_obj->need_rs($q);
    } else {
	$rg_obj->select_rs($q, $rsnames, $rslabels);

	$rg_obj->submit_button($q, gettext(" Clear Flag "),
	    "cancel");
    }
    print $q->end_form();

#delete rs
} elsif ($q->param('func') eq "deleters") {
    # Start the html document
    $rg_obj->header($q, [gettext("Resource Groups"), "/cgi-bin/rg/rg_view.pl",
	gettext("Delete Resource")], "rg");
    print $q->start_form({ ACTION => "/cgi-bin/rg/scstat.pl",
			   METHOD => "POST"
			   });
    print $q->hidden({ NAME => "cmd_rs_delete", VALUE => 1});
    my ($rsnames, $rslabels) = $rg_obj->get_rslists($q);
    if ($#{@{$rsnames}} < 0) {
	$rg_obj->need_rs($q);
    } else {
	$rg_obj->select_rs($q, $rsnames, $rslabels);

	$rg_obj->action_table_line($q);
	$rg_obj->warning($q, gettext("This action will permanently delete " .
	    "the selected resource."));

	$rg_obj->submit_button($q, gettext(" Delete Resource "),
	    "cancel");
    }
    print $q->end_form();

} else {
    $rg_obj->header($q, [gettext("Resource Groups"), "/cgi-bin/rg/rg_view.pl",
	gettext("Bad Operation")], "rg");
    print "<!-- ".$q->param('func')." -->\n";
    print $q->start_form({ ACTION => "/cgi-bin/rg/rg_config.pl",
			   METHOD => "POST"
			   });
    $rg_obj->warning($q, gettext("This operation is not supported."));
    $rg_obj->submit_button($q, "", "cancel");
}

# End the html document
$rg_obj->footer($q);

#
# Print primary selector
# &getrgprops must have been called prior to this.
# Display the appropriate message and button, depending on if the
# group is scalable or failover.
# If but1/but2 are defined, it will print the go/cancel button with that
# message.
#
sub primary_selector {
    my ($rg_obj, $q, $msg1, $msg2, $but1, $but2) = @_;
    my @nodes = split(/ /, $rgprops{"Nodelist"});
    if ($#nodes < 0) {
	@nodes = $rg_obj->get_nodelist();
    }

    if ($rgprops{"Maximum_primaries"} <= 1) {
	print $q->start_Tr(), $q->start_td({VALIGN => "top"});
	print $q->CGI::div({CLASS => "action-window-label-text"}, $msg1);
	print $q->end_td(), "\n";
	print $q->start_td();

	print $q->popup_menu({	NAME	=> "node",
				VALUES	=> \@nodes,
				    });
	print $q->end_td(), $q->end_Tr(), $q->end_table(), "\n";
	if (defined $but1) {
	    $rg_obj->submit_button($q, $but1, "jump");
	}
    } else {
        my @selectednodes;
	my $i;
	my $max_desired = $rgprops{"Desired_primaries"};
	for ($i = 0; $i <= $max_desired; $i++) {
	  $selectednodes[$i] = $nodes[$i];
	}
        # @selectednodes is used to pre-check as many nodes as are
	# specified by Desired_primaries. Don't wanna pre-check more
	# nodes than that, because this default state would be illegal

	print $q->start_Tr(), $q->start_td({VALIGN => "top"});
	print $q->CGI::div({CLASS => "action-window-label-text"}, $msg2);
	print $q->end_td(), "\n";
	print $q->start_td();

	print $q->checkbox_group({  NAME	=> "node",
				    VALUES	=> \@nodes,
				    LINEBREAK	=> 1,
				    DEFAULT	=> \@selectednodes,
				    });
	print $q->end_td(), $q->end_Tr(), $q->end_table(), "\n";
	if (defined $but2) {
	    $rg_obj->submit_button($q, $but2, "jump");
	}
    }
}
