#!/usr/perl5/bin/perl -w
#
# Copyright 2001-2003 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
#ident	"@(#)rg_add.pl	1.20	03/02/26 SMI"
#
# Present forms for adding/editing a resource group
#

require 5.005;
use strict;
use lib '/opt/SUNWscvw/lib/perl';
use Cluster::Rg;
use Cluster::Cgi;
use Cluster::RBAC;
use Cluster::common;
use Sun::Solaris::Utils qw(gettext);

# Create objects
my $q = new Cluster::Cgi;
my $rbac = new Cluster::RBAC;
my $rg_obj = new Cluster::Rg;

# Set the page title
my $title = gettext("Resource Groups");

# Check for resource modify authorization
if (!$rbac->check_auth($CL_AUTH_RESOURCE_MODIFY)) {
	print $q->start_html({ TITLE => $title,
			       STYLE  => { 'src' => '/css/clustmgr-style.css'},
			       CLASS  => "default-body"
			       });
	$rbac->auth_error($q, $title);
	exit;
}

# Get the nodelist
my @nodelist = $rg_obj->get_nodelist();

# Get the resource group list
my @rglist = $rg_obj->get_rglist();

if (defined($q->param('edit'))) {
    $rg_obj->header($q, [$title, "/cgi-bin/rg/rg_view.pl",
	    gettext("Modify Group Properties")], "rg");
    # Fill in rg's current properties into $q, modified appropriately
    my ($rg) = $q->param('rg');
    my ($props) = $rg_obj->get_rg_properties($rg);
    foreach my $name (keys %$props) {
	$q->param(lc($name), $props->{$name});
    }

    $q->param('failback', lc($props->{'FAILBACK'}));
    $q->param('auto_start_on_new_cluster',
	lc($props->{'AUTO_START_ON_NEW_CLUSTER'}));
    $q->param('rg_dependencies', split(/,/, $props->{'RG_DEPENDENCIES'}));
    $q->param('primaries_list', $props->{'NODELIST'});
    if ($props->{'GLOBAL_RESOURCES_USED'} eq "*") {
	$q->param('global_resources_used', 'all');
    } elsif ($props->{'GLOBAL_RESOURCES_USED'} eq "") {
	$q->param('global_resources_used', 'none');
    }
    print $q->_script($q->yoke_jscript("rg-$rg"));

} elsif (defined($q->param('doedit'))) {
    my ($rg) = $q->param('rg');
    $rg_obj->header($q, [$title, "/cgi-bin/rg/rg_view.pl",
	    gettext("Modify Group Properties")], "rg");
    print $q->_script($q->yoke_jscript("rg-$rg"));

} else {
    $rg_obj->header($q, [$title, "/cgi-bin/rg/rg_view.pl",
	    gettext("Create Resource Group")], "rg");
    print $q->_script($q->yoke_jscript("rg"));
}

print $q->_script($q->orderbox_jscript());

# construct the available & selected node scrolling lists
my $spacer = "____________________";
my @clustnodeslist = (@nodelist,"ignoreMe"); # noI18N
my @availnodeslist;
my @selectednodeslist;
my %nodelistlabels;
foreach my $node (@nodelist) {
  $nodelistlabels{$node} =  $node;
}
$nodelistlabels{"ignoreMe"} = $spacer; # noI18N

# preserve selected nodes list from simple page if going to detailed page
# else construct default lists with non-selectable (ignorable  spacers)

my $primaries_list_string;
if (defined($q->param('primaries_list'))) {
  $primaries_list_string = $q->param('primaries_list');
  my @primlist = split /,/, $primaries_list_string;

  # avail == clusternodes - already selected nodes
  my $tmpnode;
  foreach $tmpnode (@nodelist) {
  if (index ($primaries_list_string,$tmpnode) == -1) {
     @availnodeslist = (@availnodeslist, $tmpnode);
   }
  } # foreach
  @availnodeslist =    (@availnodeslist,"ignoreMe");
  @selectednodeslist = (@primlist,"ignoreMe");
} else {
  @availnodeslist = (@clustnodeslist);
  @selectednodeslist = ("ignoreMe");
}

if (defined($q->param('doit')) && !defined($q->param('edit'))) {
    # Create the resource group

    my ($rg) = $q->param('rg');

    if ($rg eq "") {
	&errmsg("Resource group name must be specified");
	$rg_obj->view_button($q);
	$Cluster::common::q = $q;
	$rg_obj->footer($q);
	exit;
    }

    my ($cmd, $err, $ret, @rg_dep_list, $rg_dep_string);

    $cmd = "-a -g $rg";
    
    if (defined($q->param('desired_primaries')) &&
	    $q->param('desired_primaries') != 1) {
	$cmd .= " -y desired_primaries=".$q->param('desired_primaries');
    }
    
    if (defined($q->param('maximum_primaries')) &&
	    $q->param('maximum_primaries') != 1) {
	$cmd .= " -y maximum_primaries=".$q->param('maximum_primaries');
    }

    if (defined($q->param('rg_description')) && $q->param('rg_description') ne "") {
	$cmd .= " -y RG_description=\"".$q->param('rg_description')."\"";
    }
    
    if (defined($q->param('pathprefix')) &&
	    $q->param('pathprefix') ne "/") {
	$cmd .= " -y Pathprefix=\"".$q->param('pathprefix')."\"";
    }

    if (defined($q->param('rg_project_name')) &&
	    $q->param('rg_project_name') ne "default") {
	$cmd .= " -y RG_project_name=\"".$q->param('rg_project_name')."\"";
    }

    if (defined($q->param('failback')) && $q->param('failback') eq "true") {
	$cmd .= " -y Failback=True";
    }

    if (defined($q->param('auto_start_on_new_cluster')) &&
	    $q->param('auto_start_on_new_cluster') eq "false") {
	$cmd .= " -y Auto_start_on_new_cluster=False";
    }


    if (defined($q->param('pingpong_interval')) && $q->param('pingpong_interval') != 3600) {
	$cmd .= " -y Pingpong_interval=".$q->param('pingpong_interval');
    }

    if (defined($q->param('global_resources_used')) &&
	    $q->param('global_resources_used') ne "all") {
	$cmd .= " -y Global_resources_used=\"\"";
    }

    if (defined($q->param('implicit_network_dependencies')) &&
	    $q->param('implicit_network_dependencies') eq "false") {
	$cmd .= " -y Implicit_network_dependencies=False";
    }

    if (defined($q->param('rg_dependencies'))) {
	@rg_dep_list = $q->param('rg_dependencies');
       
	foreach $rg (@rg_dep_list) {
	    if (!defined($rg_dep_string)) {
		$rg_dep_string = $rg;
	    } else {
		$rg_dep_string .= ",$rg";
	    }
	}
	
	$cmd .= " -y rg_dependencies=".$rg_dep_string;
    }

    if (defined($q->param('primaries_list'))) {
      $primaries_list_string = $q->param('primaries_list');
	if(length ($primaries_list_string) > 0) {
	   $cmd .= " -h $primaries_list_string ";
        }
    }

    $ret = &runsuid("scrgadm $cmd");

    if ($ret != 0) {
	&errmsg(sprintf(gettext("Resource group %s could not be created."),
		$rg));
	print "$result\n";


    } else {
	&okmsg(sprintf(gettext("Resource group %s successfully created."),
		$rg));
	&reloadmenu($q);
	print $q->_script($q->yoke_jscript("rg-$rg"));
    }
    $rg_obj->view_button($q);
    $Cluster::common::q = $q;

} elsif (defined($q->param('doedit'))) {
    # Modify the resource group

    my ($cmd, $err, $ret);

    my ($changed) = 0;

    my ($rg) = $q->param('rg');
    my ($props) = $rg_obj->get_rg_properties($rg);

    $cmd = "-c -g $rg";

    my (@fields) = ("RG_DESCRIPTION", "FAILBACK",
	"MAXIMUM_PRIMARIES", "DESIRED_PRIMARIES",
	"PINGPONG_INTERVAL", "PATHPREFIX",
	"AUTO_START_ON_NEW_CLUSTER", "RG_PROJECT_NAME");

    if (`uname -r` =~ /5.8/) {
	# No RG_PROJECT_NAME on Solaris 8
	@fields = grep !/RG_PROJECT_NAME/, @fields;
    }

    foreach my $field (@fields) {
	my ($lcfield) = lc($field);
	if (defined($q->param($lcfield)) &&
		lc($q->param($lcfield)) ne lc($props->{$field})) {
	    $cmd .= " -y ".$lcfield."=\"".$q->param($lcfield)."\"";
	    $changed = 1;
	}
    }

    # global resources used is a special case
    if ($q->param('global_resources_used') eq "all") {
	if ($props->{'GLOBAL_RESOURCES_USED'} ne "*") {
	    $cmd .= " -y Global_resources_used=\"*\"";
	    $changed = 1;
	}
    } else {
	if ($props->{'GLOBAL_RESOURCES_USED'} ne "") {
	    $cmd .= " -y Global_resources_used=\"\"";
	    $changed = 1;
	}
    }

    # Handle nodelist
    my ($nodelist) = $q->param('primaries_list');
    if ($nodelist ne $props->{'NODELIST'}) {
	$cmd .= " -y Nodelist=$nodelist";
	$changed = 1;
    }

    # Handle rg dependencies
    my ($rgdeps) = "";
    if (defined($q->param('rg_dependencies'))) {
	$rgdeps = join(",", $q->param('rg_dependencies'));
    }
    if ($rgdeps ne $props->{'RG_DEPENDENCIES'}) {
	$cmd .= " -y Rg_dependencies=$rgdeps";
	$changed = 1;
    }

    if ($changed == 0) {
	&errmsg(gettext("Nothing changed"));
	print "$result\n";
	$rg_obj->view_button($q);
	$Cluster::common::q = $q;
	$rg_obj->footer($q);
	return;
    }

    $ret = &runsuid("scrgadm $cmd");

    if ($ret != 0) {
	&errmsg(sprintf(gettext("Resource group %s could not be modified."),
		$rg));
	print "$result\n";


    } else {
	&okmsg(sprintf(gettext("Resource group %s successfully modified."),
		$rg));
	print $q->_script($q->yoke_jscript("rg-$rg"));
    }
    $rg_obj->view_button($q);
    $Cluster::common::q = $q;
} elsif (defined($q->param('full')) || defined($q->param('edit'))) {
    # Display full information

    my ($rg) = $q->param('rg');

    # Start the form
    print $q->start_form({ ACTION => "/cgi-bin/rg/rg_add.pl",
			   METHOD => "POST"
			   });

    # Start the action table
    $q->start_action_table();

    # General properties
    $q->start_action_tr();
    $q->start_action_td({COlSPAN => 2});
    print $q->CGI::div({CLASS => "action-window-label-text"}, 
	gettext("General Properties:"));
    $q->end_action_td();
    $q->end_action_tr();

    # Input rg name
    $q->start_action_tr();
    $q->start_action_td();
    print $q->CGI::div({CLASS => "action-window-table-normal-text"},
	gettext("Resource Group Name:"));
    $q->end_action_td();
    $q->start_action_td();
    if (defined($q->param('edit'))) {
	# Can't edit resource group name
	print $rg;
	print $q->input ({ type => "hidden",
			   name => "rg",
			   value => $rg});
    } else {
	print $q->textfield({ NAME => "rg",
			  SIZE => 30
			  });
    }
    $q->end_action_td();
    $q->end_action_tr();

    $q->start_action_tr();
    $q->start_action_td();
    print $q->CGI::div({CLASS => "action-window-table-normal-text"},
	gettext("Description:"));
    $q->end_action_td();
    $q->start_action_td();
    print $q->textfield({ NAME => "rg_description",
		      SIZE => 30
		      });
    $q->end_action_td();
    $q->end_action_tr();


    $q->start_action_tr();
    $q->start_action_td();
    print $q->CGI::div({CLASS => "action-window-table-normal-text"},
	gettext("Pathprefix Directory:"));
    $q->end_action_td();
    $q->start_action_td();
    print $q->textfield({ NAME => "pathprefix",
		      SIZE => 30,
		      DEFAULT => "/",
		      });
    $q->end_action_td();
    $q->end_action_tr();

    if (`uname -r` !~ /5.8/) {
	# Input RG project name if not Solaris 8
	$q->start_action_tr();
	$q->start_action_td();
	print $q->CGI::div({CLASS => "action-window-table-normal-text"},
	    gettext("Project name:"));
	$q->end_action_td();
	$q->start_action_td();
	print $q->textfield({ NAME      => "rg_project_name",
			  SIZE      => 30,
			  });
	$q->end_action_td();
	$q->end_action_tr();
    }

    $q->start_action_tr();
    $q->start_action_td({COlSPAN => 2});
    print $q->CGI::div({CLASS => "action-window-label-text"},
	gettext("Nodes:"));
    $q->end_action_td();
    $q->end_action_tr();

    # Input primaries
    $q->start_action_tr();
    $q->start_action_td({ VALIGN => "top" });
    print $q->CGI::div({CLASS => "action-window-table-normal-text"},
	gettext("Primaries List:"));
    $q->end_action_td();
    $q->start_action_td();

	# print "<br> -- WIDGET START DETAILS 2 --<br>";

    print $q->start_table({ BORDER => 0 });
    print $q->start_Tr();
    print $q->start_td();
    print $q->CGI::div({CLASS => "action-window-table-normal-text"},
	gettext("Available Nodes"));
    print $q->end_td();

    print $q->start_td();
    print $q->end_td();

    print $q->start_td();
    print $q->CGI::div({CLASS => "action-window-table-normal-text"},
	gettext("Selected Nodes"));
    print $q->end_td();
    print $q->end_Tr();

    print $q->start_Tr();
    print $q->start_td();
    # The following hidden input carries data from the selected nodes list
    print $q->input ({ type => "hidden",
		       name => "primaries_list" });

    print $q->scrolling_list({ single => "true",
			       size => "9",
			       name => "availnodes",
			       values => \@availnodeslist,
			       labels => \%nodelistlabels
			     });
    print $q->end_td();
    print $q->start_td();

    print $q->input({ type => "button",
		      value => gettext("   Add >>  "),
		      onclick => "horizontal_shift(this.form.availnodes, this.form.selnodes);
				  bundleListAsInput(this.form.selnodes,this.form.primaries_list)" });
		      print $q->br();
    print $q->input({ type => "button",
		      value => gettext("<< Remove"),
		      onclick => "horizontal_shift(this.form.selnodes, this.form.availnodes);
				  bundleListAsInput(this.form.selnodes,this.form.primaries_list)" });
    print $q->end_td();
    print $q->start_td();
    print $q->scrolling_list({ single => "true",
			       size => "9",
			       name => "selnodes",
			       values => \@selectednodeslist,
			       labels => \%nodelistlabels
			     });
    print $q->end_td();

    print $q->start_td();

    print $q->input({ type => "button",
		      value => gettext("  Up  "),
		      onclick => "vertical_shift(this.form.selnodes,0);
				  bundleListAsInput(this.form.selnodes,this.form.primaries_list)" });
		      print $q->br();
    print $q->input({ type => "button",
		      value => gettext("Down"),
		      onclick => "vertical_shift(this.form.selnodes,1);
				  bundleListAsInput(this.form.selnodes,this.form.primaries_list)" });
    print $q->end_td();

    print $q->end_Tr();
    print $q->end_table();

	# print "<br> -- WIDGET DETAILS END --<br>";

    $q->end_action_td();
    $q->end_action_tr();

    if (!defined($q->param('edit')) ||
	    lc($q->param('rg_mode')) eq "scalable") {
	# Input desired primaries if new group or scalable group
	$q->start_action_tr();
	$q->start_action_td();
	print $q->CGI::div({CLASS => "action-window-table-normal-text"},
	    gettext("Desired Primaries:"));
	$q->end_action_td();
	$q->start_action_td();
	print $q->textfield({ NAME      => "desired_primaries",
			  DEFAULT	    => "1",
			  SIZE      => 2,
			  MAXLENGTH => 2
			  });
	$q->end_action_td();
	$q->end_action_tr();

	# Input maximum primaries
	$q->start_action_tr();
	$q->start_action_td();
	print $q->CGI::div({CLASS => "action-window-table-normal-text"},
	    gettext("Maximum Primaries:"));
	$q->end_action_td();
	$q->start_action_td();
	print $q->textfield({ NAME      => "maximum_primaries",
			  DEFAULT	    => "1",
			  SIZE      => 2,
			  MAXLENGTH => 2
			  });
	$q->end_action_td();
	$q->end_action_tr();
    }

    # Input automatic failback
    $q->start_action_tr();
    $q->start_action_td();
    print $q->CGI::div({CLASS => "action-window-table-normal-text"},
	gettext("Automatic Failback:"));
    $q->end_action_td();
    $q->start_action_td();
    my (%truefalse) = (false => gettext("False"), true => gettext("True"));
    print $q->popup_menu({ NAME	=> "failback",
		      VALUES	=> ["true", "false"],
		      LABELS	=> \%truefalse,
		      DEFAULT => "false",
		      });
    $q->end_action_td();
    $q->end_action_tr();

    # Input pingpong interval
    $q->start_action_tr();
    $q->start_action_td();
    print $q->CGI::div({CLASS => "action-window-table-normal-text"},
	gettext("Pingpong Interval:"));
    $q->end_action_td();
    $q->start_action_td();
    print $q->textfield({ NAME      => "pingpong_interval",
		      VALUE	    => "3600",
		      SIZE      => 10,
		      });
    print gettext("Seconds");
    $q->end_action_td();
    $q->end_action_tr();

    # Dependencies
    $q->start_action_tr();
    $q->start_action_td({COlSPAN => 2});
    print $q->CGI::div({CLASS => "action-window-label-text"}, 
	gettext("Dependencies:"));
    $q->end_action_td();
    $q->end_action_tr();

    if (defined($q->param('edit'))) {
	# Remove self from potential dependency list
	@rglist = grep !/^$rg$/, @rglist;
    }
    # Input rg dependencies
    $q->start_action_tr();
    $q->start_action_td({ VALIGN => "top" });
    print $q->CGI::div({CLASS => "action-window-table-normal-text"},
	gettext("Resource Groups:"));
    $q->end_action_td();
    $q->start_action_td();

    print $q->checkbox_group({ NAME      => "rg_dependencies",
			       VALUES    => \@rglist,
			       LINEBREAK => "true"
			       });
    $q->end_action_td();
    $q->end_action_tr();

    $q->start_action_tr();
    $q->start_action_td();
    print $q->CGI::div({CLASS => "action-window-table-normal-text"},
	gettext("Global Resources Used:"));
    $q->end_action_td();
    $q->start_action_td();
    my (%allnone) = (all => gettext("All"), none => gettext("None"));
    print $q->popup_menu({ NAME => "global_resources_used",
		      VALUES	=> ["all", "none"],
		      LABELS	=> \%allnone,
		      DEFAULT=> "all",
		      });
    $q->end_action_td();
    $q->end_action_tr();

    # Input network dependencies
    if (!defined($q->param('edit'))) {
	$q->start_action_tr();
	$q->start_action_td();
	print $q->CGI::div({CLASS => "action-window-table-normal-text"},
	    gettext("Implicit Network Dependencies:"));
	$q->end_action_td();
	$q->start_action_td();
	print $q->popup_menu({ NAME	=> "implicit_network_dependencies",
			  VALUES	=> ["true", "false"],
			  LABELS	=> \%truefalse,
			  DEFAULT	=> "true",
			  });
	$q->end_action_td();
	$q->end_action_tr();
    }

    # Input auto start on new cluster
    $q->start_action_tr();
    $q->start_action_td();
    print $q->CGI::div({CLASS => "action-window-table-normal-text"},
	gettext("Automatic Start on New Cluster:"));
    $q->end_action_td();
    $q->start_action_td();
    print $q->popup_menu({ NAME	=> "auto_start_on_new_cluster",
		      VALUES	=> ["true", "false"],
		      LABELS	=> \%truefalse,
		      DEFAULT => "true",
		      });
    $q->end_action_td();
    $q->end_action_tr();

    # End the table
    $q->end_action_table();

    # Start the action button table
    $q->start_action_button_table();
    $q->start_action_tr({ HEIGHT  => 15 });
    $q->start_action_td({ COLSPAN => 2 });
    print $q->img({ SRC    => "/images/dot.gif",
		    ALT    => "",
		    HEIGHT => 1,
		    WIDTH  => 1
		    });
    $q->end_action_td();
    $q->end_action_tr();

    $q->start_action_tr({ HEIGHT  => 1 });
    $q->start_action_td({ COLSPAN => 2,
			  CLASS => "action-line-row"
			  });
    print $q->img({ SRC    => "/images/dot.gif",
		    ALT    => "",
		    HEIGHT => 1
		    });
    $q->end_action_td();
    $q->end_action_tr();

    $q->start_action_tr({ HEIGHT  => 6 });
    $q->start_action_td({ COLSPAN => 2,
			  HEIGHT  => 5
			  });
    print $q->img({ SRC    => "/images/dot.gif",
		    ALT    => "",
		    HEIGHT => 6
		    });
    $q->end_action_td();
    $q->end_action_tr();

    $q->start_action_tr();
    $q->start_action_td({ ALIGN => "RIGHT",
			  WIDTH => "80%" 
			  });
    if (defined($q->param('edit'))) {
	print $q->input({ TYPE => "SUBMIT",
			  NAME => "doedit",
			  onclick => "bundleListAsInput(this.form.selnodes,this.form.primaries_list)",
			  VALUE => gettext(" Modify Group Properties ")
			  });
    } else {
	print $q->input({ TYPE => "SUBMIT",
			  NAME => "doit",
			  onclick => "bundleListAsInput(this.form.selnodes,this.form.primaries_list)",
			  VALUE => gettext(" Create Resource Group ")
			  });
    }
    $q->end_action_td();
    $q->start_action_td({ ALIGN => "RIGHT",
			  WIDTH => "20%" 
			  });
    print $q->input({ TYPE => "BUTTON",
		      VALUE => gettext(" Cancel "),
		      ONCLICK => "history.back()"
		      });
    $q->end_action_tr();
    $q->end_action_td();

    # End the table
    $q->end_action_table();

    # End the form
    print $q->end_form();
} else {
    # Start the form
    print $q->start_form({ ACTION => "/cgi-bin/rg/rg_add.pl",
			   METHOD => "POST"
			   });

    # Start the action table
    $q->start_action_table();

    # Input rg name
    $q->start_action_tr();
    $q->start_action_td();
    print $q->CGI::div({CLASS => "action-window-label-text"}, 
	gettext("Resource Group Name:"));
    $q->end_action_td();
    $q->start_action_td();
    print $q->textfield({ NAME => "rg",
		      SIZE => 10
		      });
    $q->end_action_td();
    $q->end_action_tr();

    # Input primaries
    $q->start_action_tr();
    $q->start_action_td({ VALIGN => "top" });
    print $q->CGI::div({CLASS => "action-window-label-text"}, 
	gettext("Primaries List:"));
    $q->end_action_td();

    $q->start_action_td();

	# print "<br> -- WIDGET START SIMPLE 1 --<br>";

    print $q->start_table({ BORDER => 0 });
    print $q->start_Tr();
    print $q->start_td();
    print $q->CGI::div({CLASS => "action-window-table-normal-text"},
	gettext("Available Nodes"));
    print $q->end_td();

    print $q->start_td();
    print $q->end_td();

    print $q->start_td();
    print $q->CGI::div({CLASS => "action-window-table-normal-text"},
	gettext("Selected Nodes"));
    print $q->end_td();
    print $q->end_Tr();

    print $q->start_Tr();
    print $q->start_td();
    # The following hidden input carries data from the selected nodes list
    print $q->input ({ type => "hidden",
		       name => "primaries_list" });

    print $q->scrolling_list({ single => "true",
			       size => "9",
			       name => "availnodes",
			       values => \@availnodeslist,
			       labels => \%nodelistlabels
			     });
    print $q->end_td();
    print $q->start_td();

    print $q->input({ type => "button",
		      value => gettext("   Add >>  "),
		      onclick => "horizontal_shift(this.form.availnodes, this.form.selnodes);
				  bundleListAsInput(this.form.selnodes,this.form.primaries_list)" });
		      print $q->br();
    print $q->input({ type => "button",
		      value => gettext("<< Remove"),
		      onclick => "horizontal_shift(this.form.selnodes, this.form.availnodes);
				  bundleListAsInput(this.form.selnodes,this.form.primaries_list)" });
    print $q->end_td();
    print $q->start_td();
    print $q->scrolling_list({ single => "true",
			       size => "9",
			       name => "selnodes",
			       values => \@selectednodeslist,
			       labels => \%nodelistlabels
			     });
    print $q->end_td();

    print $q->start_td();

    print $q->input({ type => "button",
		      value => gettext("  Up  "),
		      onclick => "vertical_shift(this.form.selnodes,0);
				  bundleListAsInput(this.form.selnodes,this.form.primaries_list)" });
		      print $q->br();
    print $q->input({ type => "button",
		      value => gettext("Down"),
		      onclick => "vertical_shift(this.form.selnodes,1);
				  bundleListAsInput(this.form.selnodes,this.form.primaries_list)" });
    print $q->end_td();

    print $q->end_Tr();
    print $q->end_table();

	# print "<br> -- WIDGET SIMPLE END --<br>";

    $q->end_action_td();
    $q->end_action_tr();


    # Input desired primaries
    $q->start_action_tr();
    $q->start_action_td();
    print $q->CGI::div({CLASS => "action-window-label-text"}, 
	gettext("Desired Primaries:"));
    $q->end_action_td();
    $q->start_action_td();
    print $q->textfield({ NAME      => "desired_primaries",
		      VALUE	    => "1",
		      SIZE      => 2,
		      MAXLENGTH => 2
		      });
    $q->end_action_td();
    $q->end_action_tr();

    # Input maximum primaries
    $q->start_action_tr();
    $q->start_action_td();
    print $q->CGI::div({CLASS => "action-window-label-text"}, 
	gettext("Maximum Primaries:"));
    $q->end_action_td();
    $q->start_action_td();
    print $q->textfield({ NAME      => "maximum_primaries",
		      VALUE	    => "1",
		      SIZE      => 2,
		      MAXLENGTH => 2
		      });
    $q->end_action_td();
    $q->end_action_tr();

    # End the table
    $q->end_action_table();

    # Start the action button table
    $q->start_action_button_table();
    $q->start_action_tr({ HEIGHT  => 15 });
    $q->start_action_td({ COLSPAN => 2 });
    print $q->img({ SRC    => "/images/dot.gif",
		    ALT    => "",
		    HEIGHT => 1,
		    WIDTH  => 1
		    });
    $q->end_action_td();
    $q->end_action_tr();

    $q->start_action_tr({ HEIGHT  => 1 });
    $q->start_action_td({ COLSPAN => 2,
			  CLASS => "action-line-row"
			  });
    print $q->img({ SRC    => "/images/dot.gif",
		    ALT    => "",
		    HEIGHT => 1
		    });
    $q->end_action_td();
    $q->end_action_tr();

    $q->start_action_tr({ HEIGHT  => 6 });
    $q->start_action_td({ COLSPAN => 2,
			  HEIGHT  => 5
			  });
    print $q->img({ SRC    => "/images/dot.gif",
		    ALT    => "",
		    HEIGHT => 6
		    });
    $q->end_action_td();
    $q->end_action_tr();

    $q->start_action_tr();
    $q->start_action_td({ ALIGN => "RIGHT",
			  WIDTH => "80%" 
			  });
    print $q->input({ TYPE => "SUBMIT",
		      NAME => "full",
                      onclick => "bundleListAsInput(this.form.selnodes,this.form.primaries_list)",
		      VALUE => gettext(" Configure Additional Properties ")
		      });
    print "&nbsp;";
    print $q->input({ TYPE => "SUBMIT",
		      NAME => "doit",
                      onclick => "bundleListAsInput(this.form.selnodes,this.form.primaries_list)",
		      VALUE => gettext(" Create Resource Group ")
		      });
    $q->end_action_td();
    $q->start_action_td({ ALIGN => "RIGHT",
			  WIDTH => "20%" 
			  });
    print $q->input({ TYPE => "BUTTON",
		      VALUE => gettext(" Cancel "),
		      ONCLICK => "history.back()"
		      });
    $q->end_action_tr();
    $q->end_action_td();

    # End the table
    $q->end_action_table();

    # End the form
    print $q->input({ TYPE  => "HIDDEN",
		      NAME  => "func",
		      VALUE => "create"
		      });
    print $q->end_form();
}

# End the html document
$rg_obj->footer($q);
