#!/usr/perl5/bin/perl -w
#
# Copyright 2001-2003 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
#ident	"@(#)process.pl	1.13	03/02/26 SMI"
#
# Cluster Process page

require 5.005;
use strict;
use lib '/opt/SUNWscvw/lib/perl';
use Cluster::Cgi;
use Cluster::RBAC;
use Cluster::Process;
use Sun::Solaris::Utils qw(gettext);

# Create the html query object
my $q = new Cluster::Cgi;

# Create the rbac object
my $rbac = new Cluster::RBAC;

# Create a Process object
my $process = new Cluster::Process;

# Get the node to print the processes for
my $node = $q->param("node");
if (!defined $node || $node eq "") {
	$node = $process->get_hostname();
}

# Print the query header and make the page expire now
print $q->header(-expires => "now");

# Start the document
print $q->start_html({ STYLE  => { 'src' => '/css/clustmgr-style.css'},
		       TITLE  => gettext("Node Processes"),
		       CLASS  => "default-body",
		       SCRIPT => "top.helpMarker=\"process-top\"\n" . $q->jump_menu_jscript() . $q->yoke_jscript("np-$node")
		       });

# Check for node read authorization
if (!$rbac->check_auth($CL_AUTH_NODE_READ)) {
	$rbac->auth_error($q, [gettext("Nodes"), undef, $node, undef,
			       gettext("Processes")]);
	exit;
}

##############################################################################
#
# Action Bar Table
#
##############################################################################

# Start the action bar table
$q->start_action_bar_table([gettext("Nodes"), "/cgi-bin/node/node_status.pl",
	    $node, "/cgi-bin/node/node_info.pl?node=$node",
	    gettext("Processes")],
	    undef,
	    {ALIGN => "right", WIDTH => "99%", NOWRAP => undef});

# Print the telnet link to the node
$q->telnet_link($node);

# Print the middle of the action table
$q->mid_action_bar_table();

# End the action bar table
$q->end_action_bar_table();

##############################################################################
#
# Content Table
#
##############################################################################

# Print the processes for the selected node in a table
$process->process_table($q, $node);

# End the html document
$process->footer($q);
