#!/usr/perl5/bin/perl -w
#
# Copyright 2001-2003 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
#ident	"@(#)network_view.pl 1.12	03/02/26 SMI"
#
# Network view page
#

require 5.005;
use strict;
use lib '/opt/SUNWscvw/lib/perl';
use Cluster::Cgi;
use Cluster::RBAC;
use Cluster::Network;
use Sun::Solaris::Utils qw(gettext);

# Create the html query object
my $q = new Cluster::Cgi;

# Create a network object
my $network = new Cluster::Network;

# Create the rbac object
my $rbac = new Cluster::RBAC;

# Get the parameters
my $node = $q->param("node");

# Print the query header and make the page expire now
print $q->header(-expires => "now");

# Start the document
print $q->start_html({  TITLE => gettext("View Network"),
			STYLE  => { 'src' => '/css/clustmgr-style.css'},
                        CLASS  => "default-body",
			ONUNLOAD => $q->unregister_jscript(),
                        SCRIPT => "top.helpMarker=\"network_view-top\"\n" . $q->jump_menu_jscript() . $q->yoke_jscript("nf-$node") .
    $q->refresh_jscript('content', 'ESC_cluster_ipmp')
                        });

# Check for node read authorization
if (!$rbac->check_auth($CL_AUTH_NODE_READ)) {
	$rbac->auth_error($q, [gettext("Nodes"), undef, $node, undef,
			       gettext("IPMP Groups")]);
	exit;
}

$network->network_header($q,
    [gettext("Nodes"), "/cgi-bin/node/node_status.pl",
    $node, "/cgi-bin/node/node_info.pl?node=$node",
    gettext("IPMP Groups")], $node);
$network->nafogroups_table($q, $node);

# 
# End the html document
$network->footer($q);
