#!/usr/perl5/bin/perl -w
#
# Copyright 2001-2003 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
#ident   "@(#)menu.pl 1.16     03/02/26 SMI"
#
# Create the Javascript or HTML cluster menu

require 5.005;
use strict;
use lib '/opt/SUNWscvw/lib/perl';
use Cluster::Cgi;
use Cluster::Menu;
use Cluster::RBAC;
use Cluster::Common;
use Sun::Solaris::Utils qw(gettext);

# Create objects
my $q = new Cluster::Cgi;
my $menu = new Cluster::Menu;
my $rbac = new Cluster::RBAC;
my $cluster = new Cluster::Common;

# Set autoflush
$| = 1;

# Set the mode
my $mode = "";
if (defined $q->param("mode")) {
	$mode = $q->param("mode");
}

# Print the CGI header and make the page expire now
print $q->header(-expires => "now");

# Print the correct menu type
if ($mode eq "basic") {

	print $q->start_html({ STYLE  => { 'src' => '/css/clustmgr-style.css'},
			       TITLE    => gettext("MenuTree"),
			       CLASS    => "tree-body",
			       ONRESIZE => "if (document.layers) " .
					   "self.location.reload(true)"
			       });
	# Basic HTML menu 
	$menu->getClusterName($q, $mode, $cluster->get_clustername());
	$menu->getNodes($q, $mode);
	$menu->getResourceGroups($q, $mode);
	$menu->getTransports($q, $mode);
	$menu->getGlobalDevices($q, $mode);
	$menu->getQuorum($q, $mode);

} else { 
	print $q->start_html({ STYLE  => { 'src' => '/css/clustmgr-style.css'},
			       TITLE    => gettext("MenuTree"),
			       CLASS    => "tree-body",
			       ONRESIZE => "if (document.layers) " .
					   "self.location.reload(true)",
			       SCRIPT	=>
    $q->refresh_jscript('menu',
	    'ESC_cluster_rg_config_change,'.
	    'ESC_cluster_r_config_change,'.
	    'ESC_cluster_quorum_config_change')
			       });

	# Invisible accessibility link to simplified menu
	print $q->a({href => "/cgi-bin/index.pl?menu=basic", target => "_top"},
		$q->img({src => "/images/dot.gif", width => 1, height => 1,
		    border => 0, align => "right",
		    alt => gettext("Load simplified menu")}));

	# Load the Javascript libraries
	print $q->start_script({ SRC => '/js/menutree.js' });
	print $q->end_script();

	print $q->start_script({ SRC => '/js/browserVersion.js' });
	print $q->end_script();

	# Print the Javascript tree
	print $q->start_script();
	print "USETEXTLINKS = 1\n";
	$menu->getClusterName($q, $mode, $cluster->get_clustername());

	# Print the nodes menu if the user has solaris.cluster.node.read
	if ($rbac->check_auth($CL_AUTH_NODE_READ)) {
		$menu->getNodes($q, $mode);
	}

	# Print the rg menu if the user has solaris.cluster.resource.read
	if ($rbac->check_auth($CL_AUTH_RESOURCE_READ)) {
		$menu->getResourceGroups($q, $mode);
	}

	# Print the rg menu if the user has solaris.cluster.transport.read
	if ($rbac->check_auth($CL_AUTH_TRANSPORT_READ)) {
		$menu->getTransports($q, $mode);
	}

	# Print the rg menu if the user has solaris.cluster.device.read
	if ($rbac->check_auth($CL_AUTH_DEVICE_READ)) {
		$menu->getGlobalDevices($q, $mode);
	}

	# Print the rg menu if the user has solaris.cluster.quorum.read
	if ($rbac->check_auth($CL_AUTH_QUORUM_READ)) {
		$menu->getQuorum($q, $mode);
	}
	print "initializeDocument()";
	print $q->end_script();
}

# End the document
print $q->end_html;
