#!/usr/perl5/bin/perl -w
#
# Copyright 2002-2003 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
# ident	"@(#)showlog.pl	1.2	03/01/09 SMI"
#
# Show the specified log file from the specified node

require 5.005;
use strict;
use lib '/opt/SUNWscvw/lib/perl';
use Cluster::Cgi;
use Cluster::Install;
use Sun::Solaris::Utils qw(gettext);

# Create the html query object
my $q = new Cluster::Cgi;
my $install = new Cluster::Install;

# Get the node and filename to read
my $node = $q->param("node");
my $file = $q->param("file");

# Set the title
my $title = sprintf(gettext("Validation Report from %s"), $node);

# Print the cgi header
print $q->header();
print $q->start_html({ TITLE => $title,
		       STYLE => { SRC => "/css/clustmgr-style.css" }
		       });

# Set the log prefix
my $path = "/var/cluster/spm/$file";

# Start the table which shows the banner
print $q->start_table({ WIDTH => "100%",
			BORDER => 0,
			CELLSPACING => 0,
			CELLPADDING => 0,
			BGCOLOR => "#000000"
			});
print $q->start_Tr();
print $q->start_td();

# Start the inner table which shows the title & close button
print $q->start_table({ WIDTH => "100%", BORDER => 0 });
print $q->start_Tr();
print $q->start_td();
print $q->start_font({ COLOR => "white", SIZE => "+2" });
print $title;
print $q->end_font();
print $q->end_td();

print $q->start_td({ ALIGN => "right", VALIGN=> "bottom", NOBREAK => undef });

# Show the print link
print $q->start_a({ onmouseover => "window.status='Print'; return true",
		    title => gettext("Click to print this report"),
		    target => "_top",
		    alt => gettext("Click to print this report"),
		    class => "masthead-link-text",
		    href => "javascript:window.print()"
		    });

print gettext("Print");
print $q->end_a();

# Separator
print $q->start_font({ CLASS => "masthead-link-divider" });
print " | ";
print $q->end_font();

# Show the close window link
print $q->start_a({ onmouseover => "window.status='Close'; return true",
		    title => gettext("Click to close this window"),
		    target => "_top",
		    alt => gettext("Click to close this window"),
		    class => "masthead-link-text",
		    href => "javascript:window.close()"
		    });
print gettext("Close");
print $q->end_a();
print $q->end_td();
print $q->end_Tr();
print $q->end_table();

print $q->end_td();
print $q->end_Tr();

print $q->start_Tr({ HEIGHT => 1, BGCOLOR => "#FFFFFF" });
print $q->start_td({ HEIGHT => 1 });
print $q->img({ SRC => "/images/dot.gif", HEIGHT => 1 });
print $q->end_td();
print $q->end_Tr();

print $q->start_Tr({ HEIGHT => 14, BGCOLOR => "#666699" });
print $q->start_td({ HEIGHT => 14 });
print $q->img({ SRC => "/images/dot.gif", HEIGHT => 1 });
print $q->end_td();
print $q->end_Tr();
print $q->end_table();
print $q->br();

# Get the file
my @lines = $install->readfile_node($node, $path);
foreach my $line (@lines) {
	print $line . $q->br() . "\n";
}

# End the html document
$install->footer($q);
