#!/usr/perl5/bin/perl
#
# Copyright 2001-2002 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
# ident	"@(#)sccheck_step1.pl	1.3	03/01/10 SMI"
#
# sccheck installation

require 5.005;
use strict;
use lib '/opt/SUNWscvw/lib/perl';
use Cluster::Cgi;
use Cluster::Install;
use Sun::Solaris::Utils qw(gettext);

# Set constants
use constant TRUE          => 0;
use constant FALSE         => 1;

# Set autoflush
$| = 1;

# Set pfexec path
my $PFEXEC = "/usr/bin/pfexec";

# Remove the BASEDIR environment variables
delete @ENV{'BASEDIR', 'CLIENT_BASEDIR'};

# Create the html query object
my $q = new Cluster::Cgi;

# Create a install object
my $install = new Cluster::Install;

# Start the html document
$install->header($q, [gettext("Sun Cluster Installation"),
		      "/cgi-bin/installation/step0.pl",
		      gettext("Validate Cluster Configuration " .
			      "(Step 7 of 8)")]);
print $q->p({class => "action-window-normal-text"});

# Get the list of nodes we're installing
my @nodelist = $install->get_nodelist($q);
my $clustersize = $#nodelist + 1;

# Create a nodelist string
my $nodestring = join ',', @nodelist;

# Get the log directory to use
my $logdir = $install->get_logdir();

# Check if Sun Cluster is already installed
my $sc_installed=0;
foreach my $node (@nodelist) {
    if ($install->get_install_state($node, "DONE_SCINSTALL_I") eq 'YES') {
        $install->syslog("Sun Cluster has already been installed on $node.");
        $sc_installed++;
    }
}

# Install Sun Cluster software packages
if ($sc_installed != $clustersize) {
    print gettext("Installing Sun Cluster framework packages...");

    foreach my $node (@nodelist) {
	my $pkgadd = "/cgi-bin/installation/scinstall.pl";
	$pkgadd .= "?cdrom_path=" . $q->param('cdrom_path') .
		"&mode=install_sccheck";
	$install->syslog("Running 'scinstall -i' on $node");
	$install->get_http($node,
			   $install->get_http_port(),
			   $pkgadd);
    }
    # Wait for the scinstall -i
    my $pkgadd_complete = 0;
    while ($pkgadd_complete == 0) {
	$pkgadd_complete = 1;
	foreach my $node (@nodelist) {
		if ($install->get_install_state($node,
			"DONE_SCINSTALL_I") ne 'YES') {
			$install->syslog("'scinstall -i' has NOT " .
					 "finished on $node");
			$pkgadd_complete = 0;
			last;
		} else {
			$install->syslog("scinstall -i' has " .
					 "finished on $node");
		}
	}
	print ".";
	sleep(5);
    }

    print $q->br(), $q->br();
}

# Print info
print gettext("This step allows you to run sccheck(1M) to verify that " .
	      "certain basic hardware and software pre-configuration " .
	      "requirements have been met. If potential problems are " .
	      "detected when configuring this machine as a " .
	      "cluster node, a list of warnings will be printed. Data " .
	      "gathering and report generation can take several " .
	      "minutes, depending on system configuration.");

# Print the form
print $q->start_form({ action => '/cgi-bin/installation/step5.pl' });
print $q->start_table({ cellpadding => 5,
			class => "action-table"});
print $q->start_Tr(), $q->start_td({nowrap => undef});
print $q->start_div({ class => "action-window-label-text" });
print gettext("Do you want to validate the cluster configuration?");
print $q->end_div(), $q->end_td();

print $q->start_td();

print $q->radio_group({ name => 'run_sccheck',
			values => ['yes', 'no'],
			default => 'yes',
			# linebreak => 'false',
			labels => { yes => gettext(" Yes "), 
				    ### part of radio group
				    no => gettext(" No ") }
			            ### part of radio group
			});

print $q->end_td();
print $q->end_Tr();

# End the table
print $q->end_table();

# Print the hidden cluster fields
$q->print_hidden_cluster_fields();

$install->start_button_table($q);

print $q->button({ value   => gettext("  < Back  "),
		   onClick => "history.back()"
		   });

# Put spaces between the buttons
print "&nbsp;" ;

print $q->submit({ name  => 'submit_step_3',
		   value => gettext("  Next >  ")
		   });
$install->end_button_table($q, "cancel");

# End the form
print $q->end_form();
