#!/usr/perl5/bin/perl -w
#
# Copyright 2001-2002 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
# ident	"@(#)ds_step1.pl	1.24	03/01/07 SMI"
#
# Data Service Install Step 1

require 5.005;
use strict;
use lib '/opt/SUNWscvw/lib/perl';
use Cluster::Cgi;
use Cluster::Install;
use Sun::Solaris::Utils qw(gettext);

# Set constants
use constant TRUE          => 0;
use constant FALSE         => 1;

# Set autoflush
$| = 1;

# Create the html query object
my $q = new Cluster::Cgi;

# Create a install object
my $install = new Cluster::Install;

# Grab the query string and make a modified copy in case
# case we want to go out via redirect, or 'retry' or 'skip SDS' buttons.
my $query_string = $q->get_cluster_query_string();
my $query_string_no_sds = $query_string;
$query_string_no_sds =~ s/install_sds=yes/install_sds=no/;

# Redirect if we're not installing SDS, Apache, NFS
if ($q->param("install_sds") eq "no") {
    print $q->redirect("/cgi-bin/installation/step4.pl$query_string");
    exit;
}

# Start the html document
$install->header($q, [gettext("Sun Cluster Installation"),
		      "/cgi-bin/installation/step0.pl",
		      gettext("Data Services (Step 5 of 8)")],
		 undef,
		 "function sds_retry() {
                        self.location = \"ds_step1.pl"
		        . $query_string . "\"
                 }
                 function sds_continue() {
                       self.location = \"ds_step1.pl"
		       . $query_string_no_sds . "\"
                 }");

print $q->p({class => "action-window-normal-text"});

# SDS/SLVM autodiscovery -- call get_ctd_disks() to get all of the
# shared disks on a node. Then, run config_sds to create the metasets
# based on that information.
print gettext("Validating volume manager configuration...")."<br><br>\n";
my @errors = ();
$install->get_ctd_disks($q);
my @sdsoutput = $install->config_sds($q);
if ($#sdsoutput > -1) {
	push @errors, @sdsoutput; 
}

#
# Verify /sds
#
foreach my $node ($install->get_nodelist($q)) {    
  my @sds = $install->verify_sds($node);

  if ($#sds > -1) {
	  push @errors, @sds; 
  }
} # foreach node

# If we found errors, print them
if ($#errors > -1) {
    if ($install->is_solaris8() == TRUE) {
	    $install->start_message_table($q, "/images/error_32.gif",
		  gettext("Error"),
		  gettext("Incorrect Partition Configuration"),
		  gettext("The following errors occurred when validating " .
			  "partitions for Solstice DiskSuite:"));
    } else {
	    $install->start_message_table($q, "/images/error_32.gif",
		  gettext("Error"),
		  gettext("Incorrect Partition Configuration"),
		  gettext("The following errors occurred when validating " .
			  "partitions for the Solaris Volume Manager:"));
    }

    foreach my $error (@errors) {
	print $q->start_b(), $error, $q->end_b(), $q->br();
    }

    $install->end_message_table($q);
    print $q->p({class => "action-window-normal-text"});

    if ($install->is_solaris8() == TRUE) {
	    print gettext("Either fix the volume manager configuration " .
			  "problems and press the \"Retry\" button or " .
			  "press the \"Skip SDS\" button to continue " .
			  "<B>without</B> installing Solstice Disksuite. " .
			  "If you do not install Solstice Disksuite and ".
			  "configure mirrored disksets, you will not be " .
			  "able to install either the Scalable Apache or " .
			  "HA NFS data services.");
    } else {
	    print gettext("Either fix the volume manager configuration " .
			  "problems and press the \"Retry\" button or " .
			  "press the \"Skip SVM\" button to continue " .
			  "<B>without</B> configuring Solaris Volume " .
			  "Manager disksets. Without mirrored disksets " .
			  "you will not be able to install either the " .
			  "Scalable Apache or HA NFS data services.");
    }

    print $q->br(), $q->br();

    $install->start_button_table($q);

    print $q->start_form();
    print $q->button({ value   => gettext("  < Back  "),
		       onClick => "history.back()"
		       });
    print "&nbsp";
    print $q->button({ value => gettext("  Retry  "),
		       onClick => "sds_retry()"
		     });
    print "&nbsp";

    if ($install->is_solaris8() == TRUE) {
	    print $q->button({ value => gettext("  Skip SDS > "),
			       onClick => "sds_continue()"
			       });
    } else {
	    print $q->button({ value => gettext("  Skip SVM > "),
			       onClick => "sds_continue()"
			       });
    }

    $install->end_button_table($q, "cancel");

    print $q->end_form();
    
    # End the html document
    $install->footer($q);

    # Exit gracefully
    exit(0);
}

print gettext("Select whether to install NFS and Apache. If you choose ".
    "to install NFS, you must enter the name of the logical host that ".
    "NFS will use. Similarly, if you choose to install Scalable Apache, ".
    "you must enter the name of the shared address that Apache will use. " .
    "If you choose to install either Apache or NFS, an IP Network " .
    "Multipathing (IPMP) failover group will be created on each node to " .
    "host the associated logical hostname or shared address. In order to " .
    "configure the IPMP failover group, you must enter one additional " .
    "address, per node, which will be used as the test address for the " .
    "group. For more information about IPMP failover groups, see the " .
    "ifconfig(1M) man page.");

# Get global values
my $cluster_name = $q->param('cluster_name');

# Print the form
print $q->start_form({ action => '/cgi-bin/installation/step4.pl' });
print $q->start_table({	CELLPADDING => 5,
			CELLSPACING => 0,
			CLASS => "action-table",
			});

print $q->start_Tr();
print $q->start_td({	NOWRAP => undef});

print $q->CGI::div({CLASS => "action-window-label-text"},
    gettext("Would you like to install NFS? "));

print $q->end_td();
print $q->start_td();

print $	q->radio_group( -name => 'install_nfs',      
			-values => ['yes','no'],                  
			-default => 'yes',
			-labels => { yes => gettext(" Yes "),  ### part of radio group
				    no => gettext(" No ") }    ### part of radio group
			);

print $q->end_td();
print $q->end_Tr();

# NFS address
print $q->start_Tr();
print $q->start_td({	NOWRAP => undef});

print $q->CGI::div({CLASS => "action-window-label-text"},
    gettext("NFS Logical Hostname: "));

print $q->end_td();
print $q->start_td();

print $q->textfield({ name    => 'nfs_address', 
		      size    => 25,
		  });

print $q->end_td();
print $q->end_Tr();

print $q->start_Tr(), $q->start_td({COLSPAN => 2, NOWRAP => undef});
print "&nbsp;\n";
print $q->end_td(), $q->end_Tr(), "\n";

# Install apache?
print $q->start_Tr();
print $q->start_td({	NOWRAP => undef});

print $q->CGI::div({CLASS => "action-window-label-text"},
    gettext("Would you like to install Apache? "));

print $q->end_td();
print $q->start_td();

print $q->radio_group(-name => 'install_apache',  
		      -values => ['yes', 'no'],          
		      -default => 'yes',
			  -labels => { yes => gettext(" Yes "),  ### part of radio group
				    no => gettext(" No ") }  ### part of radio group
		      );

print $q->end_td();
print $q->end_Tr();

# Apache address
print $q->start_Tr();
print $q->start_td({	NOWRAP => undef});

print $q->CGI::div({CLASS => "action-window-label-text"},
    gettext("Apache Shared Address: "));

print $q->end_td();
print $q->start_td();

print $q->textfield({ name    => 'apache_address', 
		      size    => 25,
		      });

print $q->end_td();
print $q->end_Tr();

# Start the ipmp test address entries
print $q->start_Tr();
print $q->start_td({ NOWRAP => undef,
		     COLSPAN => 2 });
print $q->br(), $q->br();
print $q->CGI::div({CLASS => "action-window-label-text"},
    gettext("IPMP Failover Group Test Addresses"));

print $q->end_td();
print $q->end_Tr();

for (my $i=1; $i<=$q->param('cluster_size'); $i++) {
    print $q->start_Tr();
    print $q->start_td({ NOWRAP => undef});
    print $q->CGI::div({CLASS => "action-window-label-text"},
		       sprintf(gettext("%s test address: "),
			       $q->param("node_$i.name")));
    print $q->end_td();

    print $q->start_td();
    print $q->textfield({ name => "node_$i.testaddr",
			  size => 25 });
    print $q->end_td();
    print $q->end_Tr();
}

# End the table
print $q->end_table(); 

$install->start_button_table($q);

print $q->button({ value   => gettext("  < Back  "),
		   onClick => "history.back()"
		   });


# Put spaces between the buttons
print "&nbsp;" ;

print $q->submit({ name  => 'submit_step_3',
		   value => gettext("  Next >  ")
		   });
# Print the hidden cluster fields
$q->print_hidden_cluster_fields();

$install->end_button_table($q, "cancel");

# End the form
print $q->end_form();

# End the html document
$install->footer($q);
