#!/usr/perl5/bin/perl -w
#
# Copyright 2001-2003 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
#ident   "@(#)device_config.pl 1.11     03/04/28 SMI"
#
# Device group config page
#

require 5.005;
use strict;
use lib '/opt/SUNWscvw/lib/perl';
use Cluster::Cgi;
use Cluster::RBAC;
use Cluster::Device;
use Sun::Solaris::Utils qw(gettext);

# Create the html query object
my $q = new Cluster::Cgi;

# Create a device object
my $device = new Cluster::Device;

# Create the rbac object
my $rbac = new Cluster::RBAC;

my $step = $q->param('step');
my $devicegroup = $q->param('devicegroup');
my $func = $q->param('func');
my $primary = $q->param('primary');
my @diskpaths = $q->param('diskpath');

# Set the page title
my $title = gettext("Global Devices");

# Check if in Cluster mode
if ($device->is_clustermode($q) != 0) {
        # not in cluster mode
        $device->print_nonclustermode_error($q);
        exit;
}

print $q->header();

my $menu_jscript = $q->jump_menu_jscript();
my $device_jscript = $device->device_jscript();
my $jscript = $menu_jscript . "\n" . $device_jscript .
    $q->yoke_jscript("d-$devicegroup");

# Start the document
print $q->start_html({  TITLE => $title,
			STYLE  => { 'src' => '/css/clustmgr-style.css'},
                        CLASS  => "default-body",
                        SCRIPT => $jscript
                        });

# Check for device modify or admin authorization
if ((($func eq "Remove" || $func eq "Props") &&
     !$rbac->check_auth($CL_AUTH_DEVICE_MODIFY)) ||
    (($func eq "Online" || $func eq "Offline" ||
      $func eq "Monitor" || $func eq "Unmonitor") &&
     !$rbac->check_auth($CL_AUTH_DEVICE_ADMIN))) {
	$rbac->auth_error($q, $title);
	exit;
}

# Read the configuration and status into memory if needed
$device->get_commandoutput();

SWITCH: {
	#if ($action eq "Remove") {
	#	$device->config_remove($q, $type, $name);
	#	last SWITCH;
	#}
	if ($func eq "Offline") {
		$device->config_offline($q, $step, $devicegroup);
		last SWITCH;
	}
	if ($func eq "Online") {
		$device->config_online($q, $step, $devicegroup, $primary);
		last SWITCH;
	}
	if ($func eq "Props") {
		$device->config_props($q, $step, $devicegroup, $primary);
		last SWITCH;
	}
	if ($func eq "Monitor") {
		$device->config_monitor($q, $step, @diskpaths);
		last SWITCH;
	}
	if ($func eq "Unmonitor") {
		$device->config_unmonitor($q, $step, @diskpaths);
		last SWITCH;
	}
}

# End the html document
$device->footer($q);
