/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class RGDisplay
extends Cluster {
    private int numRG;
    private RG[] groups;

    RGDisplay(Applet applet) {
        super(applet);
        this.rgImage = applet.getImage(applet.getCodeBase(), "images/rg_24.gif");
        this.mt.addImage(this.rgImage, 0);
        this.loadImages();
    }

    public void drawDisplay(Graphics graphics) {
        int[] nArray = new int[this.numNodes];
        int n = 0;
        while (n < this.numNodes) {
            nArray[n] = 0;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.numRG) {
            this.groups[n2].draw(graphics, n2, nArray);
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.numNodes) {
            this.nodes[n3].draw(graphics);
            ++n3;
        }
    }

    protected void fetchData() {
        this.getNodes();
        try {
            URL uRL = new URL(String.valueOf(String.valueOf(this.applet.getCodeBase())) + "cgi-bin/rg/rg.pl");
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setUseCaches(false);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
            String string = bufferedReader.readLine();
            Integer n = Integer.valueOf(string);
            this.numRG = n;
            this.groups = new RG[this.numRG];
            int n2 = 0;
            n2 = 0;
            while (n2 < this.numRG) {
                string = bufferedReader.readLine();
                this.groups[n2] = new RG(string, (Cluster)this);
                this.groups[n2].setURL(String.valueOf(String.valueOf(this.applet.getCodeBase())) + "cgi-bin/rg/rg_view.pl?rg=" + string);
                ++n2;
            }
            n2 = 0;
            n2 = 0;
            while (n2 < this.numNodes) {
                this.nodes[n2].rgLoc = new String[this.numRG];
                ++n2;
            }
            n2 = 0;
            int n3 = 0;
            while ((string = bufferedReader.readLine()) != null) {
                if (n2 == this.numNodes) {
                    ++n3;
                    n2 = 0;
                }
                this.nodes[n2].rgLoc[n3] = string;
                ++n2;
            }
            bufferedReader.close();
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Caught URL exception");
        }
        catch (IOException iOException) {
            System.err.println("Caught IOException " + iOException);
        }
    }

    private int findRG(int n, int n2) {
        int n3 = 0;
        while (n3 < this.numRG) {
            int n4 = this.findNode(n - 50, n2 - n3 * 32);
            if (n4 != -1) {
                int n5 = 0;
                int n6 = 0;
                while (n5 < n3) {
                    if (!this.nodes[n4].rgLoc[n6].equals("0")) {
                        ++n5;
                    }
                    ++n6;
                }
                return n6;
            }
            ++n3;
        }
        return -1;
    }

    public void mouseAction(MouseEvent mouseEvent, boolean bl) {
        int n = this.findNode(mouseEvent.getX(), mouseEvent.getY());
        if (n != -1) {
            this.performMouseAction(mouseEvent, this.nodes[n].rurl, this.nodes[n].msg(), bl);
            return;
        }
        n = this.findRG(mouseEvent.getX(), mouseEvent.getY());
        if (n != -1) {
            this.performMouseAction(mouseEvent, this.groups[n].url, this.groups[n].msg(), bl);
            return;
        }
        this.performMouseAction(mouseEvent, null, null, bl);
    }

    public void registerEvents(EventMonitor eventMonitor) {
        eventMonitor.register("topology", "ESC_cluster_rg_,ESC_cluster_r_");
    }

    protected void setPositions() {
        int n = this.applet.getSize().height;
        int n2 = this.applet.getSize().width;
        double d = this.numNodes <= 2 ? Math.PI / (double)(this.numNodes + 1) : Math.PI / (double)(this.numNodes - 1);
        int n3 = 0;
        while (n3 < this.numNodes) {
            double d2 = this.numNodes <= 2 ? Math.PI - (double)n3 * d - d : Math.PI - (double)n3 * d;
            double d3 = (double)(n / 2) - 0.65 * (double)n * 0.5 * Math.sin(d2);
            double d4 = (double)(n2 / 2) + 0.65 * (double)n2 * 0.5 * Math.cos(d2);
            int n4 = 65;
            int n5 = 15;
            if (n3 == 0) {
                n4 += 15;
                n5 -= 15;
            }
            if (n3 == this.numNodes - 1) {
                n4 -= 15;
                n5 -= 15;
            }
            if (this.numNodes == 4 && (n3 == 0 || n3 == 3)) {
                n5 -= 40;
            }
            this.nodes[n3].setPos((int)d4 - n4, (int)d3 - n5);
            ++n3;
        }
    }
}

