#!/bin/sh
# (c) 2002 Sun Microsystems, Inc. Use is subject to license terms.  
#
# shutdown of MPI conforming with the CODINE/GRD
# Parallel Environment interface
#

#-----------------------------------
# KillTree
KillTree()
{
#
# Kill all the remaining processes 
# related to a given CRE Job ID
# using the output generated by "terminate_method"
#
cat $1 | while read cmd; do
    host=`echo $cmd | nawk '{print $3}'`
    plist="`$cmd | grep -v spmd | nawk '{print $1}'`"
    exec rsh -n $host kill -9 $plist
done
}

#
# Just remove machine-file that was written by startmpi.sh
#
rm $TMPDIR/machines

#
# Clean-up any remaining, if any, MPI processes
#
if [ -s $TMPDIR/ptree.list ]; then
   myptree=$TMPDIR/ptree.list
   KillTree $myptree
#
#  Delete all temporary files
#
   /bin/rm  $myptree
fi

rshcmd=rsh
case "$ARC" in
   hp|hp10|hp11|hp11-64) rshcmd=remsh ;;
   *) ;;
esac
if [ -s $TMPDIR/$rshcmd ]; then
   rm $TMPDIR/$rshcmd
fi

exit 0
