#!/bin/sh 
# (c) 2002 Sun Microsystems, Inc. Use is subject to license terms.  
#
# Resume an MPI job when its parent batch job is resumed
#
# It assumes that CRE JID is saved by suspend method.
#
#----------------
cre_jid=`cat $TMPDIR/resume_cre_jid`
job_pid=$1

#
# Resume the CRE job
#
/opt/SUNWhpc/bin/mpkill -CONT $cre_jid
#
# Resume the job script
#
kill -CONT -$job_pid 

#
# Delete the CRE job id file
#
/bin/rm $TMPDIR/resume_cre_jid

# signal success to caller
exit 0
