package TO::SWITCH2;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use Agent::SWITCH2;
use strict;
use TO;
use TO::FCSWITCH;
use base 'TO::FCSWITCH';

sub leaf { 1 }
sub type { "switch2"};

sub getDevStatus {
  my($class, $dev) = @_;
  return Agent::SWITCH2->getDevStatus($dev);
}

sub getLocalPortWWN {
  my($class, $V, $dev, $x) = @_;
  return sprintf("20%2.2x%s", $x, substr($dev->{wwn},4));
}

sub getZones {
   my($class, $dev, $ZO) = @_;
   my $ip = $dev->{ipno};

   my $err = Agent::SWITCH2->getZones(System->get_home() . "/sbin", $ip, 20, $ZO, $dev);
}



sub statusFunc {
  my($class, $name, $State, $arg, $node) = @_;

  my $Comp = $State->components();
  my $i = $Comp->value("$name:e");
  my $enc = $i->[0];
  my $encInfo = $i->[1];
  my ($disk, $diskInfo, @t1, @f1, @p1, $x);

  for ($x=1; $x <= 5; $x++) {
    push(@t1, $Comp->value("$name:sensor.temperature.$x"));
  }
  for ($x=1; $x <= 6; $x++) {
    push(@f1, $Comp->value("$name:sensor.fan.$x"));
  }
  for ($x=1; $x <= 2; $x++) {
    push(@p1, $Comp->value("$name:sensor.power-supply.$x"));
  }
  my ($other, $otherInfo) = TO->valArray(\@f1, \@p1, \@t1);

  my($port, $portInfo);
  my $pi = $node->portInfo();
  for ($x=0; $x <= $#$pi; $x++) {
       $port     .= $Comp->value("$name:port.$x",0) . ",";
       $portInfo .= $Comp->value("$name:port.$x",1) . ",";
  }

  return ($enc, $port, $disk, $other, $encInfo,
          $portInfo, $diskInfo, $otherInfo);

}



1;
