package TO::SWITCH;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use strict;
use TO;
use Agent::SWITCH;
use TO::PARENTSWITCH;
use base 'TO::PARENTSWITCH';


# old qlogic 
sub type {"switch"}
sub leaf { 1 }


sub newFromDev {
  my($class, $Topo, $host, $dev) = @_;
  my($x);
  my $name = "switch:$dev->{wwn}";
  my $new = 0;

  my($switches) = $Topo->[1];
  my($syns)     = $Topo->[4];
  my $renv      = System->get_renv();
  my $P = $renv->{solution_prefix} || "XX";
  my $err;
  if (!defined($switches->{$name})) {
     $new= 1;
     my($obj) = {};
     $obj->{info}{name}    = $name;
     $obj->{info}{type}    = "switch";
     $obj->{info}{BoxName} = $dev->{name};
     $obj->{info}{mgmtLevel} = $dev->{mgmtLevel} || "D";
     $obj->{info}{class}   = "switch.switch";
     $obj->{info}{sw_WWN}  = $dev->{wwn};
     if (substr($dev->{ipno},0,length($P)) eq $P && $dev->{host}) {
       $obj->{info}{proxy}   = $dev->{host};
     }
     $obj->{info}{sw_ipAddr} = $dev->{ipno};
     $obj->{info}{sw_ipAddr_remote} = $dev->{ipno};
     $obj->{info}{sw_remote_fcaddr} = "0x0";
     if ($dev->{primary}) {
       $obj->{info}{sw_ipAddr_remote} = $dev->{primary};
       $obj->{info}{sw_remote_fcaddr} = "0x". $dev->{fc};
     }
     $obj->{port} = [];
     my $V = Agent::SWITCH->getDevStatus($dev);

     my $port_cnt = $V->{'version.ports'};
     $obj->{info}{ProductID} = ($dev->{userLabel} || "Switch") . "-$port_cnt";

     for ($x=1; $x <= $port_cnt; $x++) {
        my $local = sprintf("20%2.2x%s", $x-1, substr($dev->{wwn},4));
#'port.5.link_port' => 10
#'port.5.link_wwn' => '100000c0dd008849'
        my $rem   = $V->{"port.$x.link_wwn"};
        $syns->{$local} = "$name:$x";
        $obj->{portInfo}[$x] = { 
                sw_PortType   => $V->{"port.$x.type"},
                sw_PortNum    => $x,
                sw_PortState  => lc($V->{"port.$x.mode"}),
                PortWWN       => $rem, 
                LocalPortWWN  => $local,
                PortFC        => $V->{"port.$x.link_fc"},
                 };
        #if ($V->{"port.$x.link_port"}) {
        #   $obj->{portInfo}[$x]{PortTargetPort} = $V->{"port.$x.link_port"};
        #   $obj->{port}[$x] = 'switch:' . $V->{"port.$x.link_wwn"} . ":" . 
        #                      $V->{"port.$x.link_port"}
        #}
     }
     $obj->{info}{host} = $host;
     $obj->{info}{host_type} = "oob";
     
     $obj->{info}{portCount} = $port_cnt;
     bless($obj, 'TO::SWITCH');

     my $ip = $obj->ip();
     my $ZO = {};
     $err = Agent::SWITCH->getZones(System->get_home() . "/bin", $ip, 20, $ZO);
     foreach my $k (keys %$ZO) {
        my($a, $t, $no) = split(/\./, $k);
        $obj->{zones}{$t}[$no] = $ZO->{$k};
     }
     $syns->{$dev->{wwn}} = $name;
     $switches->{$name}  = $obj;
  }
  return ($new ,$switches->{$name}, $err);
}

#'port.5.link_fc' => 100900
#'port.5.link_port' => 10
#'port.5.link_wwn' => '100000c0dd008849'
#'port.5.mode' => 'Online'

sub addFromConfig {
  my($class, $topo, $Config) = @_;
  my $err;
  my $devs = $Config->devices();
  my $renv = $Config->renv();

  foreach my $dev (@$devs) {
     next if ($dev->{type} ne "switch");
     my $k = $dev->{type} . ":" . $dev->key();
     my $node = $topo->nodeByName($k);

     if ($node && $node->info("sw_remote_fcaddr") ne "0x0") {
       my $info = $node->info();
       $info->{host} = $dev->{host} || $renv->{hostname};
       $info->{sw_remote_fcaddr} = "0x0";
       $info->{sw_ipAddr_remote} = $info->{sw_ipAddr};
       my $pi = $node->portInfo();
       foreach my $pi0 (@$pi) {
          if (exists $pi0->{sw_remote_fcaddr}) {
             $pi0->{sw_remote_fcaddr} = "0x0";
             $pi0->{sw_ipAddr_remote} = $info->{sw_ipAddr};
          }
       }
     }

     next if (!$dev->isMineToMonitor());
     if (!$node) {
       $dev->{host} = $renv->{hostname} if (!$dev->{host});
       $dev->{mgmtLevel} = $dev->{mgmtLevel};

       my($new, $name, $err0) = $class->newFromDev($topo, $renv->{hostname}, $dev);
       $err .= "$err0 " if $err0;
     }
  }
  return $err;
}



sub new {
  my($class, $SW, $Topo, $host, $dinfo) = @_;
  my( $size, $name );
  my($new) = 0;
  my $renv      = System->get_renv();
  my $Config    = PDM::ConfigFile->read();

#  $dinfo->{sw_WWN} = $SW->{$dinfo->{sw_ipAddr}} if (!$dinfo->{sw_WWN});

  if ($dinfo->{sw_WWN}) {
    $name = "switch:$dinfo->{sw_WWN}";
  } else {
    $name = "switch:" . $SW->{$dinfo->{sw_ipAddr}};
  }

  my $d1 = $Config->deviceByKey(substr($name,7));
  if (!$d1 && $renv->{show_monitored_only} eq "Y") {
      Discman->setError($Topo, "switch", "$name", "switch is not monitored, skipping!");
      return (0, 0);
  }

  my($switches) = $Topo->[1];
  my($syns)     = $Topo->[4];

  if (!defined($switches->{$name})) {
     $new= 1;
     my($obj) = {};
     $obj->{info}{name} = $name;
     $obj->{info}{type} = "switch";
     $obj->{info}{mgmtLevel} = $d1->{mgmtLevel};
     $obj->{info}{class} = "switch.switch";
     $obj->{info}{host} = $host;
     foreach my $k (keys %$dinfo) {
       $obj->{info}{$k} = $dinfo->{$k};
     }
     $obj->{info}{portCount} = $dinfo->{sw_MaxPorts};
     bless($obj, 'TO::SWITCH');

     my $ip = $obj->ip();
     my $ZO = {};
     my $err = Agent::SWITCH->getZones(System->get_home() . "/bin", $ip, 20, $ZO);
     foreach my $k (keys %$ZO) {
        my($a, $t, $no) = split(/\./, $k);
        $obj->{zones}{$t}[$no] = $ZO->{$k};
     }
     $syns->{$dinfo->{sw_WWN}} = $name;
     $switches->{$name}  = $obj;
  }
  return ($new ,$switches->{$name});
}

sub iconLayout {
  my($sw, $orient) = @_;
  return "F0D8D8/switch2.gif,FPT,Fan/Power/Temp,$orient" ; # ,h = horiz switch
}


sub statusFunc {
  my($class, $name, $State, $arg, $node) = @_;

  my $Comp = $State->components();
  my $i = $Comp->value("$name:e");
  my $enc = $i->[0];
  my $encInfo = $i->[1];
  my ($disk, $diskInfo);

  my $f1 = $Comp->value("$name:chassis.fan.1");
  my $f2 = $Comp->value("$name:chassis.fan.2");

  my $p1 = $Comp->value("$name:chassis.power");

  my $t1 = $Comp->value("$name:chassis.temp");

  my $other = TO->val($f1->[0], $f2->[0]) . "," . $p1->[0] . "," .
              $t1->[0];

  my $otherInfo =  TO->val2(1,$f1, $f2) . "," . $p1->[1] . "," .
                   $t1->[1];

  my($x, $port, $portInfo);
  my $pi = $node->portInfo();

  for ($x=0; $x <= $#$pi; $x++) {
       $port     .= $Comp->value("$name:port.$x",0) . ",";
       $portInfo .= $Comp->value("$name:port.$x",1) . ",";
  }

  return ($enc, $port, $disk, $other, $encInfo,
          $portInfo, $diskInfo, $otherInfo);

}




1;


