package TO::SE;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use base 'TO::STORAGE';
use Agent::SE;
use strict;
sub leaf { 1 }


sub newFromDev {
  my($class, $to, $host, $dev) = @_;

  my $storages  =  $to->[2];
  my $syns      =  $to->[4];
  my $key       = $dev->{key};
  my $name      = "se:$key";

  my $obj = {};
  $obj->{info}{type}    = 'se';
  $obj->{info}{class}   = 'storage.se';
  $obj->{info}{name}    = $name;
  $obj->{info}{BoxName} = $dev->{name} || $dev->{ipno};
  $obj->{info}{host}    = $host;
  $obj->{info}{host_type} = "oob";
  $obj->{info}{VendorID}= "SUN";
  $obj->{info}{LGroup}  = "StorEdge-" . $dev->{model};
  $obj->{info}{PortWWN} = $dev->{wwn};
  $obj->{info}{NodeWWN} = $dev->{wwn};
  $obj->{info}{ipAddr}  = $dev->{ipno};
  $obj->{info}{mgmtLevel}  = $dev->{mgmtLevel};
  $obj->{info}{PG}      = 0;
  
  $obj->{port}          = [];

  my $LINKS = Agent::SE->getLinks($dev, $to);
  $obj->{info}{slotTotal} = $LINKS->{'info.slotTotal'};
  $obj->{info}{portTotal} = $LINKS->{'info.portTotal'};
  my $p;
  for ($p=0; $p < $LINKS->{'info.portTotal'} ; $p++) {
     next if (!$LINKS->{"fcPort.$p.PortWWN"});
     $syns->{"S" . $LINKS->{"fcPort.$p.LocalPortWWN"}}  = "se:$key:$p";
     $obj->{portInfo}[$p]  = {
               PortWWN        => $LINKS->{"fcPort.$p.PortWWN"},
               LocalPortWWN   => $LINKS->{"fcPort.$p.LocalPortWWN"},
               nodeId         => $LINKS->{"fcPort.$p.nodeId"},
               sw_PortType    => $LINKS->{"fcPort.$p.portType"},
              };
  }
  
  bless($obj, 'TO::SE');
  $syns->{$key} = $name;
  $storages->{$name} = $obj;
  return $obj;
}

sub addFromConfig {
  my($class, $topo, $Config) = @_;

  my $devs = $Config->myDevices();
  my $renv = $Config->renv();
  #return if (!$renv->{include_se_device});

  foreach my $dev (@$devs) {
     next if ($dev->{type} ne "se");
     next if (!$dev->isMineToMonitor());
     my $k = $dev->{type} . ":" . $dev->key();
     next if ($topo->nodeByName($k));
     $dev->{host} = $renv->{hostname} if (!$dev->{host});

     $class->newFromDev($topo, $renv->{hostname}, $dev);
  }
}

sub diagramApplet {
  my($class, $name, $Comp, $to) = @_;

  my $Config = PDM::ConfigFile->read();
  my $renv = $Config->renv();
  my $dev = $Config->deviceByKey($name);
  my $width = 305;
  my $height = 232;
  my $gif = "t3_open";
  my $hi = $renv->{gui_bandwidth} || "L";
  if ($dev->{wwn2}) {
    $gif = "t3pg_open";
    $width = 303; $height = 437
  }

  open(O, System->get_home() . "/System/Products/$gif.htm");
  my (%M, $l);
  while ($l = <O>) {
     $l =~ s/"//g;
     if ($l =~ /coords = (\d+),(\d+),(\d+),(\d+)\s+HREF=([^>]+)/) {
        $M{$5} = "$1,$2,$3,$4";
     }
  }
  close(O);
  my $applet =<<EOF;
 <applet code="IMap.class" width=$width height=$height>
 <param name="mapimage" value="/gif/$gif$hi.gif">
 <param name="fgcolor" value="#FFFFFF">
 <param name="bgcolor" value="#666699">
 <param name="alarmFlag" value=1>
 <param name="border" value="1,#FFFFFF">
 <param name="boxSize" value=10>
 <param name="font" value="arial,normal,10">
 <param name="margins" value="5,5">
 <param name="outline" value="#FF0000">
EOF
  my $cnt = 1; my $y;
  foreach my $el (keys %M) {
    my $c = $Comp->{"$name:$el"};
    $applet .= "<param name=shape-$cnt value=\"rect,$M{$el}\">\n";

    if ($c && defined($c->[0])) {
      my $status = $c->[0];
      my $text = $c->[1];
      $applet .= "<param name=\"status-$cnt\" value=$status>\n";
      my $len = 0;
      my $cnt2 = 1;
      my @w = split(/\s+/, $text);
      my $curr = "";
      for ($y=0; $y <= $#w; $y++) {
        my $w1 = $w[$y];
        $curr .= "$w1 ";
        if (length($curr . $w[$y+1]) > 42) {
          $applet .= "<param name=\"text-$cnt-$cnt2\" value=\"$curr\">\n";
          $cnt2++;
          $curr= "";
        }
      }
      if ($curr) {
          $applet .= "<param name=\"text-$cnt-$cnt2\" value=\"$curr\">\n";
      }
    } else {
      $el = ($el eq "e") ? "Comm-OOBand" : ($el eq "ib"? "Comm-InBand": $el);
      $applet .= "<param name=\"text-$cnt-1\" value=\"$el\">\n";
    }
      
    $cnt++;
  }
  $applet .= "</applet>";
  return $applet;
}

sub statusFunc {
  my($class, $name, $State, $arg, $node) = @_;

  my $Comp    = $State->components();
  my $i       = $Comp->value("$name:e");
  my $iIB     = $Comp->value("$name:ib");
  my $enc     = TO->val($i->[0], $iIB->[0]);
  my $encInfo = TO->val2(1,$i, $iIB);

  my($s, $slots, $slotsInfo, $u, $d);

  my $tot = $node->info("slotTotal") || 29;
  for ($s=0; $s <= $tot; $s++) {
     $slots     .= $Comp->value("$name:slot.$s",0) . ",";
     $slotsInfo .= $Comp->value("$name:slot.$s",1) . ",";
  }

  my ($port, $portInfo);

  my $tot = $node->info("portTotal");
  for ($s=0; $s < $tot; $s++) {
     $port      .= $Comp->value("$name:fcPort.$s",0) . ",";
     $portInfo  .= $Comp->value("$name:fcPort.$s",1) . ",";
  }
   
  my($other, $otherInfo);

  $other = $Comp->value("$name:links",0) . ",";
  $otherInfo = $Comp->value("$name:links",1) . ",";


  return ($enc, $port, $slots , $other, $encInfo,
          $portInfo, $slotsInfo, $otherInfo);
    
}



sub ipAddr {
  my($class) = @_;
  return $class->{info}{ipAddr};
}


sub iconLayout {
  my($obj) = @_;
  my ($cat, $label2, $ses);

  my $ports = $obj->portInfo();
  my $pc = $#$ports+1;
  $pc++ if ($pc % 2 == 1);
  my $col = $obj->info("mgmtLevel") eq "D"? "E0F0E0" : "D0D0F0"; 
  $cat = "a,SE,$pc/  ,10/slot,0/1/2,KLNA,Links/Luns/NTC/Alerts,$col/rack.gif";
  $label2 = $obj->{info}{LGroup};
  $ses = 1;
  return ($cat, $label2, $ses);
}




1;
