package TO::INTERNAL;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use base 'TO::STORAGE';
use strict;
use State;
sub leaf { 1 }

sub getPortId {
  my($class, $port) = @_;    # 0 / 1

  if ($port == 0) {
     return 'port.A';
  } else {
     return 'port.B';
  }
}

sub statusFunc {
  my($class, $name, $State) = @_;
  my($type);
  my $Comp = $State->components();
  my $i    = $Comp->value("$name:ib");
  my $enc  = $i->[0];
  my $encInfo = $i->[1];

  my($port, $portInfo, $other, $otherInfo);
  my($disk, $diskInfo);

  ($type, $name) = split(/:/, $name);
  $name = "tape:$name";

  my($p1)   = $Comp->value("$name:port.A");
  $port     = $p1->[0];
  $portInfo =  $p1->[1];

  return ($enc, $port, $disk, $other, $encInfo, $portInfo, $diskInfo, $otherInfo);
}


sub iconLayout {
  my($obj) = @_;
  my $disks = $obj->{diskInfo};
  my @d = keys %$disks;
  my $name = $obj->{info}{name};
  my $ix = index($name, ".");
  $name = substr($name, 0, $ix) if ($ix > 0);
  my $diskCnt = $#d + 1;

  return("a,INT,1,$diskCnt,i,,,D0F0D0/int.gif", $name, 1);
  # a,T3,1/1,9,1,LMPV,Loop/Midplane/Power/Volumes,D0D0F0/t3.gif
}


1;


