package TO::HUB;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use base 'TO::Node';
sub leaf { 1 }

sub new {
  my($class, $Topo, $host, $from, $from_port) = @_;
  my($size);
  my($hubs) = $Topo->[3];
  my(@x) = (keys %$hubs);
  my $h1 = $host;
  my $ix = index($h1, ".");
  $h1 = substr($h1,0,$ix) if ($ix > 0);
  my($name) = "hub:$h1.hub" . ($#x +1);

  if (!defined($hubs->{$name})) {
     my($obj) = {};
     $obj->{info}{type} = 'hub';
     $obj->{info}{class} = 'hub';
     $obj->{info}{name} = $name;
     $obj->{info}{host} = $host;
     $obj->{info}{from} = $from->type() . ":" . $from->key() . ":$from_port"; # for CIM event
     bless($obj, 'TO::HUB');
     $hubs->{$name}   = $obj;
  }
  return $hubs->{$name};
}

sub type { "hub"};




1;
